/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$SanItem;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class DisplayItemFactory$SanItemImpl
implements DisplayItemFactory$SanItem {
    private List emailAddresses = new ArrayList();
    private List ipAddresses = new ArrayList();
    private List dnsNames = new ArrayList();

    public DisplayItemFactory$SanItemImpl(Collection collection) {
        if (collection != null) {
            for (List list : collection) {
                Integer n = (Integer)list.get(0);
                switch (n) {
                    case 1: {
                        this.emailAddresses.add((String)list.get(1));
                        break;
                    }
                    case 7: {
                        this.ipAddresses.add((String)list.get(1));
                        break;
                    }
                    case 2: {
                        this.dnsNames.add((String)list.get(1));
                    }
                }
            }
        }
    }

    public DisplayItemFactory$SanItemImpl(List list, List list2, List list3) {
        this.emailAddresses = list;
        this.dnsNames = list2;
        this.ipAddresses = list3;
    }

    public String getDnsName() {
        return this.dnsNames.size() == 0 ? "" : this.dnsNames.toString();
    }

    public String getEmailAddress() {
        return this.emailAddresses.size() == 0 ? "" : this.emailAddresses.toString();
    }

    public String getIpAddress() {
        return this.ipAddresses.size() == 0 ? "" : this.ipAddresses.toString();
    }

    public CertAttrSet toExtension(boolean bl) throws KeyManagerException {
        try {
            GeneralNames generalNames = this.toGeneralNames();
            if (generalNames.size() == 0) {
                return null;
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            generalNames.encode(derOutputStream);
            return new SubjectAlternativeNameExtension(Boolean.valueOf(bl), (Object)derOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_SAN, iOException, new String[]{iOException.getMessage()});
        }
        catch (GeneralNamesException generalNamesException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.SAN_ENCODING_ERROR, (Throwable)generalNamesException);
        }
    }

    public boolean isEmpty() {
        return !(this.emailAddresses != null && this.emailAddresses.size() != 0 || this.dnsNames != null && this.dnsNames.size() != 0 || this.ipAddresses != null && this.ipAddresses.size() != 0);
    }

    private GeneralNames toGeneralNames() throws IOException {
        GeneralNames generalNames = new GeneralNames();
        if (this.emailAddresses != null) {
            for (String string : this.emailAddresses) {
                if (string.trim().equals("")) continue;
                generalNames.addElement((Object)new GeneralName((GeneralNameInterface)new RFC822Name(string)));
            }
        }
        if (this.dnsNames != null) {
            for (String string : this.dnsNames) {
                if (string.trim().equals("")) continue;
                generalNames.addElement((Object)new GeneralName((GeneralNameInterface)new DNSName(string)));
            }
        }
        if (this.ipAddresses != null) {
            for (String string : this.ipAddresses) {
                if (string.trim().equals("")) continue;
                generalNames.addElement((Object)new GeneralName((GeneralNameInterface)new IPAddressName(string)));
            }
        }
        return generalNames;
    }
}

