/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.io;

import com.ibm.gsk.ikeyman.util.Debug;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public class LockedFileOutputStream
extends OutputStream {
    private FileOutputStream outputStream;

    public LockedFileOutputStream(String string) throws IOException {
        FileLock fileLock;
        this.outputStream = new FileOutputStream(string, true);
        FileChannel fileChannel = this.outputStream.getChannel();
        try {
            fileLock = fileChannel.tryLock();
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            Debug.throwing(overlappingFileLockException);
            this.outputStream.close();
            throw new IOException("Unable to acquire file lock for " + string);
        }
        if (fileLock == null) {
            this.outputStream.close();
            throw new IOException("Unable to acquire file lock for " + string);
        }
        fileChannel.truncate(0L);
    }

    public LockedFileOutputStream(File file) throws IOException {
        this(file.getAbsolutePath());
    }

    public void write(int n) throws IOException {
        this.outputStream.write(n);
    }

    public void close() throws IOException {
        this.outputStream.close();
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }
}

