/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$CommandType;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory$ControlObject;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.ValidatorFactory;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validatable;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validation;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.Displayable;
import com.ibm.gsk.ikeyman.keystore.ext.Displayer;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.Debug;
import java.text.MessageFormat;

class CommandFactory$ListSecretKeysCommand
extends Command {
    public CommandFactory$ListSecretKeysCommand(ParameterMap parameterMap) {
        super(parameterMap, ValidatorFactory.newValidator(new ValidatorFactory$Validation[]{ValidatorFactory.required(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.DatabaseName, Constants$Parameter.TokenLabel, Constants$Parameter.RelativeSlotNumber}), ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Crypto, ValidatorFactory.not(ValidatorFactory.itemPresent(Constants$Parameter.DatabaseName))), ValidatorFactory.optional(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.Password, Constants$Parameter.Stashed}), ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Type, ValidatorFactory.itemPresent(Constants$Parameter.DatabaseName))}), null);
        Debug.entering();
        Debug.exiting();
    }

    public ControlObjectFactory$ControlObject run(CommandParameters commandParameters, KeyManagerEventListener keyManagerEventListener, Displayer displayer) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{commandParameters, keyManagerEventListener, displayer});
        DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor = commandParameters.getSourceDescriptor(CommandFactory.access$200());
        KeyStoreItem keyStoreItem = this.getValidKeystoreItem(databaseDescriptorFactory$DatabaseDescriptor);
        if (!keyStoreItem.supportsEntry(SecretKeyItem.class)) {
            KeyManagerException keyManagerException = new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_TYPE_FOR_ACTION, new String[]{Constants$CommandType.ListSecretKeys.toString(), keyStoreItem.getDescriptor().getType().toString()});
            Debug.throwing(keyManagerException);
            throw keyManagerException;
        }
        Displayable[] displayableArray = keyStoreItem.getEntries(SecretKeyItem.class).toArray(new Displayable[0]);
        if (displayableArray.length > 0) {
            displayer.showMessage(MessageFormat.format(Messages.getString("Message.SecretKeysIn"), databaseDescriptorFactory$DatabaseDescriptor.toString()));
            for (Displayable displayable : displayableArray) {
                displayer.showMessage("   " + (displayable.toString().contains(" ") ? "\"" + displayable.toString() + "\"" : displayable.toString()));
            }
        } else {
            displayer.showMessage(Messages.getString("Message.NoSecretKeyFound"));
        }
        Debug.exiting(null);
        return null;
    }
}

