/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.kerberos.KerberosPrincipal;

class KeyImpl
implements SecretKey,
Destroyable,
Serializable {
    private static final long serialVersionUID = -7889313790214321193L;
    private transient byte[] keyBytes;
    private transient int keyType;
    private transient boolean destroyed = false;

    public KeyImpl(byte[] byArray, int n) {
        this.keyBytes = (byte[])byArray.clone();
        this.keyType = n;
    }

    public KeyImpl(KerberosPrincipal kerberosPrincipal, char[] cArray, String string) {
        try {
            PrincipalName principalName = new PrincipalName(kerberosPrincipal.getName());
            String string2 = new String(cArray);
            int n = 0;
            if (string == null) {
                n = 3;
            } else if (string.equalsIgnoreCase("3DES")) {
                n = 16;
            } else if (string.equalsIgnoreCase("DES")) {
                n = 3;
            } else if (string.equalsIgnoreCase("RC4")) {
                n = 23;
            } else if (string.equalsIgnoreCase("AES256")) {
                n = 18;
            } else if (string.equalsIgnoreCase("AES128")) {
                n = 17;
            } else if (string.equalsIgnoreCase("null")) {
                n = 0;
            } else {
                throw new IllegalArgumentException();
            }
            EncryptionKey encryptionKey = null;
            encryptionKey = n != 0 ? new EncryptionKey(string2, principalName.getSalt(), n) : new EncryptionKey(string2, principalName.getSalt());
            this.keyBytes = encryptionKey.getBytes();
            this.keyType = encryptionKey.getEType();
        }
        catch (KrbException krbException) {
            throw new IllegalArgumentException(krbException.getMessage());
        }
    }

    public final int getKeyType() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.keyType;
    }

    @Override
    public final String getAlgorithm() {
        return this.getAlgorithmName(this.keyType);
    }

    private String getAlgorithmName(int n) {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        if (n == 0) {
            return "NULL";
        }
        if (n == 1 || n == 3) {
            return "DES";
        }
        if (n == 16) {
            return "3DES";
        }
        if (n == 23 || n == 24) {
            return "RC4";
        }
        if (n == 18) {
            return "AES256";
        }
        if (n == 17) {
            return "AES128";
        }
        return "NULL";
    }

    @Override
    public final String getFormat() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return "RAW";
    }

    @Override
    public final byte[] getEncoded() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return (byte[])this.keyBytes.clone();
    }

    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            Arrays.fill(this.keyBytes, (byte)0);
            this.destroyed = true;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.destroyed) {
            throw new IOException("This key is no longer valid");
        }
        try {
            objectOutputStream.writeObject(new EncryptionKey(this.keyType, this.keyBytes).asn1Encode());
        }
        catch (Asn1Exception asn1Exception) {
            throw new IOException(asn1Exception.getMessage());
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            EncryptionKey encryptionKey = new EncryptionKey(new DerValue((byte[])objectInputStream.readObject()));
            this.keyType = encryptionKey.getEType();
            this.keyBytes = encryptionKey.getBytes();
        }
        catch (Asn1Exception asn1Exception) {
            throw new IOException(asn1Exception.getMessage());
        }
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        return new String("EncryptionKey: keyType=" + this.keyType + " keyBytes (hex dump)=" + (this.keyBytes == null || this.keyBytes.length == 0 ? " Empty Key" : '\n' + hexDumpEncoder.encode(this.keyBytes) + '\n'));
    }

    public int hashCode() {
        int n = 17;
        if (this.isDestroyed()) {
            return n;
        }
        n = 37 * n + Arrays.hashCode(this.keyBytes);
        return 37 * n + this.keyType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyImpl)) {
            return false;
        }
        KeyImpl keyImpl = (KeyImpl)object;
        if (this.isDestroyed() || keyImpl.isDestroyed()) {
            return false;
        }
        return this.keyType == keyImpl.getKeyType() && Arrays.equals(this.keyBytes, keyImpl.getEncoded());
    }
}

