/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSACore;
import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.crypto.provider.RSAPadding;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;

public abstract class RSASignature
extends SignatureSpi {
    private static final int a = 8;
    private final ObjectIdentifier b;
    private final int c;
    private final MessageDigest d;
    private boolean e;
    private RSAPrivateKey f;
    private RSAPublicKey g;
    private RSAPadding h;
    private static final String[] z;

    RSASignature(String string, ObjectIdentifier objectIdentifier, int n2) {
        this.b = objectIdentifier;
        try {
            this.d = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        this.e = true;
        this.c = 8 + n2 + this.d.getDigestLength();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)RSAKeyFactory.toRSAKey(publicKey);
        this.f = null;
        this.g = rSAPublicKey;
        this.a(rSAPublicKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey;
        this.f = rSAPrivateKey = (RSAPrivateKey)RSAKeyFactory.toRSAKey(privateKey);
        this.g = null;
        this.a(rSAPrivateKey, secureRandom);
    }

    private void a(RSAKey rSAKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.a();
        int n2 = RSACore.getByteLength(rSAKey);
        try {
            RSAUtil.checkParamsAgainstType((RSAUtil.KeyType)RSAUtil.KeyType.RSA, (AlgorithmParameterSpec)rSAKey.getParams());
        }
        catch (ProviderException providerException) {
            throw new InvalidKeyException(z[0], providerException);
        }
        try {
            this.h = RSAPadding.getInstance(1, n2, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
        int n3 = this.h.getMaxDataSize();
        if (this.c > n3) {
            throw new InvalidKeyException(z[1]);
        }
    }

    private void a() {
        if (!this.e) {
            this.d.reset();
            this.e = true;
        }
    }

    private byte[] b() {
        this.e = true;
        return this.d.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.d.update(by);
        this.e = false;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.d.update(byArray, n2, n3);
        this.e = false;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.d.update(byteBuffer);
        this.e = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.f == null) {
            throw new SignatureException(z[14]);
        }
        byte[] byArray = this.b();
        try {
            byte[] byArray2 = RSASignature.encodeSignature(this.b, byArray);
            byte[] byArray3 = this.h.pad(byArray2);
            byte[] byArray4 = RSACore.rsa(byArray3, this.f, true);
            return byArray4;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException(z[13], generalSecurityException);
        }
        catch (IOException iOException) {
            throw new SignatureException(z[12], iOException);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.g == null) {
            throw new SignatureException(z[4]);
        }
        if (byArray.length != RSACore.getByteLength(this.g)) {
            throw new SignatureException(z[2] + byArray.length + z[3] + RSACore.getByteLength(this.g));
        }
        byte[] byArray2 = this.b();
        try {
            byte[] byArray3 = RSACore.rsa(byArray, this.g);
            byte[] byArray4 = this.h.unpad(byArray3);
            byte[] byArray5 = RSASignature.decodeSignature(this.b, byArray4);
            return MessageDigest.isEqual(byArray2, byArray5);
        }
        catch (BadPaddingException badPaddingException) {
            return false;
        }
        catch (IOException iOException) {
            throw new SignatureException(z[5], iOException);
        }
    }

    public static byte[] encodeSignature(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        new AlgorithmId(objectIdentifier).encode(derOutputStream);
        derOutputStream.putOctetString(byArray);
        DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
        return derValue.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decodeSignature(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray, 0, byArray.length, false);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length != 2) throw new IOException(z[7]);
        if (derInputStream.available() != 0) {
            throw new IOException(z[7]);
        }
        AlgorithmId algorithmId = AlgorithmId.parse((DerValue)derValueArray[0]);
        if (!algorithmId.getOID().equals((Object)objectIdentifier)) {
            throw new IOException(z[9] + algorithmId.getOID());
        }
        if (algorithmId.getEncodedParams() == null) return derValueArray[1].getOctetString();
        throw new IOException(z[8]);
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[6]);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException(z[11]);
        }
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[10]);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[15];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "Vg0\u001c#vmf\u0016*f) \u0012=?[\u0015<ol`!\u0013.k|4\u0018<";
        int n3 = -1;
        block22: while (true) {
            char[] cArray;
            block26: {
                int n4;
                int n5;
                block25: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block25;
                    n5 = n5;
                    if (n5 <= n4) break block26;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 31;
                            break;
                        }
                        case 1: {
                            n6 = 9;
                            break;
                        }
                        case 2: {
                            n6 = 70;
                            break;
                        }
                        case 3: {
                            n6 = 125;
                            break;
                        }
                        default: {
                            n6 = 79;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "Tl?]&l)2\u0012 ?z.\u0012=k) \u0012=?}.\u0014<?z/\u001a!~}3\u000f*?h*\u001a m`2\u0015\"";
                    n3 = 0;
                    continue block22;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "L`!\u0013.k|4\u0018osl(\u001a;w)(\u0012;?j)\u000f=zj2Goxf2]";
                    n3 = 1;
                    continue block22;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "?k3\tohh5]*gy#\u001e;vg!]";
                    n3 = 2;
                    continue block22;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "R`5\u000e&qnf\r:}e/\u001eotl?";
                    n3 = 3;
                    continue block22;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "L`!\u0013.k|4\u0018ozg%\u0012+vg!]*m{)\u000f";
                    n3 = 4;
                    continue block22;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "ll2-.mh+\u0018;z{nToqf2]<jy6\u0012=kl\"";
                    n3 = 5;
                    continue block22;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "LL\u0017(\nQJ\u0003]#zg!\t'?l4\u000f m";
                    n3 = 6;
                    continue block22;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "Jg#\u0005?zj2\u0018+?H*\u001a m`2\u0015\"Vmf\r.mh+\u0018;z{5";
                    n3 = 7;
                    continue block22;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "Pk,\u0018,k@\"\u0018!k` \u0014*m)+\u0014<rh2\u001e'%)";
                    n3 = 8;
                    continue block22;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "xl2-.mh+\u0018;z{nToqf2]<jy6\u0012=kl\"";
                    n3 = 9;
                    continue block22;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "Qff\r.mh+\u0018;z{5].|j#\r;zm";
                    n3 = 10;
                    continue block22;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\\f3\u0011+?g)\tozg%\u0012+z)\"\u001c;~";
                    n3 = 11;
                    continue block22;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\\f3\u0011+?g)\tol`!\u0013o{h2\u001c";
                    n3 = 12;
                    continue block22;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "R`5\u000e&qnf\r=v\u007f'\t*?b#\u0004";
                    n3 = 13;
                    continue block22;
                }
                case 13: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

