/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.JCAUtil;
import com.ibm.crypto.provider.MGF1;
import com.ibm.crypto.provider.RSACore;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public final class RSAPadding {
    public static final int PAD_BLOCKTYPE_1 = 1;
    public static final int PAD_BLOCKTYPE_2 = 2;
    public static final int PAD_NONE = 3;
    public static final int PAD_OAEP_MGF1 = 4;
    public static final int PAD_ZERO = 5;
    private final int a;
    private final int b;
    private SecureRandom c;
    private final int d;
    private MessageDigest e;
    private MGF1 f;
    private byte[] g;
    private static final Map<String, byte[]> h;
    private static final String[] z;

    public static RSAPadding getInstance(int n2, int n3) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n2, n3, null, null);
    }

    public static RSAPadding getInstance(int n2, int n3, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n2, n3, secureRandom, null);
    }

    public static RSAPadding getInstance(int n2, int n3, SecureRandom secureRandom, OAEPParameterSpec oAEPParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n2, n3, secureRandom, oAEPParameterSpec);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RSAPadding(int n2, int n3, SecureRandom secureRandom, OAEPParameterSpec oAEPParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a = n2;
        this.b = n3;
        this.c = secureRandom;
        if (n3 < 64) {
            throw new InvalidKeyException(z[6]);
        }
        switch (n2) {
            case 1: 
            case 2: {
                this.d = n3 - 11;
                return;
            }
            case 3: 
            case 5: {
                this.d = n3;
                return;
            }
            case 4: {
                String string;
                String string2 = string = z[8];
                byte[] byArray = null;
                try {
                    if (oAEPParameterSpec != null) {
                        string = oAEPParameterSpec.getDigestAlgorithm();
                        String string3 = oAEPParameterSpec.getMGFAlgorithm();
                        if (!string3.equalsIgnoreCase(z[3])) {
                            throw new InvalidAlgorithmParameterException(z[2] + string3);
                        }
                        string2 = ((MGF1ParameterSpec)oAEPParameterSpec.getMGFParameters()).getDigestAlgorithm();
                        PSource pSource = oAEPParameterSpec.getPSource();
                        String string4 = pSource.getAlgorithm();
                        if (!string4.equalsIgnoreCase(z[7])) {
                            throw new InvalidAlgorithmParameterException(z[9] + string4);
                        }
                        byArray = ((PSource.PSpecified)pSource).getValue();
                    }
                    this.e = MessageDigest.getInstance(string);
                    this.f = new MGF1(string2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InvalidKeyException(z[4], noSuchAlgorithmException);
                }
                this.g = RSAPadding.a(this.e, byArray);
                int n4 = this.g.length;
                this.d = n3 - 2 - 2 * n4;
                if (this.d > 0) return;
                throw new InvalidKeyException(z[10] + string + z[11] + this.f.a());
            }
        }
        throw new InvalidKeyException(z[5] + n2);
    }

    private static byte[] a(MessageDigest messageDigest, byte[] byArray) {
        byte[] byArray2;
        if (byArray == null || byArray.length == 0) {
            String string = messageDigest.getAlgorithm();
            byArray2 = h.get(string);
            if (byArray2 == null) {
                byArray2 = messageDigest.digest();
                h.put(string, byArray2);
            }
        } else {
            byArray2 = messageDigest.digest(byArray);
        }
        return byArray2;
    }

    public int getMaxDataSize() {
        return this.d;
    }

    public byte[] pad(byte[] byArray, int n2, int n3) throws BadPaddingException {
        byte[] byArray2 = RSACore.convert(byArray, n2, n3);
        byte[] byArray3 = this.pad(byArray2);
        if (byArray2 != byArray) {
            Arrays.fill(byArray2, (byte)0);
        }
        return byArray3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] pad(byte[] byArray) throws BadPaddingException {
        if (byArray.length > this.d) {
            throw new BadPaddingException(z[12] + (this.d + 1) + z[13]);
        }
        switch (this.a) {
            case 3: {
                return byArray;
            }
            case 1: 
            case 2: {
                return this.a(byArray);
            }
            case 4: {
                return this.e(byArray);
            }
            case 5: {
                return this.b(byArray);
            }
        }
        throw new AssertionError();
    }

    public byte[] unpad(byte[] byArray, int n2, int n3) throws BadPaddingException {
        byte[] byArray2 = RSACore.convert(byArray, n2, n3);
        byte[] byArray3 = this.unpad(byArray2);
        if (byArray2 != byArray) {
            Arrays.fill(byArray2, (byte)0);
        }
        return byArray3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] unpad(byte[] byArray) throws BadPaddingException {
        if (byArray.length != this.b) {
            throw new BadPaddingException(z[0]);
        }
        switch (this.a) {
            case 3: {
                return byArray;
            }
            case 1: 
            case 2: {
                return this.c(byArray);
            }
            case 4: {
                return this.f(byArray);
            }
            case 5: {
                return this.d(byArray);
            }
        }
        throw new AssertionError();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(byte[] byArray) throws BadPaddingException {
        byte[] byArray2 = new byte[this.b];
        System.arraycopy(byArray, 0, byArray2, this.b - byArray.length, byArray.length);
        int n2 = this.b - 3 - byArray.length;
        int n3 = 0;
        byArray2[n3++] = 0;
        byArray2[n3++] = (byte)this.a;
        if (this.a == 1) {
            while (n2-- > 0) {
                byArray2[n3++] = -1;
            }
            return byArray2;
        } else {
            if (this.c == null) {
                this.c = JCAUtil.getSecureRandom();
            }
            byte[] byArray3 = new byte[64];
            int n4 = -1;
            while (n2-- > 0) {
                int n5;
                do {
                    if (n4 >= 0) continue;
                    this.c.nextBytes(byArray3);
                    n4 = byArray3.length - 1;
                } while ((n5 = byArray3[n4--] & 0xFF) == 0);
                byArray2[n3++] = (byte)n5;
            }
        }
        return byArray2;
    }

    private byte[] b(byte[] byArray) throws BadPaddingException {
        byte[] byArray2 = new byte[this.b];
        byte[] byArray3 = new byte[this.b - byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        System.arraycopy(byArray, 0, byArray2, this.b - byArray.length, byArray.length);
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] c(byte[] byArray) throws BadPaddingException {
        int n2;
        int n3 = 0;
        boolean bl2 = false;
        if (byArray[n3++] != 0) {
            bl2 = true;
        }
        if (byArray[n3++] != this.a) {
            bl2 = true;
        }
        int n4 = 0;
        while (n3 < byArray.length) {
            if ((n2 = byArray[n3++] & 0xFF) == 0 && n4 == 0) {
                n4 = n3;
            }
            if (n3 == byArray.length && n4 == 0) {
                bl2 = true;
            }
            if (this.a != 1 || n2 == 255 || n4 != 0) continue;
            bl2 = true;
        }
        n2 = byArray.length - n4;
        if (n2 > this.d) {
            bl2 = true;
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, 0, byArray2, 0, n4);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, n4, byArray3, 0, n2);
        BadPaddingException badPaddingException = new BadPaddingException(z[14]);
        if (bl2) {
            throw badPaddingException;
        }
        return byArray3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] d(byte[] byArray) throws BadPaddingException {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            int n5 = byArray[n2] & 0xFF;
            if (n5 == 0 || n3 != -1) continue;
            n3 = n2;
        }
        if (n3 == -1) {
            n3 = byArray.length > 0 ? byArray.length - 1 : 0;
        }
        n2 = byArray.length - n3;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, n3, byArray3, 0, n2);
        return byArray3;
    }

    private byte[] e(byte[] byArray) throws BadPaddingException {
        if (this.c == null) {
            this.c = JCAUtil.getSecureRandom();
        }
        int n2 = this.g.length;
        byte[] byArray2 = new byte[n2];
        this.c.nextBytes(byArray2);
        byte[] byArray3 = new byte[this.b];
        int n3 = 1;
        int n4 = n2;
        System.arraycopy(byArray2, 0, byArray3, n3, n4);
        int n5 = n2 + 1;
        int n6 = byArray3.length - n5;
        int n7 = this.b - byArray.length;
        System.arraycopy(this.g, 0, byArray3, n5, n2);
        byArray3[n7 - 1] = 1;
        System.arraycopy(byArray, 0, byArray3, n7, byArray.length);
        this.f.a(byArray3, n3, n4, n6, byArray3, n5);
        this.f.a(byArray3, n5, n6, n4, byArray3, n3);
        return byArray3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] f(byte[] byArray) throws BadPaddingException {
        int n2;
        int n8;
        byte[] byArray2 = byArray;
        boolean bl2 = false;
        int n3 = this.g.length;
        if (byArray2[0] != 0) {
            bl2 = true;
        }
        int n4 = 1;
        int n5 = n3;
        int n6 = n3 + 1;
        int n7 = byArray2.length - n6;
        this.f.a(byArray2, n6, n7, n5, byArray2, n4);
        this.f.a(byArray2, n4, n5, n7, byArray2, n6);
        for (n8 = 0; n8 < n3; ++n8) {
            if (this.g[n8] == byArray2[n6 + n8]) continue;
            bl2 = true;
        }
        n8 = n6 + n3;
        int n9 = -1;
        for (n2 = n8; n2 < byArray2.length; ++n2) {
            byte by = byArray2[n2];
            if (n9 != -1 || by == 0) continue;
            if (by == 1) {
                n9 = n2;
                continue;
            }
            bl2 = true;
        }
        if (n9 == -1) {
            bl2 = true;
            n9 = byArray2.length - 1;
        }
        n2 = n9 + 1;
        byte[] byArray3 = new byte[n2 - n8];
        System.arraycopy(byArray2, n8, byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[byArray2.length - n2];
        System.arraycopy(byArray2, n2, byArray4, 0, byArray4.length);
        BadPaddingException badPaddingException = new BadPaddingException(z[1]);
        if (bl2) {
            throw badPaddingException;
        }
        return byArray4;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[15];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "zn\u0016,WN\u007f\u001c1@\u001en\u0007,AL";
        int n3 = -1;
        block22: while (true) {
            char[] cArray;
            block26: {
                int n4;
                int n5;
                block25: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block25;
                    n5 = n5;
                    if (n5 <= n4) break block26;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 62;
                            break;
                        }
                        case 1: {
                            n6 = 11;
                            break;
                        }
                        case 2: {
                            n6 = 117;
                            break;
                        }
                        case 3: {
                            n6 = 94;
                            break;
                        }
                        default: {
                            n6 = 46;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "zn\u0016,WN\u007f\u001c1@\u001en\u0007,AL";
                    n3 = 0;
                    continue block22;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "ke\u0006+^Nd\u0007*KZ+8\u0019h\u001ej\u00199A\u0004+";
                    n3 = 1;
                    continue block22;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "sL3o";
                    n3 = 2;
                    continue block22;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "zb\u0012;]J+\u001b1Z\u001ej\u0003?GRj\u00172K";
                    n3 = 3;
                    continue block22;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "we\u0003?BWoU.OZo\u001c0I\u0004+";
                    n3 = 4;
                    continue block22;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "nj\u0011:KZ+\u00067T[+\u0018+]J+\u0017;\u000e_\u007fU2K_x\u0001~\u0018\n";
                    n3 = 5;
                    continue block22;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "nX\u0005;MWm\u001c;J";
                    n3 = 6;
                    continue block22;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "mC4s\u001f";
                    n3 = 7;
                    continue block22;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "ke\u0006+^Nd\u0007*KZ+\u0005\rAKy\u0016;\u000e_g\u00121\u0014\u001e";
                    n3 = 8;
                    continue block22;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "un\f~GM+\u00011A\u001ex\u001d1\\J+\u00131\\\u001en\u001b=\\G{\u00017AP+\u0000-GPlU\u0011o{[%?JZb\u001b9\u000eIb\u00016\u000e";
                    n3 = 9;
                    continue block22;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u001ej\u001b:\u000esL3o";
                    n3 = 10;
                    continue block22;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "zj\u0001?\u000eS~\u0006*\u000e\\nU-FQy\u0001;\\\u001e\u007f\u001d?@\u001e";
                    n3 = 11;
                    continue block22;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u001ei\f*KM";
                    n3 = 12;
                    continue block22;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "zn\u0016,WN\u007f\u001c1@\u001en\u0007,AL";
                    n3 = 13;
                    continue block22;
                }
                case 13: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        h = Collections.synchronizedMap(new HashMap());
    }
}

