/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.IBMJCE;
import com.ibm.crypto.provider.PBKDF2KeyImpl$1;
import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyRep;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;

final class PBKDF2KeyImpl
implements PBEKey {
    static final long serialVersionUID = -2234868909660948157L;
    private char[] passwd;
    private byte[] salt;
    private int iterCount;
    private byte[] key;
    private Mac prf;
    private static final String[] z;

    private static byte[] a(char[] cArray) {
        Charset charset = Charset.forName(z[2]);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        int n2 = byteBuffer.limit();
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray, 0, n2);
        return byArray;
    }

    PBKDF2KeyImpl(PBEKeySpec pBEKeySpec, String string) throws InvalidKeySpecException {
        char[] cArray = pBEKeySpec.getPassword();
        this.passwd = cArray == null ? new char[0] : (char[])cArray.clone();
        byte[] byArray = PBKDF2KeyImpl.a(this.passwd);
        this.salt = pBEKeySpec.getSalt();
        if (this.salt == null) {
            throw new InvalidKeySpecException(z[5]);
        }
        this.iterCount = pBEKeySpec.getIterationCount();
        if (this.iterCount == 0) {
            throw new InvalidKeySpecException(z[7]);
        }
        if (this.iterCount < 0) {
            throw new InvalidKeySpecException(z[8]);
        }
        int n2 = pBEKeySpec.getKeyLength();
        if (n2 == 0) {
            throw new InvalidKeySpecException(z[9]);
        }
        if (n2 < 0) {
            throw new InvalidKeySpecException(z[6]);
        }
        try {
            this.prf = Mac.getInstance(string, IBMJCE.getInstance());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
            invalidKeySpecException.initCause(noSuchAlgorithmException);
            throw invalidKeySpecException;
        }
        this.key = PBKDF2KeyImpl.a(this.prf, byArray, this.salt, this.iterCount, n2);
    }

    private static byte[] a(Mac mac, byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4 = n3 / 8;
        byte[] byArray3 = new byte[n4];
        try {
            int n5 = mac.getMacLength();
            int n6 = (n4 + n5 - 1) / n5;
            int n7 = n4 - (n6 - 1) * n5;
            byte[] byArray4 = new byte[n5];
            byte[] byArray5 = new byte[n5];
            PBKDF2KeyImpl$1 pBKDF2KeyImpl$1 = new PBKDF2KeyImpl$1(mac, byArray);
            mac.init(pBKDF2KeyImpl$1);
            byte[] byArray6 = new byte[4];
            for (int i2 = 1; i2 <= n6; ++i2) {
                mac.update(byArray2);
                byArray6[3] = (byte)i2;
                byArray6[2] = (byte)(i2 >> 8 & 0xFF);
                byArray6[1] = (byte)(i2 >> 16 & 0xFF);
                byArray6[0] = (byte)(i2 >> 24 & 0xFF);
                mac.update(byArray6);
                mac.doFinal(byArray4, 0);
                System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
                for (int i3 = 2; i3 <= n2; ++i3) {
                    mac.update(byArray4);
                    mac.doFinal(byArray4, 0);
                    for (int i4 = 0; i4 < byArray4.length; ++i4) {
                        int n8 = i4;
                        byArray5[n8] = (byte)(byArray5[n8] ^ byArray4[i4]);
                    }
                    continue;
                }
                if (i2 == n6) {
                    System.arraycopy(byArray5, 0, byArray3, (i2 - 1) * n5, n7);
                    continue;
                }
                System.arraycopy(byArray5, 0, byArray3, (i2 - 1) * n5, n5);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException(z[4]);
        }
        return byArray3;
    }

    @Override
    public synchronized byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public String getAlgorithm() {
        return z[3] + this.prf.getAlgorithm();
    }

    @Override
    public int getIterationCount() {
        return this.iterCount;
    }

    @Override
    public synchronized char[] getPassword() {
        return (char[])this.passwd.clone();
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    public String getFormat() {
        return z[0];
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 1; i2 < this.key.length; ++i2) {
            n2 += this.key[i2] * i2;
        }
        return n2 ^= this.getAlgorithm().toLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        SecretKey secretKey = (SecretKey)object;
        if (!secretKey.getAlgorithm().equalsIgnoreCase(this.getAlgorithm())) {
            return false;
        }
        if (!secretKey.getFormat().equalsIgnoreCase(z[1])) {
            return false;
        }
        byte[] byArray = secretKey.getEncoded();
        boolean bl2 = MessageDigest.isEqual(this.key, secretKey.getEncoded());
        Arrays.fill(byArray, (byte)0);
        return bl2;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.SECRET, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    protected void finalize() throws Throwable {
        try {
            if (this.passwd != null) {
                Arrays.fill(this.passwd, '0');
                this.passwd = null;
            }
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
                this.key = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "@(\u0014";
        int n3 = -1;
        block17: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                block20: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block20;
                    n5 = n5;
                    if (n5 <= n4) break block21;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 18;
                            break;
                        }
                        case 1: {
                            n6 = 105;
                            break;
                        }
                        case 2: {
                            n6 = 67;
                            break;
                        }
                        case 3: {
                            n6 = 69;
                            break;
                        }
                        default: {
                            n6 = 100;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "@(\u0014";
                    n3 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "G=\u0005h\\";
                    n3 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "B+\b\u0001\" >*1\f";
                    n3 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "W\u001b1*\u00162\r&7\rd\u0000-\"DB+\b\u0001\" I( \u001da";
                    n3 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "A\b/1D|\u00067e\u0002}\u001c-!";
                    n3 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "Y\f:e\bw\u0007$1\f2\u00000e\nw\u000e\"1\rd\f";
                    n3 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "[\u001d&7\u0005f\u0000,+Dq\u00066+\u00102\u0007,1Dt\u00066+\u0000";
                    n3 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "[\u001d&7\u0005f\u0000,+Dq\u00066+\u00102\u00000e\nw\u000e\"1\rd\f";
                    n3 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "Y\f:e\bw\u0007$1\f2\u0007,1Dt\u00066+\u0000";
                    n3 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

