/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.net.IDN;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;

public final class SNIHostName
extends SNIServerName {
    private final String d;
    private static final String[] z;

    public SNIHostName(String string) {
        string = IDN.toASCII(Objects.requireNonNull(string, z[2]), 2);
        super(0, string.getBytes(StandardCharsets.US_ASCII));
        this.d = string;
        this.a();
    }

    public SNIHostName(byte[] byArray) {
        super(0, byArray);
        try {
            CharsetDecoder charsetDecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            this.d = IDN.toASCII(charsetDecoder.decode(ByteBuffer.wrap(byArray)).toString());
        }
        catch (RuntimeException | CharacterCodingException exception) {
            throw new IllegalArgumentException(z[0], exception);
        }
        this.a();
    }

    public String getAsciiName() {
        return this.d;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SNIHostName) {
            return this.d.equalsIgnoreCase(((SNIHostName)object).d);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 17;
        n = 31 * n + this.d.toUpperCase(Locale.ENGLISH).hashCode();
        return n;
    }

    @Override
    public String toString() {
        return z[1] + this.d;
    }

    public static SNIMatcher createSNIMatcher(String string) {
        if (string == null) {
            throw new NullPointerException(z[3]);
        }
        return new SNIHostNameMatcher(string);
    }

    private void a() {
        if (this.d.isEmpty()) {
            throw new IllegalArgumentException(z[5]);
        }
        if (this.d.endsWith(".")) {
            throw new IllegalArgumentException(z[4]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "y:\"sYC1(7YIr46N[75sRL?\"sJL>26\u001cD!g:R[3+:X";
        int n2 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block17;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 45;
                                break;
                            }
                            case 1: {
                                n8 = 82;
                                break;
                            }
                            case 2: {
                                n8 = 71;
                                break;
                            }
                            case 3: {
                                n8 = 83;
                                break;
                            }
                            default: {
                                n8 = 60;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "Y+76\u0001E=4'cC3*6\u001c\u0005bn\u007f\u001c[3+&Y\u0010";
                    n2 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "~75%Y_r)2QHr12PX7g<Z\r:( Hr<&>Y\r1&=RB&g1Y\r<2?P";
                    n2 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "y:\"sNH52?]_r\"+L_74 UB<g0]C<('\u001cO7g=IA>";
                    n2 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "~75%Y_r)2QHr12PX7g<Z\r:( Hr<&>Y\r1&=RB&g;][7g'THr3!]D>.=[\r6('";
                    n2 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "~75%Y_r)2QHr12PX7g<Z\r:( Hr<&>Y\r1&=RB&g1Y\r7*#HT";
                    n2 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        z = stringArray3;
    }

    private static final class SNIHostNameMatcher
    extends SNIMatcher {
        private final Pattern b;
        private static final String[] z;

        SNIHostNameMatcher(String string) {
            super(0);
            this.b = Pattern.compile(string, 2);
        }

        @Override
        public boolean matches(SNIServerName sNIServerName) {
            SNIHostName sNIHostName;
            block12: {
                block13: {
                    if (sNIServerName == null) {
                        throw new NullPointerException(z[0]);
                    }
                    if (sNIServerName instanceof SNIHostName) break block12;
                    if (sNIServerName.getType() == 0) break block13;
                    throw new IllegalArgumentException(z[1]);
                }
                try {
                    sNIHostName = new SNIHostName(sNIServerName.getEncoded());
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    return false;
                }
            }
            sNIHostName = (SNIHostName)sNIServerName;
            String string = sNIHostName.getAsciiName();
            if (this.b.matcher(string).matches()) {
                return true;
            }
            return this.b.matcher(IDN.toUnicode(string)).matches();
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n = 0;
            String string2 = "\u001cv\\G$\u0006Wj\u0002\u0005>{K)\u0016%{\u0019\u0006\u0005/kT\u0002\u0019<>Z\u0006\u0019&qMG\u0015->W\u0012\u001b$";
            int n2 = -1;
            block9: while (true) {
                char[] cArray;
                block14: {
                    int n3;
                    int n4;
                    char[] cArray2;
                    int n5;
                    block13: {
                        char[] cArray3 = string2.toCharArray();
                        n5 = 0;
                        int n6 = cArray3.length;
                        cArray2 = cArray3;
                        n4 = n6;
                        if (n6 <= 1) break block13;
                        cArray = cArray2;
                        n3 = n4;
                        if (n4 <= n5) break block14;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n7 = n5;
                        while (true) {
                            int n8;
                            char c = cArray4[n7];
                            switch (n5 % 5) {
                                case 0: {
                                    n8 = 72;
                                    break;
                                }
                                case 1: {
                                    n8 = 30;
                                    break;
                                }
                                case 2: {
                                    n8 = 57;
                                    break;
                                }
                                case 3: {
                                    n8 = 103;
                                    break;
                                }
                                default: {
                                    n8 = 119;
                                }
                            }
                            cArray4[n7] = (char)(c ^ n8);
                            ++n5;
                            cArray2 = cArray5;
                            n4 = n4;
                            if (n4 != 0) break;
                            cArray5 = cArray2;
                            n3 = n4;
                            n7 = n4;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n3 = n4;
                    } while (n4 > n5);
                }
                string = new String(cArray);
                switch (n2) {
                    default: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 1;
                        string2 = "\u001cv\\G\u0004-lO\u0002\u0005hpX\n\u0012hj@\u0017\u0012hwJG\u0019'j\u0019\u000f\u0018;jf\t\u0016%{";
                        n2 = 0;
                        continue block9;
                    }
                    case 0: 
                }
                break;
            }
            stringArray2[n] = string.intern();
            z = stringArray3;
        }
    }
}

