/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.keystoreutil;

import com.ibm.misc.BASE64Encoder;
import com.ibm.misc.Debug;
import com.ibm.security.keystoreutil.KeyStoreTranslator;
import com.ibm.security.keystoreutil.KeyStoreTranslatorParameters;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public final class KeyStoreUtil {
    private static Debug debug = Debug.getInstance((String)"keycertmanage");
    private static final Object className = "com.ibm.security.keystoreutil.KeyStoreUtil";

    private KeyStoreUtil() {
        throw new UnsupportedOperationException();
    }

    public static KeyStoreTranslator newTranslator(String string) throws KeyStoreException {
        return new KeyStoreTranslatorImpl(string);
    }

    public static KeyStoreTranslator newTranslator(String string, Provider provider) throws KeyStoreException {
        return new KeyStoreTranslatorImpl(string, provider);
    }

    public static KeyStoreTranslator newTranslator(String string, String string2) throws KeyStoreException, NoSuchProviderException {
        return new KeyStoreTranslatorImpl(string, string2);
    }

    public static KeyStoreTranslatorParameters newTranslatorParameters(KeyStore keyStore, char[] cArray, Map<String, char[]> map) {
        return new TranslatorParametersImpl(keyStore, cArray, map);
    }

    public static void importCertificate(InputStream inputStream, KeyStore keyStore, String string) throws CertificateException, IOException, KeyStoreException {
        CertificateFactory certificateFactory;
        if (debug != null) {
            debug.text(1L, className, "importCertificate", "entering method");
        }
        if (inputStream == null) {
            if (debug != null) {
                debug.exception(4L, className, "importCertificate", (Throwable)new NullPointerException("input stream cannot be null."));
            }
            throw new NullPointerException("input stream cannot be null.");
        }
        if (keyStore == null) {
            if (debug != null) {
                debug.exception(4L, className, "importCertificate", (Throwable)new NullPointerException("KeyStore cannot be null."));
            }
            throw new NullPointerException("KeyStore cannot be null.");
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509", "IBMJCE");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException.getMessage());
        }
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
        String string2 = string;
        if (string2 == null) {
            X500Name x500Name = (X500Name)x509Certificate.getSubjectDN();
            string2 = x500Name.getCommonName();
        }
        keyStore.setCertificateEntry(string2, x509Certificate);
        if (debug != null) {
            debug.text(1L, className, "importCertificate", "exiting method");
        }
    }

    public static void importCertificates(InputStream inputStream, KeyStore keyStore) throws CertificateException, IOException, KeyStoreException {
        CertificateFactory certificateFactory;
        if (debug != null) {
            debug.text(1L, className, "importCertificates", "entering method");
        }
        if (inputStream == null) {
            if (debug != null) {
                debug.exception(4L, className, "importCertificates", (Throwable)new NullPointerException("input stream cannot be null."));
            }
            throw new NullPointerException("input stream cannot be null.");
        }
        if (keyStore == null) {
            if (debug != null) {
                debug.exception(4L, className, "importCertificates", (Throwable)new NullPointerException("KeyStore cannot be null."));
            }
            throw new NullPointerException("KeyStore cannot be null.");
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509", "IBMJCE");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException.getMessage());
        }
        Collection<? extends Certificate> collection = certificateFactory.generateCertificates(inputStream);
        for (X509Certificate x509Certificate : collection) {
            X500Name x500Name = (X500Name)x509Certificate.getSubjectDN();
            keyStore.setCertificateEntry(x500Name.getCommonName(), x509Certificate);
        }
        if (debug != null) {
            debug.text(1L, className, "importCertificates", "exiting method");
        }
    }

    public static void exportCertificate(OutputStream outputStream, KeyStore keyStore, String string, boolean bl) throws KeyStoreException, CertificateEncodingException, IOException {
        if (debug != null) {
            debug.text(1L, className, "exportCertificate", "entering method");
        }
        if (outputStream == null) {
            if (debug != null) {
                debug.exception(4L, className, "exportCertificate", (Throwable)new NullPointerException("output stream cannot be null."));
            }
            throw new NullPointerException("output stream cannot be null.");
        }
        if (keyStore == null) {
            if (debug != null) {
                debug.exception(4L, className, "exportCertificate", (Throwable)new NullPointerException("KeyStore cannot be null."));
            }
            throw new NullPointerException("KeyStore cannot be null.");
        }
        if (string == null || string.length() == 0) {
            if (debug != null) {
                debug.exception(4L, className, "exportCertificate", (Throwable)new NullPointerException("alias cannot be null."));
            }
            throw new NullPointerException("alias cannot be null.");
        }
        Certificate certificate = keyStore.getCertificate(string);
        if (certificate == null) {
            if (debug != null) {
                debug.exception(4L, className, "exportCertificate", (Throwable)new KeyStoreException("Certificate cannot be found in KeyStore."));
            }
            throw new KeyStoreException("Certificate cannot be found in KeyStore.");
        }
        byte[] byArray = certificate.getEncoded();
        if (bl) {
            outputStream.write("-----BEGIN CERTIFICATE-----\r\n".getBytes("8859_1"));
            new BASE64Encoder().encode(byArray, outputStream);
            outputStream.write("\r\n-----END CERTIFICATE-----".getBytes("8859_1"));
        } else {
            outputStream.write(byArray);
        }
        if (debug != null) {
            debug.text(1L, className, "exportCertificate", "exiting method");
        }
    }

    private static final class TranslatorParametersImpl
    implements KeyStoreTranslatorParameters {
        private KeyStore source = null;
        private char[] accessPassword = null;
        private Map<String, char[]> keyPasswords = null;

        private static void wipeArray(char[] cArray) {
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = '\u0000';
            }
        }

        TranslatorParametersImpl(KeyStore keyStore, char[] cArray, Map<String, char[]> map) {
            if (keyStore == null) {
                throw new NullPointerException("The source KeyStore cannot be null.");
            }
            if (cArray == null) {
                throw new NullPointerException("The source KeyStore access password should be provided.");
            }
            this.source = keyStore;
            this.accessPassword = cArray;
            this.keyPasswords = map;
        }

        @Override
        public KeyStore getSourceKeyStore() {
            return this.source;
        }

        @Override
        public char[] getKeyStoreAccessPassword() {
            return this.accessPassword;
        }

        @Override
        public char[] getKeyProtectionPassword(String string) {
            if (this.keyPasswords == null || this.keyPasswords.isEmpty()) {
                return this.accessPassword;
            }
            if (this.keyPasswords.containsKey(string)) {
                return this.keyPasswords.get(string);
            }
            return this.accessPassword;
        }

        @Override
        public void destroyParameters() {
            this.source = null;
            TranslatorParametersImpl.wipeArray(this.accessPassword);
            this.accessPassword = null;
            if (this.keyPasswords != null && !this.keyPasswords.isEmpty()) {
                Iterator<char[]> iterator = this.keyPasswords.values().iterator();
                while (iterator.hasNext()) {
                    TranslatorParametersImpl.wipeArray(iterator.next());
                }
                this.keyPasswords.clear();
                this.keyPasswords = null;
            }
        }
    }

    private static final class KeyStoreTranslatorImpl
    implements KeyStoreTranslator {
        private KeyStore targetStore = null;

        KeyStoreTranslatorImpl(String string) throws KeyStoreException {
            this.targetStore = KeyStore.getInstance(string);
        }

        KeyStoreTranslatorImpl(String string, Provider provider) throws KeyStoreException {
            this.targetStore = KeyStore.getInstance(string, provider);
        }

        KeyStoreTranslatorImpl(String string, String string2) throws KeyStoreException, NoSuchProviderException {
            this.targetStore = KeyStore.getInstance(string, string2);
        }

        @Override
        public KeyStore translateStore(KeyStoreTranslatorParameters keyStoreTranslatorParameters) {
            try {
                KeyStore keyStore = keyStoreTranslatorParameters.getSourceKeyStore();
                Enumeration<String> enumeration = keyStore.aliases();
                this.targetStore.load(null, keyStoreTranslatorParameters.getKeyStoreAccessPassword());
                this.deleteAllEntries(this.targetStore);
                while (enumeration.hasMoreElements()) {
                    Serializable serializable;
                    String string = enumeration.nextElement();
                    if (keyStore.isKeyEntry(string)) {
                        serializable = keyStore.getKey(string, keyStoreTranslatorParameters.getKeyProtectionPassword(string));
                        Certificate[] certificateArray = keyStore.getCertificateChain(string);
                        this.targetStore.setKeyEntry(string, (Key)serializable, keyStoreTranslatorParameters.getKeyProtectionPassword(string), certificateArray);
                        continue;
                    }
                    if (!keyStore.isCertificateEntry(string)) continue;
                    serializable = keyStore.getCertificate(string);
                    this.targetStore.setCertificateEntry(string, (Certificate)serializable);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage(), exception);
            }
            return this.targetStore;
        }

        private void deleteAllEntries(KeyStore keyStore) throws KeyStoreException {
            ArrayList<String> arrayList = Collections.list(keyStore.aliases());
            for (String string : arrayList) {
                keyStore.deleteEntry(string);
            }
        }
    }
}

