/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.keystoreski;

import com.ibm.misc.Debug;
import com.ibm.security.keystoreski.KeyStoreSKI;
import com.ibm.security.keystoreski.SKIDefinition;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public final class KeyStoreSKIFactory {
    private KeyStoreSKIFactory() {
        throw new UnsupportedOperationException();
    }

    public static KeyStoreSKI newKeyStoreSKI(KeyStore keyStore) {
        if (keyStore == null) {
            throw new NullPointerException();
        }
        return new KeyStoreSKIImpl(keyStore);
    }

    private static final class KeyStoreSKIImpl
    implements KeyStoreSKI {
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();
        private final KeyStore ks;

        KeyStoreSKIImpl(KeyStore keyStore) {
            this.ks = keyStore;
        }

        @Override
        public PrivateKey getPrivateKey(String string, SKIDefinition sKIDefinition, char[] cArray) throws KeyStoreException {
            if (debug != null) {
                debug.text(1L, this.className, "getPrivateKey", "entering method");
            }
            if (string == null || string.length() == 0 || sKIDefinition == null || cArray == null) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getPrivateKey", (Throwable)new NullPointerException());
                }
                throw new NullPointerException();
            }
            try {
                Enumeration<String> enumeration = this.ks.aliases();
                while (enumeration.hasMoreElements()) {
                    String string2 = enumeration.nextElement();
                    if (!this.ks.isKeyEntry(string2)) continue;
                    try {
                        String string3;
                        Key key = this.ks.getKey(string2, cArray);
                        Certificate[] certificateArray = this.ks.getCertificateChain(string2);
                        if (!(key instanceof PrivateKey) || certificateArray == null || certificateArray.length <= 0 || (string3 = sKIDefinition.getSubjectKeyIdentifier((X509Certificate)certificateArray[0])) == null || !string3.equals(string)) continue;
                        if (debug != null) {
                            debug.text(1L, this.className, "getPrivateKey", "exiting method");
                        }
                        return (PrivateKey)key;
                    }
                    catch (UnrecoverableKeyException unrecoverableKeyException) {
                        if (debug == null) continue;
                        debug.text(1L, this.className, "getPrivateKey", "password couldn't get key");
                    }
                }
                if (debug != null) {
                    debug.text(1L, this.className, "getPrivateKey", "returning null");
                }
                return null;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getPrivateKey", (Throwable)noSuchAlgorithmException);
                }
                throw new RuntimeException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
            }
        }

        @Override
        public Certificate getCertificate(String string, SKIDefinition sKIDefinition) throws KeyStoreException {
            if (debug != null) {
                debug.text(1L, this.className, "getCertificate", "entering method");
            }
            if (string == null || string.length() == 0 || sKIDefinition == null) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getCertificate", (Throwable)new NullPointerException());
                }
                throw new NullPointerException();
            }
            Enumeration<String> enumeration = this.ks.aliases();
            while (enumeration.hasMoreElements()) {
                String string2;
                String string3 = enumeration.nextElement();
                X509Certificate x509Certificate = (X509Certificate)this.ks.getCertificate(string3);
                if (x509Certificate == null || (string2 = sKIDefinition.getSubjectKeyIdentifier(x509Certificate)) == null || !string2.equals(string)) continue;
                if (debug != null) {
                    debug.text(1L, this.className, "getCertificate", "exiting method");
                }
                return x509Certificate;
            }
            if (debug != null) {
                debug.text(1L, this.className, "getCertificate", "returning null");
            }
            return null;
        }

        @Override
        public String getAlias(String string, SKIDefinition sKIDefinition) throws KeyStoreException {
            if (debug != null) {
                debug.text(1L, this.className, "getAlias", "entering method");
            }
            if (string == null || string.length() == 0 || sKIDefinition == null) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getAlias", (Throwable)new NullPointerException());
                }
                throw new NullPointerException();
            }
            Enumeration<String> enumeration = this.ks.aliases();
            while (enumeration.hasMoreElements()) {
                String string2;
                String string3 = enumeration.nextElement();
                X509Certificate x509Certificate = (X509Certificate)this.ks.getCertificate(string3);
                if (x509Certificate == null || (string2 = sKIDefinition.getSubjectKeyIdentifier(x509Certificate)) == null || !string2.equals(string)) continue;
                if (debug != null) {
                    debug.text(1L, this.className, "getAlias", "exiting method");
                }
                return string3;
            }
            if (debug != null) {
                debug.text(1L, this.className, "getAlias", "returning null");
            }
            return null;
        }
    }
}

