/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.util;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.util.Pk10Certificate;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcs9.PKCS9;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import java.util.Enumeration;

public final class Pk10CertFactory {
    private static Debug debug = Debug.getInstance((String)"keycertmanage");
    private static final Object className = "com.ibm.security.certclient.Pk10CertFactory";

    private Pk10CertFactory() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static Pk10Certificate newCert(String string, Date date, int n, X509Certificate x509Certificate, PrivateKey privateKey) throws PkRejectionException {
        Pk10CertImpl pk10CertImpl = new Pk10CertImpl(string, date, n, x509Certificate, privateKey);
        return pk10CertImpl;
    }

    @Deprecated
    public static Pk10Certificate newCert(byte[] byArray, Date date, int n, X509Certificate x509Certificate, PrivateKey privateKey) throws PkRejectionException {
        Pk10CertImpl pk10CertImpl = new Pk10CertImpl(byArray, date, n, x509Certificate, privateKey);
        return pk10CertImpl;
    }

    public static Pk10Certificate newCert(String string, Date date, int n, X509Certificate x509Certificate, PrivateKey privateKey, String string2) throws PkRejectionException {
        Pk10CertImpl pk10CertImpl = new Pk10CertImpl(string, date, n, x509Certificate, privateKey, string2);
        return pk10CertImpl;
    }

    public static Pk10Certificate newCert(byte[] byArray, Date date, int n, X509Certificate x509Certificate, PrivateKey privateKey, String string) throws PkRejectionException {
        Pk10CertImpl pk10CertImpl = new Pk10CertImpl(byArray, date, n, x509Certificate, privateKey, string);
        return pk10CertImpl;
    }

    private static final class Pk10CertImpl
    implements Pk10Certificate,
    PkConstants {
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private static final Object className = "com.ibm.security.certclient.Pk10CertImpl";
        private X509Certificate newCert;
        private CertificationRequest cr;
        private PrivateKey signingKey;
        X500Name subjectName;
        X500Name issuerName;
        int version;
        BigInteger serial_number;
        private PublicKey publicKey;
        private int newCertValidityPeriod;
        Date notAfterDate;
        AlgorithmId algId;
        SubjectAlternativeNameExtension subjectAlternativeNameExtension = null;
        SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = null;
        KeyUsageExtension keyUsageExtension = null;
        ExtKeyUsageExtension extKeyUsageExtension = null;

        Pk10CertImpl(String string, Date date, int n, X509Certificate x509Certificate, PrivateKey privateKey, String string2) throws PkRejectionException {
            this.validate(date, n, x509Certificate, privateKey);
            this.cr = this.getCertificationRequest(string);
            this.newCert = this.buildX509Cert(this.cr, date, n, x509Certificate, privateKey, string2);
            if (debug != null) {
                System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  The generated certificate is: \n" + this.newCert.toString() + "\n");
            }
        }

        Pk10CertImpl(byte[] byArray, Date date, int n, X509Certificate x509Certificate, PrivateKey privateKey, String string) throws PkRejectionException {
            this.validate(date, n, x509Certificate, privateKey);
            this.cr = this.getCertificationRequest(byArray);
            this.newCert = this.buildX509Cert(this.cr, date, n, x509Certificate, privateKey, string);
            if (debug != null) {
                System.out.println("Pk10CertFactory.java:  Pk10CertImpl(byte[], PrivateKey):  The generated certificate is: \n" + this.newCert.toString() + "\n");
            }
        }

        @Deprecated
        Pk10CertImpl(String string, Date date, int n, X509Certificate x509Certificate, PrivateKey privateKey) throws PkRejectionException {
            this.validate(date, n, x509Certificate, privateKey);
            this.cr = this.getCertificationRequest(string);
            this.newCert = this.buildX509Cert(this.cr, date, n, x509Certificate, privateKey);
            if (debug != null) {
                System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  The generated certificate is: \n" + this.newCert.toString() + "\n");
            }
        }

        @Deprecated
        Pk10CertImpl(byte[] byArray, Date date, int n, X509Certificate x509Certificate, PrivateKey privateKey) throws PkRejectionException {
            this.validate(date, n, x509Certificate, privateKey);
            this.cr = this.getCertificationRequest(byArray);
            this.newCert = this.buildX509Cert(this.cr, date, n, x509Certificate, privateKey);
            if (debug != null) {
                System.out.println("Pk10CertFactory.java:  Pk10CertImpl(byte[], PrivateKey):  The generated certificate is: \n" + this.newCert.toString() + "\n");
            }
        }

        private CertificationRequest getCertificationRequest(byte[] byArray) throws PkRejectionException {
            CertificationRequest certificationRequest = null;
            if (byArray == null) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(byte[], PrivateKey):  Null PKCS10CertificateRequest received");
                }
                throw new PkRejectionException(PkNLSConstants.EE_INITIAL_CERT_REQUEST_MISSING);
            }
            try {
                certificationRequest = new CertificationRequest(byArray);
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(byte[], PrivateKey):  The input PKCS10 certificate request is: \n" + certificationRequest.toString() + "\n");
                }
            }
            catch (IOException iOException) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(byte[], PrivateKey):  The following exception was thrown:");
                    System.out.println(iOException.toString());
                    iOException.printStackTrace();
                }
                throw new PkRejectionException(PkNLSConstants.FILE_IO_FAILED, iOException);
            }
            return certificationRequest;
        }

        private CertificationRequest getCertificationRequest(String string) throws PkRejectionException {
            CertificationRequest certificationRequest = null;
            if (string == null || string.length() <= 0) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  Null PKCS10CertificateRequest file name received");
                }
                throw new PkRejectionException(PkNLSConstants.EE_INITIAL_CERT_REQUEST_MISSING);
            }
            try {
                certificationRequest = new CertificationRequest(string, true);
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  The input PKCS10 certificate request is: \n" + certificationRequest.toString() + "\n");
                }
            }
            catch (IOException iOException) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  The following exception was thrown:");
                    System.out.println(iOException.toString());
                    iOException.printStackTrace();
                }
                throw new PkRejectionException(PkNLSConstants.FILE_IO_FAILED, iOException);
            }
            return certificationRequest;
        }

        private void validate(Date date, int n, X509Certificate x509Certificate, PrivateKey privateKey) throws PkRejectionException {
            this.signingKey = privateKey;
            if (this.signingKey == null) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(byte[], PrivateKey):  Null signingKey received");
                }
                throw new PkRejectionException(PkNLSConstants.EE_MISSING_PRIVATE_KEY);
            }
            if (x509Certificate == null) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  Null signingCert received");
                }
                throw new PkRejectionException("signingCert is null");
            }
            if (n <= 0) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(byte[], PrivateKey):  The validityPeriod argument is <= 0 days");
                }
                throw new PkRejectionException(PkNLSConstants.VALIDITY_PERIOD_NOT_ALLOWED);
            }
            if (date == null) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  The notBeforeDate is null.");
                }
                throw new PkRejectionException("notBeforeDate is null.");
            }
        }

        @Deprecated
        private X509CertImpl buildX509Cert(CertificationRequest certificationRequest, Date date, int n, X509Certificate x509Certificate, PrivateKey privateKey) throws PkRejectionException {
            boolean bl;
            if (debug != null) {
                System.out.println("\n\nPk10CertFactory.java:  buildX509Cert():  METHOD ENTRY");
            }
            String string = (bl = privateKey instanceof RSAPrivateKey) ? "SHA1withRSA" : "SHA1withDSA";
            return this.buildX509Cert(certificationRequest, date, n, x509Certificate, privateKey, string);
        }

        private X509CertImpl buildX509Cert(CertificationRequest certificationRequest, Date date, int n, X509Certificate x509Certificate, PrivateKey privateKey, String string) throws PkRejectionException {
            CertificateValidity certificateValidity;
            if (debug != null) {
                System.out.println("\n\nPk10CertFactory.java:  buildX509Cert():  METHOD ENTRY");
            }
            X509CertInfo x509CertInfo = new X509CertInfo();
            CertificationRequestInfo certificationRequestInfo = certificationRequest.getCertRequestInfo();
            try {
                this.version = 2;
                x509CertInfo.set("version", (Object)new CertificateVersion(this.version));
                this.subjectName = certificationRequestInfo.getSubjectName();
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The subjectName taken from the CertificationRequest is:  " + this.subjectName);
                }
                x509CertInfo.set("subject", (Object)this.subjectName);
                this.publicKey = certificationRequestInfo.getSubjectPublicKeyInfo();
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The PublicKey taken from the CertificationRequest is:  " + this.publicKey.toString());
                }
                x509CertInfo.set("key", (Object)new CertificateX509Key(this.publicKey));
                this.issuerName = new X500Name(x509Certificate.getSubjectDN().getName());
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The issuerName which will be used is:  " + this.issuerName);
                }
                x509CertInfo.set("issuer", (Object)this.issuerName);
                this.notAfterDate = new Date();
                this.newCertValidityPeriod = n;
                this.notAfterDate.setTime(date.getTime() + (long)(n * 24 * 60 * 60) * 1000L);
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  notBeforeDate = " + date.toString());
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  notAfterDate  = " + this.notAfterDate.toString());
                }
                certificateValidity = new CertificateValidity(date, this.notAfterDate);
                x509CertInfo.set("validity", (Object)certificateValidity);
                this.serial_number = BigInteger.valueOf(System.nanoTime());
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The serial number which will be used is:  " + this.serial_number);
                }
                x509CertInfo.set("serialNumber", (Object)new CertificateSerialNumber(this.serial_number));
                try {
                    this.algId = AlgorithmId.get((String)string);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    if (debug != null) {
                        System.out.println("Pk10CertFactory.java:  buildX509Cert(): unrecognized algorithm name for :" + string);
                    }
                    throw new PkRejectionException(PkNLSConstants.INCORRECT_SIGNATURE_ALGORITHM, noSuchAlgorithmException);
                }
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The name of the signing algorithmId which will be used is:  " + this.algId.getName());
                }
                x509CertInfo.set("algorithmID", (Object)new CertificateAlgorithmId(this.algId));
                PKCSAttribute[] pKCSAttributeArray = certificationRequestInfo.getAttributes().getAttributes();
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  Entering loop to process all PKCSAttributes within the CertificateRequestInfo.");
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The number of PKCSAttributes is:  " + pKCSAttributeArray.length);
                }
                this.subjectAlternativeNameExtension = null;
                this.subjectKeyIdentifierExtension = null;
                this.keyUsageExtension = null;
                this.extKeyUsageExtension = null;
                for (int i = 0; i < pKCSAttributeArray.length; ++i) {
                    String string2;
                    if (debug != null) {
                        System.out.println("Pk10CertFactory.java:  buildX509Cert():  The next PKCSAttibute to be processed is:");
                        System.out.println(pKCSAttributeArray[i].toString() + "\n\n");
                    }
                    ObjectIdentifier objectIdentifier = pKCSAttributeArray[i].getAttributeId();
                    if (debug != null) {
                        System.out.println("Pk10CertFactory.java:  buildX509Cert():  The OID of this PKCSAttribute above is:  " + objectIdentifier.toString());
                    }
                    if ((string2 = PKCS9.getName((ObjectIdentifier)objectIdentifier)) != "ExtensionRequest" && objectIdentifier.toString() != "1.2.840.113549.1.9.14") continue;
                    if (debug != null) {
                        System.out.println("Pk10CertFactory.java:  buildX509Cert():  The PKCSAttribute above is an 'ExtensionRequest'.");
                    }
                    CertificateExtensions certificateExtensions = (CertificateExtensions)pKCSAttributeArray[i].getAttributeValue();
                    Enumeration enumeration = certificateExtensions.getElements();
                    while (enumeration.hasMoreElements()) {
                        String string3;
                        Object e = enumeration.nextElement();
                        if (debug != null) {
                            System.out.println("\n\nPk10CertFactory.java:  buildX509Cert():  The next object retrieved from the ExtensionRequest is:  ");
                            System.out.println(e.toString());
                        }
                        if (!(e instanceof CertAttrSet)) {
                            string3 = ((Extension)e).getExtensionId().toString();
                            if (debug != null) {
                                System.out.println("Pk10CertFactory.java:  buildX509Cert():  This is an extension whose name isn't recognized.");
                            }
                        } else {
                            string3 = "x509.info.extensions." + ((CertAttrSet)e).getName();
                            if (debug != null) {
                                System.out.println("Pk10CertFactory.java:  buildX509Cert():  This is an extension whose name is recognized.  Its name is:  " + string3);
                            }
                        }
                        if (e instanceof SubjectAlternativeNameExtension) {
                            this.subjectAlternativeNameExtension = (SubjectAlternativeNameExtension)e;
                            if (debug == null) continue;
                            System.out.println("Pk10CertFactory.java:  buildX509Cert():  It is a SubjectAlternativeNameExtension.");
                            continue;
                        }
                        if (e instanceof SubjectKeyIdentifierExtension) {
                            this.subjectKeyIdentifierExtension = (SubjectKeyIdentifierExtension)e;
                            if (debug == null) continue;
                            System.out.println("Pk10CertFactory.java:  buildX509Cert():  It is a SubjectKeyIdentifierExtension.");
                            continue;
                        }
                        if (e instanceof KeyUsageExtension) {
                            this.keyUsageExtension = (KeyUsageExtension)e;
                            if (debug == null) continue;
                            System.out.println("Pk10CertFactory.java:  buildX509Cert():  It is a KeyUsageExtension.");
                            continue;
                        }
                        if (e instanceof ExtKeyUsageExtension) {
                            this.extKeyUsageExtension = (ExtKeyUsageExtension)e;
                            if (debug == null) continue;
                            System.out.println("Pk10CertFactory.java:  buildX509Cert():  It is a ExtKeyUsageExtension.");
                            continue;
                        }
                        if (debug == null) continue;
                        System.out.println("Pk10CertFactory.java:  buildX509Cert():  The following extension lifted from the ExtensionRequest was not recognized or processed:");
                        System.out.println(e.toString());
                    }
                }
                CertificateExtensions certificateExtensions = new CertificateExtensions();
                if (this.subjectAlternativeNameExtension != null) {
                    certificateExtensions.set("x509.info.extensions.SubjectAlternativeName", (Object)this.subjectAlternativeNameExtension);
                }
                if (this.subjectKeyIdentifierExtension != null) {
                    certificateExtensions.set("x509.info.extensions.SubjectKeyIdentifier", (Object)this.subjectKeyIdentifierExtension);
                }
                if (this.keyUsageExtension != null) {
                    certificateExtensions.set("x509.info.extensions.KeyUsage", (Object)this.keyUsageExtension);
                }
                if (this.extKeyUsageExtension != null) {
                    certificateExtensions.set("x509.info.extensions.ExtKeyUsage", (Object)this.extKeyUsageExtension);
                }
                x509CertInfo.set("extensions", (Object)certificateExtensions);
                if (debug != null) {
                    System.out.println("\n\nPk10CertFactory.java:  buildX509Cert():  The X509CertInfo built from the CertificationRequest is:");
                    System.out.println(x509CertInfo.toString());
                }
            }
            catch (Exception exception) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  Exception thrown while building X509CertInfo object.");
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The exception is:  " + exception.toString());
                }
                exception.printStackTrace();
                throw new PkRejectionException(PkNLSConstants.INVALID_ATTRIBUTE, exception);
            }
            certificateValidity = null;
            try {
                certificateValidity = new X509CertImpl(x509CertInfo);
            }
            catch (Exception exception) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  Exception thrown while creating X509CertImpl object from the X509CertInfo object.");
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The exception is:  " + exception.toString());
                }
                exception.printStackTrace();
                throw new PkRejectionException("Exception thrown while creating the X509CertImpl object from the X509CertInfo object.", exception);
            }
            try {
                if (debug != null) {
                    System.out.println("\nPk10CertFactory.java:  buildX509Cert():  The signingKey is a  DSA key.");
                }
                certificateValidity.sign(privateKey, string);
            }
            catch (Exception exception) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  Exception thrown while signing the X509CertImpl object.");
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The exception is:  " + exception.toString());
                }
                exception.printStackTrace();
                throw new PkRejectionException("Exception thrown while signing the X509CertImpl object.", exception);
            }
            if (debug != null) {
                System.out.println("\n\nPk10CertFactory.java:  buildX509Cert():  The signed X509CertImpl object being returned (after signing) is:");
                System.out.println(certificateValidity.toString());
                System.out.println("Pk10CertFactory.java:  buildX509Cert():  METHOD EXIT \n\n");
            }
            return certificateValidity;
        }

        @Override
        public X509Certificate getCertificate() {
            return this.newCert;
        }

        @Override
        public PublicKey getPublicKey() {
            return this.newCert.getPublicKey();
        }

        @Override
        public String getSubjectName() {
            return this.newCert.getSubjectDN().getName();
        }

        @Override
        public String getSigAlg() {
            return this.newCert.getSigAlgName();
        }

        @Override
        public byte[] getSubjectKeyIdentifier() {
            return this.subjectKeyIdentifierExtension.getExtensionValue();
        }
    }
}

