/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.fmt;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConfRepEvent;
import com.ibm.security.certclient.base.PkConfReqEvent;
import com.ibm.security.certclient.base.PkEvent;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkPollException;
import com.ibm.security.certclient.base.PkPollReqEvent;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.certclient.base.PkRevoRepEvent;
import com.ibm.security.certclient.base.PkRevoReqEvent;
import com.ibm.security.certclient.base.PkSecnReqEvent;
import com.ibm.security.certclient.base.PkXcerRepEvent;
import com.ibm.security.certclient.base.PkXcerReqEvent;
import com.ibm.security.certclient.fmt.PkCmpEventFormatter;
import com.ibm.security.certclient.fmt.PkTcpV10CmpException;
import com.ibm.security.cmp.PKIHeader;
import com.ibm.security.cmp.PKIMessage;
import com.ibm.security.cmp.TCPMessage;
import com.ibm.security.cmp.TCPMsgRfc2510;
import com.ibm.security.cmp.TCPMsgV10;
import com.ibm.security.cmp.TCPMsgV10ErrorMsgRep;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class PkTcpV10CmpEventFormatter
extends PkCmpEventFormatter {
    private static final String sccsid = "%Z% %M% %I%    %W% %G% %U%";
    private static Debug debug = Debug.getInstance((String)"keycertmanage");
    private final Object className = this.toString();
    private final byte[] emptyByteArray = new byte[0];
    static int i = 0;

    @Override
    public PkEvent readEvent(Object object, InputStream inputStream, PkReqEvent pkReqEvent) throws PkException, IOException {
        TCPMessage tCPMessage = new TCPMessage(inputStream);
        TCPMsgV10 tCPMsgV10 = null;
        TCPMsgRfc2510 tCPMsgRfc2510 = null;
        boolean bl = true;
        if (tCPMessage.getVersion() == 0) {
            block26: {
                if (debug != null) {
                    debug.text(1L, this.className, "readEvent", "Message is TCP_MESSAGE_RFC_2510");
                }
                try {
                    tCPMsgRfc2510 = (TCPMsgRfc2510)tCPMessage.getMessage();
                }
                catch (Exception exception) {
                    if (debug == null) break block26;
                    debug.text(1L, this.className, "readEvent", exception.getMessage());
                }
            }
            if (debug != null) {
                debug.text(1L, this.className, "readEvent", "After creating rfc2510 request");
            }
            bl = false;
        } else {
            tCPMsgV10 = (TCPMsgV10)tCPMessage.getMessage();
        }
        if (debug != null) {
            debug.text(1L, this.className, "readEvent", " #### TcpV10CmpEvent... req = {0}", (Object)pkReqEvent);
        }
        if (bl) {
            if (debug != null) {
                debug.text(1L, this.className, "readEvent", "#### TcpV10CmpEvent... msg type = {0}", (Object)new Byte(tCPMsgV10.getMessageType()));
            }
            int n = inputStream.available();
            inputStream.skip(n);
            switch (tCPMsgV10.getMessageType()) {
                case 0: 
                case 5: {
                    return super.readEvent(object, new ByteArrayInputStream(tCPMsgV10.getValue()), pkReqEvent);
                }
                case 1: {
                    byte[] byArray = new byte[4];
                    System.arraycopy(tCPMsgV10.getValue(), 0, byArray, 0, 4);
                    int n2 = new BigInteger(byArray).intValue();
                    System.arraycopy(tCPMsgV10.getValue(), 4, byArray, 0, 4);
                    int n3 = new BigInteger(byArray).intValue();
                    throw new PkPollException(n2, n3);
                }
                case 2: {
                    byte[] byArray = new byte[4];
                    System.arraycopy(tCPMsgV10.getValue(), 0, byArray, 0, 4);
                    int n4 = new BigInteger(byArray).intValue();
                    return new PkPollReqEvent(object, tCPMsgV10, new PkAttrs(), n4);
                }
                case 3: {
                    if (debug != null) {
                        debug.text(1L, this.className, "readEvent", "Received a fin_rep ");
                        debug.text(1L, this.className, "readEvent", " msg.getValue = {0}", (Object)new String(tCPMsgV10.getValue()));
                    }
                    return new PkConfRepEvent(object, null, pkReqEvent);
                }
                case 6: {
                    if (debug != null) {
                        debug.text(1L, this.className, "readEvent", "########### from TcpV10Cmp....msg= {0}", (Object)tCPMsgV10);
                        debug.text(1L, this.className, "readEvent", "########### from TcpV10Cmp....msg.getValue= {0}", (Object)new String(tCPMsgV10.getValue()));
                    }
                    TCPMsgV10ErrorMsgRep tCPMsgV10ErrorMsgRep = new TCPMsgV10ErrorMsgRep(1, 1, null, "Invalid data value");
                    if (debug != null) {
                        debug.text(1L, this.className, "readEvent", "########### from TcpV10Cmp...error= {0}", (Object)tCPMsgV10ErrorMsgRep);
                    }
                    throw new PkTcpV10CmpException(tCPMsgV10ErrorMsgRep);
                }
            }
            throw new PkTcpV10CmpException(new TCPMsgV10ErrorMsgRep(2, 2, new byte[]{tCPMsgV10.getMessageType()}, null));
        }
        if (debug != null) {
            debug.text(1L, this.className, "readEvent", "#### 2510 Event... msg1 type = {0}", (Object)new Byte(tCPMsgRfc2510.getFlag()));
        }
        int n = inputStream.available();
        inputStream.skip(n);
        if (debug != null) {
            debug.text(1L, this.className, "readEvent", "####### ms1.getFlag() = {0}", (Object)new Byte(tCPMsgRfc2510.getFlag()));
        }
        switch (tCPMsgRfc2510.getFlag()) {
            case 0: {
                return super.readEvent(object, new ByteArrayInputStream(tCPMsgRfc2510.getValue()), pkReqEvent);
            }
            case 2: {
                byte[] byArray = new byte[4];
                System.arraycopy(tCPMsgRfc2510.getValue(), 0, byArray, 0, 4);
                int n5 = new BigInteger(byArray).intValue();
                if (debug != null) {
                    debug.text(1L, this.className, "readEvent", "######### 2510 poll-req event.poll ref = {0}", (Object)new Integer(n5));
                }
                return new PkPollReqEvent(object, tCPMsgRfc2510, new PkAttrs(), n5);
            }
        }
        throw new PkTcpV10CmpException(new TCPMsgV10ErrorMsgRep(2, 2, new byte[]{tCPMsgV10.getMessageType()}, null));
    }

    @Override
    public void writeException(Exception exception, OutputStream outputStream) throws IOException {
        if (exception instanceof PkTcpV10CmpException) {
            TCPMsgV10ErrorMsgRep tCPMsgV10ErrorMsgRep = new TCPMsgV10ErrorMsgRep(2, 0, this.emptyByteArray, null);
            new TCPMsgV10(0, 6, ((PkTcpV10CmpException)exception).getError().getEncoded()).write(outputStream);
        } else if (exception instanceof PkPollException) {
            byte[] byArray = this.to4bytes(((PkPollException)exception).getPollReference());
            byte[] byArray2 = this.to4bytes(((PkPollException)exception).getTimeToCheckBack());
            byte[] byArray3 = new byte[8];
            System.arraycopy(byArray, 0, byArray3, 0, 4);
            System.arraycopy(byArray2, 0, byArray3, 4, 4);
            new TCPMsgV10(0, 1, byArray3).write(outputStream);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            super.writeException(exception, byteArrayOutputStream);
            new TCPMsgV10(0, 5, byteArrayOutputStream.toByteArray()).write(outputStream);
        }
    }

    @Override
    public void writeCertReq(PkCertReqEvent pkCertReqEvent, OutputStream outputStream) throws IOException, PkException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        super.writeCertReq(pkCertReqEvent, byteArrayOutputStream);
        new TCPMsgV10(0, 0, byteArrayOutputStream.toByteArray()).write(outputStream);
    }

    @Override
    public void writeCertRep(PkCertRepEvent pkCertRepEvent, OutputStream outputStream) throws IOException, PkException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        super.writeCertRep(pkCertRepEvent, byteArrayOutputStream);
        new TCPMsgV10(0, 5, byteArrayOutputStream.toByteArray()).write(outputStream);
    }

    @Override
    public void writeRevoReq(PkRevoReqEvent pkRevoReqEvent, OutputStream outputStream) throws IOException, PkException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        super.writeRevoReq(pkRevoReqEvent, byteArrayOutputStream);
        new TCPMsgV10(0, 0, byteArrayOutputStream.toByteArray()).write(outputStream);
    }

    @Override
    public void writeConfReq(PkConfReqEvent pkConfReqEvent, OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        super.writeConfReq(pkConfReqEvent, byteArrayOutputStream);
        new TCPMsgV10(0, 0, byteArrayOutputStream.toByteArray()).write(outputStream);
    }

    @Override
    public void writeSecnReq(PkSecnReqEvent pkSecnReqEvent, OutputStream outputStream) throws IOException, PkException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        super.writeSecnReq(pkSecnReqEvent, byteArrayOutputStream);
        new TCPMsgV10(0, 0, byteArrayOutputStream.toByteArray()).write(outputStream);
    }

    @Override
    public void writeXcerReq(PkXcerReqEvent pkXcerReqEvent, OutputStream outputStream) throws IOException, PkException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        super.writeXcerReq(pkXcerReqEvent, byteArrayOutputStream);
        new TCPMsgV10(0, 0, byteArrayOutputStream.toByteArray()).write(outputStream);
    }

    @Override
    public void writeRevoRep(PkRevoRepEvent pkRevoRepEvent, OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        super.writeRevoRep(pkRevoRepEvent, byteArrayOutputStream);
        new TCPMsgV10(0, 5, byteArrayOutputStream.toByteArray()).write(outputStream);
    }

    @Override
    public void writeXcerRep(PkXcerRepEvent pkXcerRepEvent, OutputStream outputStream) throws IOException, PkException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        super.writeXcerRep(pkXcerRepEvent, byteArrayOutputStream);
        new TCPMsgV10(0, 5, byteArrayOutputStream.toByteArray()).write(outputStream);
    }

    @Override
    public void writeConfRep(PkConfRepEvent pkConfRepEvent, OutputStream outputStream) throws IOException {
        PKIMessage pKIMessage = (PKIMessage)pkConfRepEvent.getReq().getMsg();
        PKIHeader pKIHeader = pKIMessage.getHeader();
        BigInteger bigInteger = pKIHeader.getPvno();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Object object = pkConfRepEvent.getMsg();
        if (bigInteger.equals(BIG_ONE)) {
            if (object == null) {
                new TCPMsgV10(0, 3, byteArrayOutputStream.toByteArray()).write(outputStream);
            } else {
                new TCPMsgV10(0, 6, byteArrayOutputStream.toByteArray()).write(outputStream);
            }
        } else {
            super.writeConfRep(pkConfRepEvent, byteArrayOutputStream);
            new TCPMsgV10(0, 5, byteArrayOutputStream.toByteArray()).write(outputStream);
        }
    }

    @Override
    public void writePollReq(PkPollReqEvent pkPollReqEvent, OutputStream outputStream) throws IOException {
        new TCPMsgV10(0, 2, this.to4bytes(pkPollReqEvent.getPollReference())).write(outputStream);
    }

    private byte[] to4bytes(int n) {
        byte[] byArray = BigInteger.valueOf(n).toByteArray();
        if (byArray.length == 4) {
            return byArray;
        }
        byte by = (byte)(n >= 0 ? 0 : -1);
        byte[] byArray2 = new byte[]{by, by, by, by};
        System.arraycopy(byArray, 0, byArray2, 4 - byArray.length, byArray.length);
        return byArray2;
    }
}

