/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.fmt;

import com.ibm.security.certclient.base.PkAttr;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkEvent;
import com.ibm.security.certclient.base.PkEventFormatter;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkInitRepEvent;
import com.ibm.security.certclient.base.PkInitReqEvent;
import com.ibm.security.certclient.base.PkIoException;
import com.ibm.security.certclient.base.PkKupdRepEvent;
import com.ibm.security.certclient.base.PkKupdReqEvent;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.certclient.base.PkSecnRepEvent;
import com.ibm.security.certclient.base.PkSecnReqEvent;
import com.ibm.security.certclient.base.PkXcerRepEvent;
import com.ibm.security.certclient.base.PkXcerReqEvent;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcs9.PKCS9;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.UnresolvedAttribute;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;

public class PkPkcsEventFormatter
extends PkEventFormatter
implements PkConstants {
    private static final ObjectIdentifier EXT_OID = PkPkcsEventFormatter.getOID();

    private static final ObjectIdentifier getOID() {
        try {
            return new ObjectIdentifier("1.3.6.1.4.1.311.2.1.14");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public PkEvent readEvent(Object object, InputStream inputStream, PkReqEvent pkReqEvent) throws PkException, IOException {
        DerValue derValue = new DerValue(inputStream);
        try {
            return this.readCertReqEvent(object, derValue);
        }
        catch (IOException iOException) {
            return this.readCertRepEvent(object, derValue, pkReqEvent);
        }
    }

    @Override
    public void writeException(Exception exception, OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeCertReq(PkCertReqEvent pkCertReqEvent, OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2;
        Object object;
        PKCSAttributes pKCSAttributes = new PKCSAttributes();
        CertificateExtensions certificateExtensions = null;
        ArrayList<DerValue> arrayList = new ArrayList<DerValue>();
        DerValue[] derValueArray = pkCertReqEvent.getAttrs().iterator();
        while (derValueArray.hasNext()) {
            object = (Object[])derValueArray.next();
            if (!((PkAttr)object).isApproved() || !((PkAttr)object).isApplied()) continue;
            if (((PkAttr)object).isNameOid()) {
                pKCSAttributes = pKCSAttributes.addAttribute(new PKCSAttribute(new ObjectIdentifier(((PkAttr)object).getName()), ((PkAttr)object).getValue()));
                continue;
            }
            if (!((PkAttr)object).getName().startsWith("x509.info.extensions.")) continue;
            if (certificateExtensions == null) {
                certificateExtensions = new CertificateExtensions();
            }
            derOutputStream2 = OIDMap.getOID((String)((PkAttr)object).getName());
            derOutputStream = (CertAttrSet)((PkAttr)object).getValue();
            DerOutputStream derOutputStream3 = new DerOutputStream();
            try {
                derOutputStream.encode((OutputStream)derOutputStream3);
                DerValue derValue = new DerValue(derOutputStream3.toByteArray());
                arrayList.add(derValue);
            }
            catch (CertificateException certificateException) {
                throw new PkIoException(certificateException);
            }
        }
        if (arrayList.size() > 0) {
            derValueArray = new DerValue[arrayList.size()];
            object = arrayList.toArray();
            for (int i = 0; i < ((Object)object).length; ++i) {
                derValueArray[i] = (DerValue)object[i];
            }
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putSequence(derValueArray);
            derOutputStream = new DerOutputStream();
            derOutputStream.write((byte)49, derOutputStream2);
            pKCSAttributes = pKCSAttributes.addAttribute(new PKCSAttribute(new UnresolvedAttribute(EXT_OID, (Object)derOutputStream.toByteArray())));
        }
        derValueArray = pkCertReqEvent.getAttrs();
        object = ((AlgorithmId)derValueArray.getValue("x509.info.algorithmID")).getName();
        object = ((String)object).substring(0, ((String)object).indexOf("with"));
        try {
            derOutputStream2 = new CertificationRequest(new CertificationRequestInfo((X500Name)derValueArray.getValue("x509.info.subject"), (PublicKey)derValueArray.getValue("x509.info.key"), pKCSAttributes), (PrivateKey)derValueArray.getValue("cert.oper.privateKey"), (String)object);
        }
        catch (PKCSException pKCSException) {
            throw new PkIoException(pKCSException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PkIoException(noSuchAlgorithmException);
        }
        derOutputStream2.encode(outputStream);
    }

    @Override
    public void writeCertRep(PkCertRepEvent pkCertRepEvent, OutputStream outputStream) throws IOException {
        new ContentInfo((Content)new SignedData(new Certificate[]{pkCertRepEvent.getCert()}, null)).encode(outputStream);
    }

    protected PkCertReqEvent readCertReqEvent(Object object, DerValue derValue) throws IOException {
        CertificationRequest certificationRequest = new CertificationRequest(derValue.toByteArray());
        return new PkCertReqEvent(object, certificationRequest, this.getAttrs(certificationRequest));
    }

    protected PkCertRepEvent readCertRepEvent(Object object, DerValue derValue, PkReqEvent pkReqEvent) throws IOException {
        ContentInfo contentInfo = new ContentInfo(derValue.toByteArray());
        SignedData signedData = (SignedData)contentInfo.getContent();
        Certificate[] certificateArray = signedData.getCertificates();
        if (pkReqEvent instanceof PkInitReqEvent) {
            return new PkInitRepEvent(object, contentInfo, pkReqEvent, certificateArray[0]);
        }
        if (pkReqEvent instanceof PkSecnReqEvent) {
            return new PkSecnRepEvent(object, contentInfo, pkReqEvent, certificateArray[0]);
        }
        if (pkReqEvent instanceof PkXcerReqEvent) {
            return new PkXcerRepEvent(object, contentInfo, pkReqEvent, certificateArray[0]);
        }
        if (pkReqEvent instanceof PkKupdReqEvent) {
            return new PkKupdRepEvent(object, contentInfo, pkReqEvent, certificateArray[0]);
        }
        throw new PkIoException(PkNLSConstants.PKCSEVENT_BAD_REQUEST);
    }

    private PkAttrs getAttrs(CertificationRequest certificationRequest) throws IOException {
        CertificationRequestInfo certificationRequestInfo = certificationRequest.getCertRequestInfo();
        PkAttrs pkAttrs = new PkAttrs();
        PkPkcsEventFormatter.add(pkAttrs, "x509.info.subject", certificationRequestInfo.getSubjectName());
        try {
            PkPkcsEventFormatter.add(pkAttrs, "x509.info.key", certificationRequestInfo.getSubjectPublicKeyInfo());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PkIoException(invalidKeyException);
        }
        PKCSAttribute[] pKCSAttributeArray = certificationRequestInfo.getAttributes().getAttributes();
        for (int i = 0; i < pKCSAttributeArray.length; ++i) {
            ObjectIdentifier objectIdentifier = pKCSAttributeArray[i].getAttributeId();
            String string = PKCS9.getName((ObjectIdentifier)objectIdentifier);
            if (string != null) {
                PkPkcsEventFormatter.add(pkAttrs, string, pKCSAttributeArray[i].getAttributeValue());
                continue;
            }
            if (!objectIdentifier.equals(EXT_OID)) continue;
            DerInputStream derInputStream = new DerInputStream((byte[])pKCSAttributeArray[i].getAttributeValue());
            DerValue[] derValueArray = derInputStream.getSet(1);
            DerInputStream derInputStream2 = new DerInputStream(derValueArray[0].toByteArray());
            CertificateExtensions certificateExtensions = new CertificateExtensions(derInputStream2);
            Enumeration enumeration = certificateExtensions.getElements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                String string2 = !(e instanceof CertAttrSet) ? ((Extension)e).getExtensionId().toString() : "x509.info.extensions." + ((CertAttrSet)e).getName();
                PkPkcsEventFormatter.add(pkAttrs, string2, e);
            }
        }
        return pkAttrs;
    }

    private static void add(PkAttrs pkAttrs, String string, Object object) {
        pkAttrs.add(string, 1, object);
    }
}

