/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DTFJException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageRegister;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageStackFrame;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.MonitorState;
import com.ibm.jvm.dtfjview.commands.helpers.StateToString;
import com.ibm.jvm.dtfjview.commands.helpers.ThreadData;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoThreadCommand
extends BaseJdmpviewCommand {
    private int _pointerSize;
    private boolean _is_zOS = false;
    private Map<JavaThread, MonitorState> monitors = new HashMap<JavaThread, MonitorState>();
    private long lastRTAddress = 0L;
    private static final String JAVA_LANG_THREAD_CLASS = "java/lang/Thread";

    public InfoThreadCommand() {
        this.addCommand("info thread", "[<native thread ID>|<zOS TCB>|all|*]", "Displays information about Java and native threads");
    }

    public void run(String command, String[] args, IContext context, PrintStream outStream) throws CommandException {
        if (this.initCommand(command, args, context, outStream)) {
            return;
        }
        try {
            long currentRTAddress = this.ctx.getRuntime().getJavaVM().getAddress();
            if (currentRTAddress != this.lastRTAddress) {
                this.lastRTAddress = currentRTAddress;
                this.monitors = new HashMap<JavaThread, MonitorState>();
            }
        }
        catch (Exception e) {
            this.logger.fine("Error getting address of the JVM, cannot use cached monitor values. No JVM in process?");
            this.logger.log(Level.FINEST, "Error getting address of the JVM", e);
            this.monitors = new HashMap<JavaThread, MonitorState>();
        }
        if (this.monitors.isEmpty() && this.ctx.getRuntime() != null) {
            this.getMonitors(this.ctx.getRuntime());
        }
        this.doCommand(args);
    }

    public void doCommand(String[] args) {
        try {
            this._is_zOS = this.ctx.getImage().getSystemType().toLowerCase().contains("z/os");
        }
        catch (DataUnavailable e) {
            this.out.print(Exceptions.getDataUnavailableString());
        }
        catch (CorruptDataException e) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
        }
        String param = null;
        switch (args.length) {
            case 0: {
                try {
                    ImageThread it = this.ctx.getProcess().getCurrentThread();
                    if (null == it) {
                        this.out.println();
                        this.out.println("No current (failing) thread, try specifying a native thread ID, \"all\" or \"*\"");
                        ImageProcess ip = this.ctx.getProcess();
                        if (ip != null) {
                            this.printThreadSummary(ip);
                        }
                        return;
                    }
                    param = it.getID();
                    break;
                }
                catch (CorruptDataException e) {
                    this.out.println("exception encountered while getting information about current thread");
                    return;
                }
            }
            case 1: {
                param = args[0];
                if (!"ALL".equalsIgnoreCase(param) && !"*".equals(param)) break;
                param = null;
                break;
            }
            default: {
                this.out.println("\"info thread\" takes at most one parameter, which, if specified, must be a native thread ID or \"all\" or \"*\"");
                return;
            }
        }
        this.printAddressSpaceInfo(param, this.getJavaThreads(param));
    }

    private void printAddressSpaceInfo(String id, Map<String, List<ThreadData>> threads) {
        if (id == null) {
            this.out.println("native threads for address space");
        }
        this.printProcessInfo(id, threads);
        if (!threads.isEmpty()) {
            this.out.println("Java threads not associated with known native threads:");
            this.out.println();
            List<ThreadData> orphans = threads.remove(null);
            if (orphans != null) {
                for (ThreadData threadData : orphans) {
                    this.printJavaThreadInfo(threadData.getThread(), false);
                }
            }
            for (List list : threads.values()) {
                for (ThreadData td : list) {
                    this.printJavaThreadInfo(td.getThread(), false);
                }
            }
        }
    }

    private void printProcessInfo(String id, Map<String, List<ThreadData>> threads) {
        ImageProcess ip = this.ctx.getProcess();
        this._pointerSize = ip.getPointerSize();
        this.out.print(" process id: ");
        try {
            this.out.print(ip.getID());
        }
        catch (DataUnavailable d) {
            this.out.print(Exceptions.getDataUnavailableString());
        }
        catch (CorruptDataException e) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
        }
        this.out.println();
        this.out.println();
        boolean found = this.printThreadInfo(id, threads);
        if (!found) {
            this.out.println(" no native threads found with specified id");
            this.out.println();
        }
    }

    private boolean printThreadInfo(String id, Map<String, List<ThreadData>> threads) {
        boolean found = false;
        Iterator itThread = this.ctx.getProcess().getThreads();
        while (itThread.hasNext()) {
            Object next = itThread.next();
            if (next instanceof CorruptData) {
                this.out.println();
                this.out.print("  <corrupt data>");
                continue;
            }
            ImageThread it = (ImageThread)next;
            String currentTID = null;
            String currentTCB = null;
            try {
                currentTID = it.getID();
                if (this._is_zOS) {
                    currentTCB = it.getProperties().getProperty("TCB");
                }
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
            if (null != id && !id.equalsIgnoreCase(currentTID) && !id.equalsIgnoreCase(currentTCB)) continue;
            this.out.print("  thread id: ");
            this.out.println(currentTID);
            this.printRegisters(it);
            this.out.println("   native stack sections:");
            Iterator itStackSection = it.getStackSections();
            while (itStackSection.hasNext()) {
                Object nextStackSection = itStackSection.next();
                if (nextStackSection instanceof CorruptData) {
                    this.out.println("    " + Exceptions.getCorruptDataExceptionString());
                    continue;
                }
                ImageSection is = (ImageSection)nextStackSection;
                this.printStackSection(is);
            }
            this.printStackFrameInfo(it);
            this.out.println("   properties:");
            this.printProperties(it);
            this.out.print("   associated Java thread: ");
            List<ThreadData> list = threads.remove(currentTID);
            if (null == list || list.isEmpty()) {
                this.out.println("<no associated Java thread>");
            } else {
                this.out.println();
                this.printJavaThreadInfo(list.get(0).getThread(), true);
            }
            this.out.println();
            found = true;
        }
        return found;
    }

    public void printRegisters(ImageThread it) {
        this.out.print("   registers:");
        int count = 0;
        Iterator itImageRegister = it.getRegisters();
        while (itImageRegister.hasNext()) {
            if (count % 4 == 0) {
                this.out.println();
                this.out.print(" ");
            }
            this.out.print("   ");
            ImageRegister ir = (ImageRegister)itImageRegister.next();
            this.printRegisterInfo(ir);
            ++count;
        }
        this.out.println();
    }

    public void printRegisterInfo(ImageRegister ir) {
        this.out.print(Utils.padWithSpaces(ir.getName(), 6) + " = ");
        try {
            BigInteger bigValue;
            int width;
            Number value = ir.getValue();
            if (value instanceof BigInteger && (width = (bigValue = (BigInteger)value).bitLength()) > 64) {
                int paddedBits = (width - 1 | 0x3F) + 1;
                this.out.print("0x" + Utils.padWithZeroes(bigValue.toString(16), paddedBits / 4));
                return;
            }
            long registerValue = value.longValue();
            if (this._pointerSize > 32) {
                this.out.print("0x" + Utils.toFixedWidthHex(registerValue));
            } else if (this._is_zOS) {
                this.out.print("0x" + Utils.toFixedWidthHex((int)(registerValue >> 32)) + "_" + Utils.toFixedWidthHex((int)registerValue));
            } else {
                this.out.print("0x" + Utils.toFixedWidthHex((int)registerValue));
            }
        }
        catch (CorruptDataException e) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
        }
    }

    public void printStackSection(ImageSection is) {
        long startAddr = is.getBaseAddress().getAddress();
        long size = is.getSize();
        long endAddr = startAddr + size;
        this.out.print("    ");
        this.out.print(Utils.toHex(startAddr));
        this.out.print(" to ");
        this.out.print(Utils.toHex(endAddr));
        this.out.print(" (length ");
        this.out.print(Utils.toHex(size));
        this.out.println(")");
    }

    private void printStackFrameInfo(ImageThread it) {
        Iterator itStackFrame;
        try {
            itStackFrame = it.getStackFrames();
        }
        catch (DataUnavailable d) {
            this.out.println("   native stack frames: " + Exceptions.getDataUnavailableString());
            return;
        }
        this.out.println("   native stack frames:");
        while (itStackFrame.hasNext()) {
            Object o = itStackFrame.next();
            if (o instanceof CorruptData) {
                this.out.println("    <corrupt stack frame: " + ((CorruptData)o).toString() + ">");
                continue;
            }
            ImageStackFrame isf = (ImageStackFrame)o;
            this.out.print("    bp: ");
            try {
                this.out.print(this.toAdjustedHex(isf.getBasePointer().getAddress()));
            }
            catch (CorruptDataException e) {
                if (this.getArtifactType() == BaseJdmpviewCommand.ArtifactType.javacore) {
                    this.out.print(Exceptions.getDataUnavailableString());
                }
                this.out.print(Exceptions.getCorruptDataExceptionString());
            }
            this.out.print(" pc: ");
            try {
                this.out.print(this.toAdjustedHex(isf.getProcedureAddress().getAddress()));
            }
            catch (CorruptDataException e) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
            }
            this.out.print(" ");
            try {
                this.out.print(isf.getProcedureName());
            }
            catch (CorruptDataException e) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
            }
            this.out.println();
        }
    }

    private Map<String, List<ThreadData>> getJavaThreads(String id) {
        HashMap<String, List<ThreadData>> threads = new HashMap<String, List<ThreadData>>();
        JavaRuntime mr = this.ctx.getRuntime();
        if (mr instanceof JavaRuntime) {
            JavaRuntime jr = mr;
            Iterator itThread = jr.getThreads();
            while (itThread.hasNext()) {
                Object next = itThread.next();
                if (next instanceof CorruptData) continue;
                JavaThread jt = (JavaThread)next;
                String currentTID = null;
                String currentTCB = null;
                try {
                    ImageThread it = jt.getImageThread();
                    currentTID = it.getID();
                    if (this._is_zOS) {
                        currentTCB = it.getProperties().getProperty("TCB");
                    }
                }
                catch (DTFJException it) {
                    // empty catch block
                }
                if (null != id && !id.equalsIgnoreCase(currentTID) && !id.equalsIgnoreCase(currentTCB)) continue;
                ArrayList<ThreadData> ta = (ArrayList<ThreadData>)threads.get(currentTID);
                if (ta == null) {
                    ta = new ArrayList<ThreadData>(1);
                    threads.put(currentTID, ta);
                }
                ta.add(new ThreadData(jt, jr));
            }
        }
        return threads;
    }

    private void getMonitors(JavaRuntime jr) {
        int corruptThreadCount = 0;
        int corruptMonitorCount = 0;
        Iterator itMonitor = jr.getMonitors();
        while (itMonitor.hasNext()) {
            Object obj = itMonitor.next();
            if (obj instanceof CorruptData) {
                ++corruptMonitorCount;
                continue;
            }
            JavaMonitor jm = (JavaMonitor)obj;
            Iterator itEnterWaiter = jm.getEnterWaiters();
            while (itEnterWaiter.hasNext()) {
                obj = itEnterWaiter.next();
                if (obj instanceof CorruptData) {
                    ++corruptThreadCount;
                    continue;
                }
                JavaThread jt = (JavaThread)obj;
                this.monitors.put(jt, new MonitorState(jm, MonitorState.WAITING_TO_ENTER));
            }
            if (corruptThreadCount > 0) {
                String msg = String.format("Warning : %d corrupt thread(s) were found waiting to enter monitor %s", corruptThreadCount, InfoThreadCommand.getMonitorName(jm));
                this.logger.fine(msg);
            }
            corruptThreadCount = 0;
            Iterator itNotifyWaiter = jm.getNotifyWaiters();
            while (itNotifyWaiter.hasNext()) {
                obj = itNotifyWaiter.next();
                if (obj instanceof CorruptData) {
                    ++corruptThreadCount;
                    continue;
                }
                JavaThread jt = (JavaThread)obj;
                this.monitors.put(jt, new MonitorState(jm, MonitorState.WAITING_TO_BE_NOTIFIED_ON));
            }
            if (corruptThreadCount <= 0) continue;
            String msg = String.format("Warning : %d corrupt thread(s) were found waiting to be notified on monitor %s", corruptThreadCount, InfoThreadCommand.getMonitorName(jm));
            this.logger.fine(msg);
        }
        if (corruptMonitorCount > 0) {
            String msg = String.format("Warning : %d corrupt monitor(s) were found", corruptMonitorCount);
            this.logger.fine(msg);
        }
    }

    private static String getMonitorName(JavaMonitor monitor) {
        try {
            return monitor.getName();
        }
        catch (CorruptDataException e) {
            return "<corrupt monitor name>";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printJavaThreadInfo(JavaThread jt, boolean idPrinted) {
        block40: {
            this.out.print("    name:          ");
            try {
                this.out.print(jt.getName());
            }
            catch (CorruptDataException e) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
            }
            this.out.println();
            if (!idPrinted) {
                try {
                    if (jt.getImageThread() != null) {
                        this.out.print("    id:            ");
                        this.out.print(jt.getImageThread().getID());
                    }
                }
                catch (CorruptDataException e) {
                    this.out.print(Exceptions.getCorruptDataExceptionString());
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
                }
                catch (DataUnavailable e) {
                    this.out.print(Exceptions.getDataUnavailableString());
                    this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), e);
                }
                finally {
                    this.out.println();
                }
            }
            this.out.print("    Thread object: ");
            try {
                JavaObject threadObj = jt.getObject();
                if (null == threadObj) {
                    this.out.print("<no associated Thread object>");
                    break block40;
                }
                try {
                    JavaClass threadClass = threadObj.getJavaClass();
                    String threadClassName = threadClass.getName();
                    if (threadClassName != null) {
                        this.out.print(threadClassName + " @ ");
                    }
                    this.out.print(Utils.toHex(threadObj.getID().getAddress()));
                    while (threadClass != null && !JAVA_LANG_THREAD_CLASS.equals(threadClass.getName())) {
                        threadClass = threadClass.getSuperclass();
                    }
                    if (threadClass != null) {
                        Iterator itField = threadClass.getDeclaredFields();
                        boolean foundThreadId = false;
                        while (itField.hasNext()) {
                            JavaField jf = (JavaField)itField.next();
                            switch (jf.getName()) {
                                case "uniqueId": 
                                case "tid": {
                                    if (foundThreadId) break;
                                    this.out.println();
                                    this.out.print("    ID:            " + Utils.getVal(threadObj, jf));
                                    foundThreadId = true;
                                    break;
                                }
                                case "isDaemon": {
                                    this.out.println();
                                    this.out.print("    Daemon:        " + Utils.getVal(threadObj, jf));
                                    break;
                                }
                                case "threadRef": {
                                    try {
                                        String hex = Utils.toHex(jf.getLong(threadObj));
                                        this.out.println();
                                        this.out.print("    Native info:   !j9vmthread " + hex + "  !stack " + hex);
                                    }
                                    catch (MemoryAccessException memoryAccessException) {}
                                    break;
                                }
                            }
                        }
                    }
                }
                catch (CorruptDataException cde) {
                    this.out.print(" <in-flight or corrupt data encountered>");
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), cde);
                }
            }
            catch (CorruptDataException cde) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), cde);
            }
        }
        this.out.println();
        this.out.print("    Priority:      ");
        try {
            Integer pri = jt.getPriority();
            this.out.print(pri.toString());
        }
        catch (CorruptDataException e) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
            this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
        }
        this.out.println();
        this.out.print("    Thread.State:  ");
        try {
            this.out.print(StateToString.getThreadStateString(jt.getState()));
        }
        catch (CorruptDataException cde) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
            this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), cde);
        }
        this.out.println();
        this.out.print("    JVMTI state:   ");
        try {
            this.out.print(StateToString.getJVMTIStateString(jt.getState()));
        }
        catch (CorruptDataException cde) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
            this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), cde);
        }
        this.out.println();
        this.printThreadBlocker(jt);
        this.out.print("    Java stack frames: ");
        this.printJavaStackFrameInfo(jt);
        this.out.println();
    }

    private void printThreadBlocker(JavaThread jt) {
        try {
            if ((jt.getState() & 0x200) != 0) {
                this.out.print("      parked on: ");
                if (jt.getBlockingObject() == null) {
                    this.out.print("<unknown>");
                } else {
                    JavaObject jo = jt.getBlockingObject();
                    String lockID = Long.toHexString(jo.getID().getAddress());
                    this.out.print(jo.getJavaClass().getName() + "@0x" + lockID);
                    String ownerThreadName = "<unknown>";
                    String ownerThreadID = "<null>";
                    this.out.print(" owner name: ");
                    JavaThread lockOwnerThread = Utils.getParkBlockerOwner(jo, this.ctx.getRuntime());
                    if (lockOwnerThread != null) {
                        ownerThreadName = lockOwnerThread.getName();
                        if (lockOwnerThread.getImageThread() != null) {
                            ownerThreadID = lockOwnerThread.getImageThread().getID();
                        }
                    } else {
                        JavaObject lockOwnerObj = Utils.getParkBlockerOwnerObject(jo, this.ctx.getRuntime());
                        if (lockOwnerObj != null) {
                            ownerThreadName = Utils.getThreadNameFromObject(lockOwnerObj, this.ctx.getRuntime(), this.out);
                        }
                    }
                    this.out.print("\"" + ownerThreadName + "\"");
                    this.out.print(" owner id: " + ownerThreadID);
                }
                this.out.println();
            } else if ((jt.getState() & 0x100) != 0) {
                this.out.print("      waiting to be notified on: ");
            } else if ((jt.getState() & 0x400) != 0) {
                this.out.print("      waiting to enter: ");
            }
            if ((jt.getState() & 0x500) != 0) {
                MonitorState ms = this.monitors.get(jt);
                if (ms == null) {
                    this.out.println("<monitor information not available>");
                } else {
                    JavaObject jo = ms.getMonitor().getObject();
                    if (null == jo) {
                        String name = ms.getMonitor().getName();
                        if (name.equals("")) {
                            name = "<unnamed>";
                        }
                        this.out.print("\"" + name + "\"");
                        this.out.print(" with ID ");
                        this.out.print(Utils.toHex(ms.getMonitor().getID().getAddress()));
                    } else {
                        String lockID = Long.toHexString(jo.getID().getAddress());
                        this.out.print(jo.getJavaClass().getName() + "@0x" + lockID);
                    }
                    this.out.print(" owner name: ");
                    if (ms.getMonitor().getOwner() != null) {
                        this.out.print("\"" + ms.getMonitor().getOwner().getName() + "\"");
                        if (ms.getMonitor().getOwner().getImageThread() != null) {
                            this.out.print(" owner id: " + ms.getMonitor().getOwner().getImageThread().getID());
                        }
                    } else {
                        this.out.print("<unowned>");
                    }
                    this.out.println();
                }
            }
        }
        catch (CorruptDataException cde) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
            this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), cde);
        }
        catch (DataUnavailable e) {
            this.out.print(Exceptions.getDataUnavailableString());
            this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), e);
        }
        catch (MemoryAccessException e) {
            this.out.print(Exceptions.getMemoryAccessExceptionString());
            this.logger.log(Level.FINEST, Exceptions.getMemoryAccessExceptionString(), e);
        }
    }

    private void printJavaStackFrameInfo(JavaThread jt) {
        Iterator itStackFrame = jt.getStackFrames();
        if (!itStackFrame.hasNext()) {
            this.out.println("<no frames to print>");
            return;
        }
        this.out.println();
        while (itStackFrame.hasNext()) {
            JavaLocation jl;
            Object next = itStackFrame.next();
            if (next instanceof CorruptData) {
                this.out.println("     " + Exceptions.getCorruptDataExceptionString());
                return;
            }
            JavaStackFrame jsf = (JavaStackFrame)next;
            try {
                jl = jsf.getLocation();
            }
            catch (CorruptDataException e) {
                this.out.println("     " + Exceptions.getCorruptDataExceptionString());
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
                return;
            }
            this.out.print("     bp: ");
            try {
                this.out.print(this.toAdjustedHex(jsf.getBasePointer().getAddress()));
            }
            catch (CorruptDataException e) {
                this.out.print(Exceptions.getDataUnavailableString());
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
            }
            this.out.print("  method: ");
            try {
                String signature = null;
                try {
                    signature = jl.getMethod().getSignature();
                }
                catch (CorruptDataException e) {
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
                }
                if (signature == null) {
                    this.out.print(jl.getMethod().getDeclaringClass().getName() + "." + jl.getMethod().getName());
                } else {
                    this.out.print(Utils.getReturnValueName(signature) + " " + jl.getMethod().getDeclaringClass().getName() + "." + jl.getMethod().getName() + Utils.getMethodSignatureName(signature));
                }
            }
            catch (CorruptDataException e) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
            }
            catch (DataUnavailable e) {
                this.out.print(Exceptions.getDataUnavailableString());
                this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), e);
            }
            boolean isNative = false;
            try {
                isNative = Modifier.isNative(jl.getMethod().getModifiers());
            }
            catch (CorruptDataException e) {
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
            }
            if (!isNative) {
                this.out.print("  source: ");
                try {
                    this.out.print(jl.getFilename());
                }
                catch (DataUnavailable d) {
                    this.out.print(Exceptions.getDataUnavailableString());
                    this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), d);
                }
                catch (CorruptDataException e) {
                    this.out.print(Exceptions.getCorruptDataExceptionString());
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
                }
                this.out.print(":");
                try {
                    this.out.print(Integer.toString(jl.getLineNumber()));
                }
                catch (DataUnavailable d) {
                    this.out.print(Exceptions.getDataUnavailableString());
                    this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), d);
                }
                catch (CorruptDataException e) {
                    this.out.print(Exceptions.getCorruptDataExceptionString());
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
                }
            } else {
                this.out.print("  (Native Method)");
            }
            this.out.println();
            this.out.print("      objects:");
            Iterator itObjectRefs = jsf.getHeapRoots();
            if (!itObjectRefs.hasNext()) {
                this.out.print(" <no objects in this frame>");
            }
            while (itObjectRefs.hasNext()) {
                Object nextRef = itObjectRefs.next();
                if (nextRef instanceof CorruptData) {
                    this.out.println(Exceptions.getCorruptDataExceptionString());
                    break;
                }
                JavaReference jr = (JavaReference)nextRef;
                try {
                    if (!jr.isObjectReference()) continue;
                    JavaObject target = (JavaObject)jr.getTarget();
                    this.out.print(" " + Utils.toHex(target.getID().getAddress()));
                }
                catch (DataUnavailable d) {
                    this.out.print(Exceptions.getDataUnavailableString());
                    this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), d);
                }
                catch (CorruptDataException e) {
                    this.out.print(Exceptions.getCorruptDataExceptionString());
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
                }
                catch (NullPointerException n) {
                    this.out.print(Exceptions.getDataUnavailableString());
                    this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), n);
                }
            }
            this.out.println();
        }
    }

    private String toAdjustedHex(long l) {
        if (this._pointerSize > 32) {
            return "0x" + Utils.toFixedWidthHex(l);
        }
        if (31 == this._pointerSize) {
            return "0x" + Utils.toFixedWidthHex((int)(l & Integer.MAX_VALUE));
        }
        return "0x" + Utils.toFixedWidthHex((int)l);
    }

    private void printThreadSummary(ImageProcess ip) {
        int count = 0;
        Iterator itThread = ip.getThreads();
        while (itThread.hasNext()) {
            Object next = itThread.next();
            if (next instanceof CorruptData) continue;
            ImageThread it = (ImageThread)next;
            if (count % 8 == 0) {
                this.out.println();
                if (0 == count) {
                    this.out.println();
                    this.out.println("Native thread IDs for current process:");
                }
                this.out.print(" ");
            }
            try {
                this.out.print(Utils.padWithSpaces(it.getID(), 8));
            }
            catch (CorruptDataException e) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
            }
            ++count;
        }
        this.out.println();
    }

    private void printProperties(ImageThread it) {
        List table = it.getProperties().entrySet().stream().sorted(Comparator.comparing(e -> String.valueOf(e.getKey()))).map(e -> String.format("%s=%s", e.getKey(), e.getValue())).collect(Collectors.toCollection(ArrayList::new));
        int count = table.size();
        if (count % 2 != 0) {
            table.add("");
            ++count;
        }
        int maxLen = 0;
        for (int i = 0; i < count; i += 2) {
            maxLen = Math.max(((String)table.get(i)).length(), maxLen);
        }
        String tableFormatString = "    %-" + maxLen + "s   %s%n";
        for (int i = 0; i < count; i += 2) {
            this.out.printf(tableFormatString, table.get(i), table.get(i + 1));
        }
    }

    @Override
    public void printDetailedHelp(PrintStream outStream) {
        outStream.printf("Displays information about Java and native threads%n%nParameters: none, native thread ID, zOS TCB address, \"all\", or \"*\"%n%nIf no parameter is supplied, information is printed for the current or failing thread, if any%nIf a native thread ID or zOS TCB address is supplied, information is printed for that specific thread%nIf \"all\", or \"*\" is specified, information is printed for all threads%n%nThe following information is printed for each thread:%n - native thread ID%n - registers%n - native stack sections%n - native stack frames: procedure name and base pointer%n - thread properties%n - associated Java thread (if applicable):%n  - name of Java thread%n  - address of associated java.lang.Thread object%n  - current state according to JVMTI specification%n  - current state relative to java.lang.Thread.State%n  - the Java thread priority%n  - the monitor the thread is waiting to enter or waiting on notify%n  - Java stack frames: base pointer, method, source filename and objects on frame%n%nNote: the \"info proc\" command provides a summary list of native thread IDs%n", new Object[0]);
    }
}

