/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.helpers;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.jvm.dtfjview.commands.helpers.NodeList;
import java.util.Iterator;

public class MonitorNode {
    public static final int UNKNOWN = 0;
    public static final int NO_DEADLOCK = 1;
    public static final int LOOP_DEADLOCK = 2;
    public static final int BRANCH_DEADLOCK = 3;
    private JavaMonitor monitor;
    public int visit;
    public MonitorNode waitingOn;
    public int deadlock;
    public NodeList inList;

    protected MonitorNode() {
        this.visit = 0;
        this.waitingOn = null;
        this.deadlock = 0;
        this.inList = null;
    }

    public MonitorNode(JavaMonitor _monitor) {
        this.monitor = _monitor;
        this.visit = 0;
        this.waitingOn = null;
        this.deadlock = 0;
        this.inList = null;
    }

    private JavaMonitor getMonitor() {
        return this.monitor;
    }

    public Iterator getEnterWaiters() {
        return this.monitor.getEnterWaiters();
    }

    public JavaThread getOwner() throws CorruptDataException, MemoryAccessException {
        return this.monitor.getOwner();
    }

    public JavaObject getObject() {
        return this.monitor.getObject();
    }

    public String getType() {
        try {
            if (this.monitor.getObject() != null) {
                return "monitor for " + this.monitor.getObject().getJavaClass().getName();
            }
            return "raw monitor";
        }
        catch (CorruptDataException e) {
            return "monitor";
        }
    }

    public long getMonitorAddress() {
        return this.monitor.getID().getAddress();
    }
}

