/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.jvm.dtfjview.Session;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.spi.ICombinedContext;
import com.ibm.jvm.dtfjview.spi.ISession;
import com.ibm.jvm.dtfjview.spi.ISessionContextManager;
import java.io.PrintStream;

public class CloseCommand
extends BaseJdmpviewCommand {
    private static final String CMD_NAME = "close";

    public CloseCommand() {
        this.addCommand(CMD_NAME, "[context id]", "closes the connection to a core file");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        Object obj = this.ctx.getProperties().get("session");
        if (obj == null) {
            this.logger.fine("Could not close a new context as the session property has not been set");
            return;
        }
        if (!(obj instanceof Session)) {
            this.logger.fine("Could not close an existing context as the session type was not recognised [" + obj.getClass().getName() + "]");
            return;
        }
        ISessionContextManager mgr = ((ISession)obj).getContextManager();
        switch (args.length) {
            case 0: {
                out.println("Closing all contexts");
                mgr.removeAllContexts();
                out.println("All contexts have been closed");
                break;
            }
            case 1: {
                out.println("Closing all contexts sharing the same Image");
                int id = Integer.valueOf(args[0]);
                ICombinedContext toclose = mgr.getContext(id);
                if (toclose == null) {
                    out.println("The specified context id " + args[0] + " was invalid");
                    return;
                }
                mgr.removeContexts(toclose.getImage().getSource());
                out.println("Closed all contexts created from " + toclose.getImage().getSource());
                break;
            }
            default: {
                out.println("This command takes 0 or 1 parameters. Execute 'close help' for more information");
                return;
            }
        }
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println("Closes the connection to a image source. The connection to be closed is determined by the current context, which means that more than one context may be removed depending on how many were created against the original source.");
    }
}

