/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.sources;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.ConfigurableElement;
import com.ibm.java.diagnostics.common.datamodel.impl.data.ControllableSingleConfigurableItemData;
import com.ibm.java.diagnostics.common.datamodel.impl.data.ControlledSingleConfigurationItemData;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.progress.ProgressIndicatorImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.LineParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.sources.ConfigurableSource;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import com.ibm.java.diagnostics.healthcenter.sources.Messages;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public abstract class SourceConfigurationParser
implements LineParser {
    private static final String CONFIGURATION = SubsystemDataBuilder.CONFIGURATION;
    private static final String HASH = "#";
    private static final String EQUALS = "=";
    private static final String SUBSYSTEM = "subsystem";
    public static final String SOURCE_TAG = "#Configuration saved by";
    private static final Logger TRACE = LogFactory.getTrace(SourceConfigurationParser.class);
    private boolean gotGoodData = false;
    private Map<String, ConfigurableElement> configurableElements;
    private static final String CLASSNAME = SourceConfigurationParser.class.getName();

    /*
     * WARNING - void declaration
     */
    @Override
    public ProgressIndicator parse(DynamicSource dynamicSource, String[] stringArray, DataBuilder dataBuilder, OutputProperties outputProperties) {
        void var8_11;
        TRACE.entering(CLASSNAME, "parse");
        if (this.configurableElements == null) {
            this.initializeConfigurableElements();
        }
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(CONFIGURATION);
        int n = 0;
        int n2 = 0;
        for (String string : stringArray) {
            if (!this.gotGoodData && string.contains(SOURCE_TAG) && string.toLowerCase().contains(this.getConfigurationFileTag().toLowerCase())) {
                this.gotGoodData = true;
                if (dataBuilder2 == null) {
                    dataBuilder2 = new StringDataImpl(CONFIGURATION);
                    dataBuilder.addData(dataBuilder2);
                }
            } else if (this.gotGoodData && dataBuilder2 != null) {
                if (!string.startsWith(HASH)) {
                    boolean bl = this.parseLine(dynamicSource, string, dataBuilder2, dataBuilder);
                    if (!bl) {
                        TRACE.fine(MessageFormat.format(Messages.getString("SourceConfigurationParser.could.not.parse"), string));
                    }
                } else if (string.contains(SOURCE_TAG)) {
                    String string2 = MessageFormat.format("Received configurable source eyecatcher again.  Parsing line: '{0}'", string);
                    TRACE.fine(string2);
                }
            }
            if (this.gotGoodData && (!this.gotGoodData || dataBuilder2 == null)) continue;
            n += string.getBytes().length;
            ++n2;
        }
        if (this.gotGoodData) {
            ProgressIndicatorImpl progressIndicatorImpl = new ProgressIndicatorImpl(n2, n, 1000);
        } else {
            ProgressIndicator progressIndicator = ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
        }
        TRACE.exiting(CLASSNAME, "parse");
        return var8_11;
    }

    private void initializeConfigurableElements() {
        Set<ConfigurableElement> set = this.getConfigurableElements();
        this.configurableElements = new HashMap<String, ConfigurableElement>();
        if (set == null) {
            return;
        }
        for (ConfigurableElement configurableElement : set) {
            this.configurableElements.put(configurableElement.getCommand(), configurableElement);
        }
    }

    private boolean parseLine(DynamicSource dynamicSource, String string, DataBuilder dataBuilder, DataBuilder dataBuilder2) {
        boolean bl = true;
        try {
            String string2 = string.trim();
            if (string2.contains(EQUALS)) {
                String[] stringArray = string2.split(EQUALS);
                boolean bl2 = "on".equals(stringArray[1]);
                DataBuilder dataBuilder3 = this.addSubsystemLevelConfigurationNode(dataBuilder);
                ConfigurableElement configurableElement = this.configurableElements.get(stringArray[0]);
                if (configurableElement == null) {
                    return false;
                }
                DataBuilder dataBuilder4 = null;
                String string3 = configurableElement.getCommand();
                dataBuilder4 = dataBuilder3.getData(string3);
                if (dataBuilder4 != null) {
                    DataBuilder dataBuilder5 = dataBuilder2.getTopLevelData(this.getSubsystemLabel());
                    if (dataBuilder5 != null) {
                        boolean bl3 = dataBuilder5.isEnabled();
                        if (bl3 && !bl2) {
                            dataBuilder5.setEnabled(bl2);
                        } else if (!bl3 && bl2) {
                            dataBuilder2.removeData(this.getSubsystemLabel());
                        }
                    }
                    dataBuilder4.setEnabled(bl2);
                } else {
                    dataBuilder4 = dynamicSource instanceof ConfigurableSource ? new ControllableSingleConfigurableItemData(configurableElement, (ConfigurableSource)dynamicSource) : new ControlledSingleConfigurationItemData(configurableElement, bl2);
                    dataBuilder3.addData(dataBuilder4);
                }
            } else {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private DataBuilder addSubsystemLevelConfigurationNode(DataBuilder dataBuilder) {
        String string = this.getSubsystemLabel() + SubsystemDataBuilder.CONFIGURATION;
        DataBuilder dataBuilder2 = dataBuilder.getData(string);
        if (dataBuilder2 == null) {
            dataBuilder2 = new StringDataImpl(string);
            dataBuilder.addData(dataBuilder2);
        }
        return dataBuilder2;
    }

    protected abstract String getSubsystemLabel();

    protected abstract Set<ConfigurableElement> getConfigurableElements();

    protected abstract String getConfigurationFileTag();
}

