/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.locking.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StringData;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalData;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.locking.LockingLabels;
import com.ibm.java.diagnostics.healthcenter.locking.Messages;
import com.ibm.java.diagnostics.healthcenter.locking.data.MonitorData;
import com.ibm.java.diagnostics.healthcenter.locking.data.MonitorTableData;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;

public class InflatedMonitorsAnalyserPostProcessor
implements PostProcessor {
    private static final Logger TRACE = LogFactory.getTrace(InflatedMonitorsAnalyserPostProcessor.class);
    private static final String CLASS_NAME = InflatedMonitorsAnalyserPostProcessor.class.getName();
    private static final DataFactory dataFactory = DataFactory.getFactory();
    private static final String NO_JAVA_MONITORS = Messages.getString("Locking.noInflatedJavaMonitors");
    private static final String NO_PROBLEMS_DETECTED = Messages.getString("Locking.noProblemsDetected");
    private static final String HIGH_MISS_TEMPLATE = Messages.getString("Locking.highMissPercentageTemplate");
    private static final String HIGH_HOLD_AND_UTIL_TEMPLATE = Messages.getString("Locking.highAverageHoldAndUtilTemplate");
    private static final String LOW_HOLD_HIGH_UTIL_TEMPLATE = Messages.getString("Locking.lowAverageHoldHighUtilTemplate");
    private static final String HIGH_MISS_LOW_UTIL = Messages.getString("Locking.highMissLowUtil");
    private static final String WARNING_DETECTED = Messages.getString("Locking.warningDetected");
    private static final String WARNINGS_DETECTED = Messages.getString("Locking.warningsDetected");
    private static final double MISS_PERCENTAGE_WARNING = 30.0;
    private static final double UTIL_PERCENTAGE_WARNING = 30.0;
    private static final double AVG_HOLD_MS_WARNING = 30.0;
    private static final Comparator<MonitorData> DESCENDING_MISS_PERCENTAGE_COMPARATOR = new Comparator<MonitorData>(){

        @Override
        public int compare(MonitorData monitorData, MonitorData monitorData2) {
            double d = InflatedMonitorsAnalyserPostProcessor.getMissPercentage(monitorData);
            double d2 = InflatedMonitorsAnalyserPostProcessor.getMissPercentage(monitorData2);
            return Double.compare(d, d2);
        }
    };

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASS_NAME, "postprocess");
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(LockingLabels.LOCKING_SUBSYSTEM_DATA_LABEL);
        if (dataBuilder2 == null || !(dataBuilder2 instanceof SubsystemDataBuilder)) {
            TRACE.exiting(CLASS_NAME, "postprocess");
            return;
        }
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder2;
        MonitorTableData monitorTableData = (MonitorTableData)subsystemDataBuilder.getTopLevelData(LockingLabels.JAVA_MONITORS_LABEL);
        StructuredStringDataBuilder structuredStringDataBuilder = dataFactory.createStructuredStringData(LockingLabels.RECOMMENDATION_LABEL);
        subsystemDataBuilder.clearValue();
        subsystemDataBuilder.addData(structuredStringDataBuilder);
        if (monitorTableData == null) {
            subsystemDataBuilder.addValue(NO_JAVA_MONITORS);
            structuredStringDataBuilder.addGoodThing(NO_JAVA_MONITORS);
            TRACE.exiting(CLASS_NAME, "postprocess");
            return;
        }
        ArrayList<StructuredStringDataBuilder> arrayList = new ArrayList<StructuredStringDataBuilder>();
        MonitorData[] monitorDataArray = monitorTableData.getMonitors();
        try {
            Arrays.sort(monitorDataArray, DESCENDING_MISS_PERCENTAGE_COMPARATOR);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        for (MonitorData data : monitorDataArray) {
            StructuredStringDataBuilder structuredStringDataBuilder2 = InflatedMonitorsAnalyserPostProcessor.getRecommendation(data);
            if (structuredStringDataBuilder2 == null) continue;
            arrayList.add(structuredStringDataBuilder2);
        }
        if (arrayList.size() == 0) {
            subsystemDataBuilder.addValue(NO_PROBLEMS_DETECTED);
            structuredStringDataBuilder.addGoodThing(NO_PROBLEMS_DETECTED);
        } else {
            int n = arrayList.size();
            int n2 = 0;
            for (StringData stringData : arrayList) {
                if (n2 >= 20) continue;
                structuredStringDataBuilder.addWarning(stringData.getValue());
                ++n2;
            }
            subsystemDataBuilder.clearValue();
            if (n == 1) {
                subsystemDataBuilder.addValue(WARNING_DETECTED);
            } else {
                subsystemDataBuilder.addValue(MessageFormat.format(WARNINGS_DETECTED, n));
            }
        }
        TRACE.exiting(CLASS_NAME, "postprocess");
    }

    private static StructuredStringDataBuilder getRecommendation(MonitorData monitorData) {
        double d = -1.0;
        double d2 = -1.0;
        double d3 = -1.0;
        double d4 = -1.0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        d = InflatedMonitorsAnalyserPostProcessor.getMissPercentage(monitorData);
        bl = d >= 30.0;
        d2 = InflatedMonitorsAnalyserPostProcessor.getUtilisationPercentage(monitorData);
        bl2 = d2 >= 30.0;
        d3 = InflatedMonitorsAnalyserPostProcessor.getAverageHoldTime(monitorData);
        double d5 = InflatedMonitorsAnalyserPostProcessor.getCyclesToMsConversion(monitorData);
        d4 = d5 * d3;
        bl3 = d4 >= 30.0;
        String string = monitorData.getLabel().trim();
        StructuredStringDataBuilder structuredStringDataBuilder = null;
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            structuredStringDataBuilder = dataFactory.createStructuredStringData(LockingLabels.RECOMMENDATION_LABEL);
            stringBuilder.append(MessageFormat.format(HIGH_MISS_TEMPLATE, string, Math.round(d)));
            if (bl2) {
                if (bl3) {
                    stringBuilder.append(MessageFormat.format(HIGH_HOLD_AND_UTIL_TEMPLATE, Math.round(d2), d4));
                } else {
                    stringBuilder.append(MessageFormat.format(LOW_HOLD_HIGH_UTIL_TEMPLATE, Math.round(d2), d4));
                }
            } else {
                stringBuilder.append(HIGH_MISS_LOW_UTIL);
            }
            structuredStringDataBuilder.addWarning(stringBuilder.toString());
        }
        return structuredStringDataBuilder;
    }

    private static double getCyclesToMsConversion(MonitorData monitorData) {
        TwoDimensionalData twoDimensionalData = (TwoDimensionalData)((Object)monitorData.getData(LockingLabels.INTERVAL_TIME_LABEL));
        DataPointBuilder[] dataPointBuilderArray = twoDimensionalData.getDataPoints();
        if (dataPointBuilderArray.length < 2) {
            return 0.0;
        }
        double d = -1.0;
        double d2 = -1.0;
        double d3 = -1.0;
        d3 = twoDimensionalData.getRawTotalY() - dataPointBuilderArray[0].getRawY();
        d = dataPointBuilderArray[1].getRawX();
        d2 = dataPointBuilderArray[dataPointBuilderArray.length - 1].getRawX() - d;
        return d2 / d3;
    }

    private static double getAverageHoldTime(MonitorData monitorData) {
        TwoDimensionalData twoDimensionalData = (TwoDimensionalData)((Object)monitorData.getTopLevelData(LockingLabels.HOLD_TIME_LABEL));
        TwoDimensionalData twoDimensionalData2 = (TwoDimensionalData)((Object)monitorData.getTopLevelData(LockingLabels.NONRECURSIVE_LABEL));
        if (twoDimensionalData != null && twoDimensionalData2 != null) {
            return twoDimensionalData.getRawTotalY() / twoDimensionalData2.getRawTotalY();
        }
        return -1.0;
    }

    private static double getUtilisationPercentage(MonitorData monitorData) {
        TwoDimensionalData twoDimensionalData = (TwoDimensionalData)((Object)monitorData.getTopLevelData(LockingLabels.HOLD_TIME_LABEL));
        TwoDimensionalData twoDimensionalData2 = (TwoDimensionalData)((Object)monitorData.getTopLevelData(LockingLabels.INTERVAL_TIME_LABEL));
        if (twoDimensionalData != null && twoDimensionalData2 != null) {
            return twoDimensionalData.getRawTotalY() / twoDimensionalData2.getRawTotalY() * 100.0;
        }
        return -1.0;
    }

    private static double getMissPercentage(MonitorData monitorData) {
        TwoDimensionalData twoDimensionalData = (TwoDimensionalData)((Object)monitorData.getTopLevelData(LockingLabels.SLOW_LABEL));
        TwoDimensionalData twoDimensionalData2 = (TwoDimensionalData)((Object)monitorData.getTopLevelData(LockingLabels.NONRECURSIVE_LABEL));
        if (twoDimensionalData != null && twoDimensionalData2 != null) {
            return twoDimensionalData.getRawTotalY() / twoDimensionalData2.getRawTotalY() * 100.0;
        }
        return -1.0;
    }
}

