/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.jvmtrace.impl;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.progress.ProgressIndicatorImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.ByteParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterMBean;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionDataBuilder;
import com.ibm.java.diagnostics.healthcenter.impl.jmx.JMXAgentConnection;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.JMXConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.data.JVMDataImpl;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceAxisUtil;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePointHandler;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.impl.Messages;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.impl.TraceMetaDataImpl;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.impl.TraceParser;
import com.ibm.java.diagnostics.healthcenter.postprocessor.VMLevelChecker;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import com.ibm.jvm.trace.format.api.TraceContext;
import com.ibm.jvm.trace.format.api.TraceThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JVMTITraceParser
extends TraceParser
implements ByteParser {
    private static final Logger TRACE = LogFactory.getTrace(JVMTITraceParser.class);
    private final String CLASSNAME = JVMTITraceParser.class.getName();
    private static final String INITIAL_DROPPED_TRACE_BUFFERS_TEMPLATE = Messages.getString("JVMTITraceParser.initial.dropped.trace.buffers");
    private static final String DROPPED_TRACE_BUFFERS_TEMPLATE = Messages.getString("JVMTITraceParser.dropped.trace.buffers");
    private static final int EYE_CATCHER_LENGTH = 4;
    private static final int SIZE_FIELD_LEN = 8;
    private static final int HEADER_LENGTH = 12;
    private boolean hasWarnedAboutMissingTrace = false;
    private int totalBytesReceived;
    private int totalBuffersDropped;
    private int sessionID = 0;
    private int traceHeaderRetryCount = 0;
    private int MAX_HEADER_RETRY_COUNT = 200;
    private boolean retryingTraceHeader = false;

    @Override
    public ProgressIndicator parse(DynamicSource dynamicSource, byte[] byArray, DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(this.CLASSNAME, "parse");
        assert (byArray != null);
        if (byArray.length < 12) {
            TRACE.exiting(this.CLASSNAME, "parse");
            return new ProgressIndicatorImpl(0, 0L, 12);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        HashSet<TraceThread> hashSet = new HashSet<TraceThread>();
        if (this.retryingTraceHeader) {
            ++this.traceHeaderRetryCount;
        }
        block7: while (byteBuffer.remaining() >= 12) {
            DataBuilder dataBuilder2;
            int n;
            long l;
            Object object222;
            byteBuffer.mark();
            byte[] byArray2 = new byte[4];
            byteBuffer.get(byArray2);
            ChunkType chunkType = null;
            for (Object object222 : ChunkType.ALL_VALID_CHUNK_TYPES) {
                if (!Arrays.equals(byArray2, object222.getEyeCatcher())) continue;
                chunkType = object222;
                break;
            }
            if (this.retryingTraceHeader && this.traceHeaderRetryCount > this.MAX_HEADER_RETRY_COUNT) {
                TRACE.warning(Thread.currentThread() + Messages.getString("JVMTITraceParser.no.trace.header"));
                TRACE.exiting(this.CLASSNAME, "parse");
                return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
            }
            if (chunkType == ChunkType.TRACE_BUFFER) {
                l = byteBuffer.getLong();
                assert (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE);
                if ((long)byteBuffer.remaining() >= l) {
                    assert (l < Integer.MAX_VALUE);
                    n = (int)l;
                    object222 = new byte[n];
                    byteBuffer.get((byte[])object222, 0, n);
                    if (this.retryingTraceHeader) continue;
                    if (this.metaData == null) {
                        Object illegalArgumentException = null;
                        DataBuilder exception = dataBuilder.findRootData();
                        dataBuilder2 = (ConnectionDataBuilder)exception.getData(JVMLabels.CONNECTION);
                        if (dataBuilder2 instanceof JMXConnectionDataImpl) {
                            JMXConnectionDataImpl jMXConnectionDataImpl = (JMXConnectionDataImpl)dataBuilder2;
                            JMXAgentConnection jMXAgentConnection = jMXConnectionDataImpl.getAgentConnection();
                            HealthCenterMBean healthCenterMBean = jMXAgentConnection.getProxy();
                            if (jMXAgentConnection.getSessionId() != this.sessionID) {
                                this.traceHeaderRetryCount = 0;
                            }
                            List<Map<String, String>> list = healthCenterMBean.getLiveSourceDetails();
                            for (int i = 0; i < list.size(); ++i) {
                                if (!list.get(i).containsValue("TRACESubscriberSource")) continue;
                                try {
                                    TRACE.fine(Thread.currentThread() + Messages.getString("JVMTITraceParser.no.trace.header"));
                                    healthCenterMBean.restartProvider(i, jMXAgentConnection.getSessionId());
                                    this.retryingTraceHeader = true;
                                    continue block7;
                                }
                                catch (Exception exception2) {
                                    TRACE.exiting(this.CLASSNAME, "parse");
                                    return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
                                }
                            }
                        } else {
                            dataBuilder2.outputMessage("trace", "header", new String[0]);
                            continue;
                        }
                    }
                    if (this.metaData == null) continue;
                    try {
                        TraceThread iOException = this.traceContext.addData((byte[])object222);
                        hashSet.add(iOException);
                        this.notifyTracePointHandlers(dynamicSource, hashSet, dataBuilder, outputProperties);
                        this.unreportedParsedTraceBytes += n;
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        TRACE.logp(Level.WARNING, this.CLASSNAME, "parse", Messages.getString("JVMTITraceParser.invalid.trace.buffer"), illegalArgumentException);
                        TRACE.exiting(this.CLASSNAME, "parse");
                        break;
                    }
                    catch (Exception exception) {
                        TRACE.logp(Level.WARNING, this.CLASSNAME, "parse", Messages.getString("JVMTITraceParser.invalid.trace.header"), exception);
                        TRACE.exiting(this.CLASSNAME, "parse");
                        return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
                    }
                }
                byteBuffer.reset();
                break;
            }
            if (chunkType == ChunkType.TRACE_METADATA) {
                l = byteBuffer.getLong();
                assert (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE);
                if ((long)byteBuffer.remaining() >= l) {
                    assert (l < Integer.MAX_VALUE);
                    n = (int)l;
                    object222 = new byte[n];
                    byteBuffer.get((byte[])object222, 0, n);
                    if (this.traceContext != null) continue;
                    try {
                        this.traceContext = this.suppressTraceFormatMessages ? TraceContext.getContext((byte[])object222, ((ChunkType)object222).length, TraceParser.class.getResourceAsStream("/deps/J9TraceFormat.dat"), null, null, null, null) : TraceContext.getContext((byte[])object222, ((ChunkType)object222).length, TraceParser.class.getResourceAsStream("/deps/J9TraceFormat.dat"));
                        this.traceContext.setTraceType(1);
                        this.traceContext.addMessageData(TraceParser.class.getResourceAsStream("/deps/TraceFormat.dat"));
                        this.traceContext.addMessageData(TraceParser.class.getResourceAsStream("/deps/OMRTraceFormat.dat"));
                        VMLevelChecker vMLevelChecker = new VMLevelChecker(this.traceContext.getVmVersionString());
                        dataBuilder2 = (JVMDataImpl)dataBuilder.findRootData();
                        if (vMLevelChecker.isVMRealtime() || ((JVMDataImpl)dataBuilder2).isRealtimeVM() || ((JVMDataImpl)dataBuilder2).isSoftRealtimeVM()) {
                            this.traceContext.addMessageData(TraceParser.class.getResourceAsStream("/deps/J9TraceFormatRT.dat"));
                        }
                    }
                    catch (IOException iOException) {
                        TRACE.logp(Level.WARNING, this.CLASSNAME, "parse", Messages.getString("JVMTITraceParser.invalid.trace.buffer"), iOException);
                        TRACE.exiting(this.CLASSNAME, "parse");
                        return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
                    }
                    TRACE.fine(Thread.currentThread() + Messages.getString("JVMTITraceParser.trace.header.added"));
                    this.retryingTraceHeader = false;
                    this.metaData = new TraceMetaDataImpl(this.traceContext);
                    TraceAxisUtil.clearConverter();
                    for (TracePointHandler tracePointHandler : this.handlers) {
                        tracePointHandler.handleTraceStart(dynamicSource, this.metaData, dataBuilder, outputProperties);
                    }
                    continue;
                }
                if (chunkType == ChunkType.TRACE_METADATA && this.metaData != null) continue;
                byteBuffer.reset();
                break;
            }
            if (chunkType == ChunkType.DROPPED_BUFFERS) {
                l = byteBuffer.getLong();
                assert (l == 4L);
                n = byteBuffer.getInt();
                if (n <= 0) continue;
                if (this.traceContext != null && this.traceContext.getTotalRecords() == 0L) {
                    TRACE.fine(MessageFormat.format(INITIAL_DROPPED_TRACE_BUFFERS_TEMPLATE, n));
                    continue;
                }
                if (!this.hasWarnedAboutMissingTrace) {
                    TRACE.warning(MessageFormat.format(DROPPED_TRACE_BUFFERS_TEMPLATE, n));
                    this.hasWarnedAboutMissingTrace = true;
                } else {
                    TRACE.fine(MessageFormat.format(DROPPED_TRACE_BUFFERS_TEMPLATE, n));
                }
                this.totalBuffersDropped += n;
                if (this.traceContext == null) continue;
                int n2 = n * this.traceContext.getRecordSize();
                this.unreportedMissingTraceBytes += n2;
                this.traceContext.discardedData();
                continue;
            }
            TRACE.exiting(this.CLASSNAME, "parse");
            return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
        }
        this.totalBytesReceived += byteBuffer.position();
        TRACE.exiting(this.CLASSNAME, "parse");
        return new ProgressIndicatorImpl(byteBuffer.position(), byteBuffer.position(), byteBuffer.position());
    }

    private static final class ChunkType
    extends Enum<ChunkType> {
        public static final /* enum */ ChunkType TRACE_BUFFER = new ChunkType("HCTB");
        public static final /* enum */ ChunkType TRACE_METADATA = new ChunkType("HCTH");
        public static final /* enum */ ChunkType DROPPED_BUFFERS = new ChunkType("HCDB");
        static final ChunkType[] ALL_VALID_CHUNK_TYPES;
        private final byte[] eyeCatcher;
        private static final /* synthetic */ ChunkType[] $VALUES;

        public static ChunkType[] values() {
            return (ChunkType[])$VALUES.clone();
        }

        public static ChunkType valueOf(String string) {
            return Enum.valueOf(ChunkType.class, string);
        }

        private ChunkType(String string2) {
            assert (string2.length() == 4);
            char[] cArray = string2.toCharArray();
            this.eyeCatcher = new byte[4];
            for (int i = 0; i < 4; ++i) {
                this.eyeCatcher[i] = (byte)cArray[i];
            }
        }

        public byte[] getEyeCatcher() {
            return this.eyeCatcher;
        }

        static {
            $VALUES = new ChunkType[]{TRACE_BUFFER, TRACE_METADATA, DROPPED_BUFFERS};
            ALL_VALID_CHUNK_TYPES = ChunkType.values();
        }
    }
}

