/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.jvmtrace;

import com.ibm.java.diagnostics.common.datamodel.data.axes.UnitConverterDefinition;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.UnitConverterDefinitionImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.Base60Formatter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.AbstractClockCyclesConverter;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;

public class ClockCyclesToHoursConverter
extends AbstractClockCyclesConverter {
    private static final double MILLISECONDS_PER_HOUR = 3600000.0;
    private static final UnitConverterDefinition definition = new UnitConverterDefinitionImpl(UnitLabels.CLOCKCYCLES, UnitLabels.ELAPSED_TIME, UnitLabels.HOURS);

    public ClockCyclesToHoursConverter(TraceMetaData traceMetaData) {
        this(traceMetaData, true);
    }

    public ClockCyclesToHoursConverter(TraceMetaData traceMetaData, boolean bl) {
        super(traceMetaData, bl);
    }

    @Override
    protected double getConversionConstant() {
        return 3600000.0;
    }

    @Override
    public UnitConverterDefinition getDefinition() {
        return definition;
    }

    @Override
    public String unconvertedFormat(double d) {
        return Base60Formatter.format(d, true);
    }

    @Override
    public String unconvertedFormat(double d, int n) {
        return Base60Formatter.format(d, true);
    }

    @Override
    public double parseUnconverted(String string) {
        return Base60Formatter.parse(string);
    }
}

