/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.jit.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.jit.JITCompileDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.jit.JITCompileSummaryDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.jit.JITLabels;
import com.ibm.java.diagnostics.healthcenter.jit.JITMethodsScaleController;
import com.ibm.java.diagnostics.healthcenter.jit.JITMethodsScaleListener;
import java.util.ArrayList;
import java.util.logging.Logger;

public class JITCompileTimePostProcessor
implements PostProcessor,
JITMethodsScaleListener {
    private double accumulationInterval = 0.1;
    private static final Logger TRACE = LogFactory.getTrace(JITCompileTimePostProcessor.class);
    private static final int MAX_HOTNESS = 5;
    private final String className = this.getClass().getName();

    public JITCompileTimePostProcessor() {
        JITMethodsScaleController.getScaleController().addListener(this);
    }

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(this.className, "postprocess");
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(JVMLabels.JIT);
        if (dataBuilder2 == null) {
            return;
        }
        DataBuilder dataBuilder3 = dataBuilder2.getData(JITLabels.COMPILE_END);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = (TwoDimensionalDataBuilder)dataBuilder3;
        if (twoDimensionalDataBuilder == null || twoDimensionalDataBuilder.isEmpty()) {
            return;
        }
        TwoDimensionalDataImpl twoDimensionalDataImpl = (TwoDimensionalDataImpl)dataBuilder2.getData(JITLabels.COMPILE_END_SUMMARY);
        if (twoDimensionalDataImpl == null) {
            twoDimensionalDataImpl = new TwoDimensionalDataImpl(JITLabels.COMPILE_END_SUMMARY, twoDimensionalDataBuilder.getAxisPair());
            dataBuilder2.addData(twoDimensionalDataImpl);
        }
        DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
        ArrayList<JITCompileSummaryDataPointImpl> arrayList = new ArrayList<JITCompileSummaryDataPointImpl>();
        double d = twoDimensionalDataBuilder.getMinX().getX();
        double d2 = twoDimensionalDataBuilder.getMinX().getRawX();
        double d3 = twoDimensionalDataBuilder.getMaxX().getX();
        double d4 = twoDimensionalDataBuilder.getMaxX().getRawX();
        double d5 = d3 - d;
        int n = (int)Math.ceil(d5 / this.accumulationInterval) + 1;
        double[][] dArray = new double[n][6];
        long[][] lArray = new long[n][6];
        int n2 = (int)(d / this.accumulationInterval);
        DataPointBuilder[] dataPointBuilderArray2 = dataPointBuilderArray;
        int n3 = dataPointBuilderArray2.length;
        for (int i = 0; i < n3; ++i) {
            DataPointBuilder dataPointBuilder = dataPointBuilderArray2[i];
            JITCompileDataPointImpl jITCompileDataPointImpl = (JITCompileDataPointImpl)dataPointBuilder;
            int n4 = jITCompileDataPointImpl.getHotness();
            if (n4 < 0 || n4 > 5) continue;
            int n5 = (int)(jITCompileDataPointImpl.getX() / this.accumulationInterval) - n2;
            double[] dArray2 = dArray[n5];
            int n6 = n4;
            dArray2[n6] = dArray2[n6] + jITCompileDataPointImpl.getRawY();
            long[] lArray2 = lArray[n5];
            int n7 = n4;
            lArray2[n7] = lArray2[n7] + 1L;
        }
        for (int i = 0; i < n; ++i) {
            for (n3 = 0; n3 <= 5; ++n3) {
                arrayList.add(new JITCompileSummaryDataPointImpl(0, d2 + (d4 - d2) * (double)i / (double)n, dArray[i][n3], Long.toString(lArray[i][n3]) + " method(s) compiled", twoDimensionalDataImpl.getAxisPair(), n3));
            }
        }
        DataPointBuilder[] dataPointBuilderArray3 = new DataPointBuilder[arrayList.size()];
        dataPointBuilderArray3 = arrayList.toArray(dataPointBuilderArray3);
        twoDimensionalDataImpl.setDataPoints(dataPointBuilderArray3);
        TRACE.exiting(this.className, "postprocess");
    }

    @Override
    public void scaleChanged(double d) {
        this.accumulationInterval = d;
    }
}

