/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.io;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPoint;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemData;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataPointImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.FullEventDataPoint;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.io.IODataPointImpl;
import com.ibm.java.diagnostics.healthcenter.io.IOLabels;
import com.ibm.java.diagnostics.healthcenter.io.Messages;
import com.ibm.java.diagnostics.healthcenter.io.ThreadState;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceAxisUtil;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePoint;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePointHandler;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracedThread;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.FileInternalObject;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IOTracePointHandler
implements TracePointHandler {
    private static final Logger TRACE = LogFactory.getTrace(IOTracePointHandler.class);
    private static final String CLASSNAME = IOTracePointHandler.class.getName();
    private static final DataFactory factory = DataFactory.getFactory();
    private OutputProperties props;
    private AxisPair axisPair = null;
    private AxisPair stillOpenAxisPair = null;
    private XDataAxis xAxis = null;
    private final Map<TracedThread, ThreadState> threadStateMap = new HashMap<TracedThread, ThreadState>();
    private final Map<Long, DataPoint> fileNames = new HashMap<Long, DataPoint>();

    @Override
    public void handleTraceStart(DynamicSource dynamicSource, TraceMetaData traceMetaData, DataBuilder dataBuilder, OutputProperties outputProperties) {
        Object object;
        Object object2;
        TRACE.entering(CLASSNAME, "handleTraceStart");
        this.props = outputProperties;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(IOLabels.DATA_LABEL);
        if (dataBuilder2 instanceof SubsystemData && (object2 = (object = (SubsystemData)((Object)dataBuilder2)).getPerspectiveID()) == null) {
            dataBuilder.removeData(IOLabels.DATA_LABEL);
            if (TRACE.isLoggable(Level.FINE)) {
                TRACE.fine("Internal error: Postprocessed data was not cleared properly - deleting existing data.");
            }
        }
        if (this.xAxis != null) {
            TRACE.logp(Level.WARNING, CLASSNAME, "handleTraceStart", "xAxis already exists");
        }
        this.xAxis = AxisUtil.prepareXAxis(this.props);
        object = AxisUtil.prepareBinaryAxis(this.props);
        object2 = factory.createYAxis(UnitLabels.NUMBER, UnitLabels.AMOUNT);
        YDataAxis yDataAxis = object2.createDataAxis(this.props, UnitLabels.AMOUNT);
        if (this.axisPair != null) {
            TRACE.logp(Level.WARNING, CLASSNAME, "handleTraceStart", Messages.getString("IOTracePointHandler.axis.pair.already.exists"));
        }
        this.stillOpenAxisPair = factory.createAxisPair(this.xAxis, yDataAxis);
        this.axisPair = factory.createAxisPair(this.xAxis, (YDataAxis)object);
        TRACE.exiting(CLASSNAME, "handleTraceStart");
    }

    private SubsystemDataBuilder getIOSubsystemData(DataBuilder dataBuilder) {
        SubsystemDataBuilder subsystemDataBuilder;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(IOLabels.DATA_LABEL);
        if (dataBuilder2 instanceof SubsystemDataBuilder) {
            subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder2;
        } else {
            subsystemDataBuilder = this.createIOSubsystemData();
            dataBuilder.addData(subsystemDataBuilder);
        }
        return subsystemDataBuilder;
    }

    private SubsystemDataBuilder createIOSubsystemData() {
        SubsystemDataBuilder subsystemDataBuilder = factory.createSubsystemData(IOLabels.DATA_LABEL, "com.ibm.java.diagnostics.healthcenter.io.perspective.IOPerspective");
        return subsystemDataBuilder;
    }

    @Override
    public void handleTracePoint(DynamicSource dynamicSource, TraceMetaData traceMetaData, TracePoint tracePoint, DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASSNAME, "handleTracePoint");
        String string = tracePoint.getComponent();
        if ("IO".equals(string)) {
            switch (tracePoint.getID()) {
                case 103: {
                    this.handleOpenEntryTrace(tracePoint, this.getIOSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 105: {
                    this.handleOpenExitTrace(tracePoint, this.getIOSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 100: {
                    this.handleCloseEntryTrace(tracePoint, this.getIOSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
            }
        }
        if ("JAVA".equals(string)) {
            switch (tracePoint.getID()) {
                case 318: {
                    this.handleOpenEntryTrace(tracePoint, this.getIOSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 320: {
                    this.handleOpenExitTrace(tracePoint, this.getIOSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 315: {
                    this.handleCloseEntryTrace(tracePoint, this.getIOSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
            }
        }
        if ("j9scar".equals(string)) {
            switch (tracePoint.getID()) {
                case 136: {
                    this.handleOpenEntryTrace(tracePoint, this.getIOSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 140: {
                    this.handleOpenExitTrace(tracePoint, this.getIOSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 35: {
                    this.handleCloseEntryTrace(tracePoint, this.getIOSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
            }
        }
        TRACE.exiting(CLASSNAME, "handleTracePoint");
    }

    @Override
    public void handleMissingData(DynamicSource dynamicSource, TraceMetaData traceMetaData, TracedThread tracedThread, double d, int n, DataBuilder dataBuilder, OutputProperties outputProperties) {
        if (tracedThread == null) {
            this.threadStateMap.clear();
        } else {
            this.threadStateMap.remove(tracedThread);
        }
    }

    private void handleOpenEntryTrace(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        String string = (String)objectArray[0];
        TracedThread tracedThread = tracePoint.getThread();
        ThreadState threadState = new ThreadState();
        threadState.setFilename(string);
        this.threadStateMap.put(tracedThread, threadState);
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        FileInternalObject fileInternalObject = new FileInternalObject((long)d, string, 0);
        MarshallerImpl.getMarshaller().getFileEventHandler().addEvent(fileInternalObject);
    }

    private void handleOpenExitTrace(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        Long l;
        Object[] objectArray;
        ThreadState threadState = this.getThreadState(tracePoint.getThread());
        String string = null;
        if (threadState != null) {
            string = threadState.getFilename();
            this.removeThreadState(tracePoint.getThread());
        }
        if ((objectArray = tracePoint.getParameters()) == null) {
            return;
        }
        if (tracePoint.getID() == 140) {
            string = (String)objectArray[0];
            l = (Long)objectArray[1];
        } else {
            l = (Long)objectArray[0];
        }
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        String string2 = IOLabels.FILE_OPEN;
        DataBuilder dataBuilder2 = dataBuilder.getData(string2);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string2, this.axisPair);
            dataBuilder.addData(dataBuilder2);
        }
        FileInternalObject fileInternalObject = new FileInternalObject((long)d, string, 1);
        MarshallerImpl.getMarshaller().getFileEventHandler().addEvent(fileInternalObject);
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        IODataPointImpl iODataPointImpl = new IODataPointImpl(0, d, string, this.axisPair);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(iODataPointImpl);
        DataPoint dataPoint = this.fileNames.put(l, iODataPointImpl);
        if (dataPoint != null) {
            DataPoint dataPoint2 = this.createFileCloseDataPoint(d, dataBuilder, string);
            ((IODataPointImpl)dataPoint).setClosed(dataPoint2);
        }
        this.createStillOpenDataPoint(d, dataBuilder);
    }

    private void handleCloseEntryTrace(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        Long l = (Long)objectArray[0];
        DataPoint dataPoint = this.fileNames.get(l);
        if (dataPoint != null) {
            String string = dataPoint.getComment();
            this.fileNames.remove(l);
            DataPoint dataPoint2 = this.createFileCloseDataPoint(d, dataBuilder, string);
            ((IODataPointImpl)dataPoint).setClosed(dataPoint2);
        }
        this.createStillOpenDataPoint(d, dataBuilder);
    }

    private DataPoint createFileCloseDataPoint(double d, DataBuilder dataBuilder, String string) {
        String string2 = IOLabels.FILE_CLOSE;
        DataBuilder dataBuilder2 = dataBuilder.getData(string2);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string2, this.axisPair);
            dataBuilder.addData(dataBuilder2);
        }
        FullEventDataPoint fullEventDataPoint = new FullEventDataPoint(0, d, string, this.axisPair);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(fullEventDataPoint);
        return fullEventDataPoint;
    }

    private void createStillOpenDataPoint(double d, DataBuilder dataBuilder) {
        DataBuilder dataBuilder2 = dataBuilder.getData(IOLabels.STILL_OPEN);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(IOLabels.STILL_OPEN, this.stillOpenAxisPair);
            dataBuilder.addData(dataBuilder2);
        }
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(new DataPointImpl(0, d, this.fileNames.size(), this.stillOpenAxisPair));
    }

    private ThreadState getThreadState(TracedThread tracedThread) {
        ThreadState threadState = this.threadStateMap.get(tracedThread);
        if (threadState == null) {
            threadState = new ThreadState();
            this.threadStateMap.put(tracedThread, threadState);
        }
        return threadState;
    }

    private void removeThreadState(TracedThread tracedThread) {
        this.threadStateMap.remove(tracedThread);
    }
}

