/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.source;

import com.ibm.java.diagnostics.healthcenter.connection.ConnectionDataBuilder;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.StatusManager;
import com.ibm.java.diagnostics.healthcenter.sources.Source;
import com.ibm.java.diagnostics.healthcenter.sources.SourceListener;
import java.util.HashSet;
import java.util.Set;

public abstract class SourceImpl
implements Source {
    private final String name;
    protected final ConnectionDataBuilder connectionData;
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected final Set<SourceListener> sourceListeners;
    protected final Object listenerListLock = new Object();

    protected SourceImpl(String string, ConnectionDataBuilder connectionDataBuilder) {
        this.name = string;
        this.sourceListeners = new HashSet<SourceListener>();
        this.connectionData = connectionDataBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSourceListener(SourceListener sourceListener) {
        Object object = this.listenerListLock;
        synchronized (object) {
            this.tellNewSlicerAboutExistingData(sourceListener);
            this.sourceListeners.add(sourceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSourceListener(SourceListener sourceListener) {
        Object object = this.listenerListLock;
        synchronized (object) {
            this.sourceListeners.remove(sourceListener);
        }
    }

    protected abstract void tellNewSlicerAboutExistingData(SourceListener var1);

    @Override
    public String getName() {
        return this.name;
    }

    protected void tellConnectionAboutDataReceived(long l) {
        if (this.connectionData != null) {
            this.connectionData.dataReceived(l);
            StatusManager.setAmountReceived(this.connectionData.formatAmountOfDataReceived());
        }
    }

    protected void tellConnectionAboutError(Throwable throwable) {
        if (this.connectionData != null) {
            this.connectionData.errorOccurred(throwable);
        }
    }

    protected void tellConnectionAboutError(String string, String string2, Throwable throwable) {
        StatusManager.setSources(string);
        if (this.connectionData != null) {
            this.connectionData.errorOccurred(string, string2, throwable);
        }
    }

    @Override
    public final void shutdown() {
        StatusManager.setSources(null);
        StatusManager.setAmountReceived(null);
        this.internalShutdown();
    }

    protected void internalShutdown() {
    }

    @Override
    public void swapBackingFiles() {
    }

    @Override
    public void deleteBackingFile() {
    }

    @Override
    public long dataAvailable() {
        return -1L;
    }
}

