/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.NumberFormatter;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StringDataImpl;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionDataBuilder;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ConnectionDataImpl
extends StringDataImpl
implements ConnectionDataBuilder {
    private static final String bytes_TEMPLATE = Messages.getString("ConnectionDataImpl.bytes");
    private static final String KB_TEMPLATE = Messages.getString("ConnectionDataImpl.kb");
    private static final String MB_TEMPLATE = Messages.getString("ConnectionDataImpl.mb");
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static final int MAXIMUM_CONNECTIONDATA_NOTIFICATION_FREQUENCY = 100;
    private static final Logger TRACE = LogFactory.getTrace(ConnectionDataImpl.class);
    protected boolean isConnectionAlive;
    protected boolean hasToldAboutConnection = false;
    private long totalDataReceived = 0L;
    private final String connectionDescription;
    private Throwable exception;
    private long lastUpdated;
    private ArrayList<String> loggedErrors;

    protected ConnectionDataImpl(String string) {
        super(JVMLabels.CONNECTION);
        this.connectionDescription = string;
        this.lastUpdated = System.currentTimeMillis();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isConnectionAlive() {
        return this.isConnectionAlive;
    }

    @Override
    public boolean hasConnectionBeenNotified() {
        return this.hasToldAboutConnection;
    }

    @Override
    public void setConnectionNotified(boolean bl) {
        this.hasToldAboutConnection = bl;
    }

    @Override
    public void errorOccurred(String string, String string2, Throwable throwable) {
        if (this.loggedErrors == null) {
            this.loggedErrors = new ArrayList();
        }
        if (!this.loggedErrors.contains(string2)) {
            Level level = Level.WARNING;
            if (throwable instanceof RemoteException) {
                level = Level.FINE;
            }
            TRACE.log(level, string2);
            this.loggedErrors.add(string2);
            if (string != null && !string.equals(string2)) {
                TRACE.log(level, string);
            }
        }
        this.isConnectionAlive = false;
        this.exception = throwable;
        this.disableNotifications();
        this.setStatus(Status.PROBLEM);
        this.clearValue();
        this.addValue(string);
        this.enableNotifications();
        this.notifyListeners();
    }

    @Override
    public void destroyConnection() {
    }

    public Throwable getException() {
        return this.exception;
    }

    @Override
    public void errorOccurred(Throwable throwable) {
        String string = MessageFormat.format(Messages.getString("ConnectionDataImpl.problem.occurred"), throwable.toString());
        this.errorOccurred(string, string, throwable);
    }

    @Override
    public void dataReceived(long l) {
        this.totalDataReceived += l;
        this.lastUpdated = System.currentTimeMillis();
        this.notifyListeners();
    }

    @Override
    public long getAmountOfDataReceived() {
        return this.totalDataReceived;
    }

    @Override
    public Date getLastUpdated() {
        return new Date(this.lastUpdated);
    }

    @Override
    public String formatAmountOfDataReceived() {
        String string;
        double d = this.getAmountOfDataReceived();
        String string2 = bytes_TEMPLATE;
        if (d > 1.048576E7) {
            string = NumberFormatter.prettyString(d / 1048576.0, 0);
            string2 = MB_TEMPLATE;
        } else if (d > 2097152.0) {
            string = NumberFormatter.prettyString(d / 1048576.0, 1);
            string2 = MB_TEMPLATE;
        } else if (d > 2048.0) {
            string = NumberFormatter.prettyString(d / 1024.0, 0);
            string2 = KB_TEMPLATE;
        } else {
            string = String.valueOf((long)d);
        }
        return MessageFormat.format(string2, string);
    }

    @Override
    public String getDetails() {
        return this.connectionDescription;
    }

    @Override
    public boolean isCancelled() {
        return this.getValue() != null && this.getValue().contains("cancelled");
    }

    @Override
    public void clearValue() {
        super.clearValue();
        this.notifyListeners();
    }

    public abstract boolean spawnSources(Marshaller var1);

    @Override
    public boolean connect(Marshaller marshaller) {
        boolean bl = false;
        if (marshaller != null) {
            bl = this.spawnSources(marshaller);
            this.isPostProcessedData = false;
            ((DataBuilder)marshaller.getData(null)).addData(this);
        }
        return bl;
    }

    @Override
    protected int getMaximumNotificationFrequency() {
        return 100;
    }

    @Override
    public void outputMessage(String string, String string2, String ... stringArray) {
    }
}

