/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling;

import com.ibm.java.diagnostics.common.datamodel.exceptions.JavaDiagnosticsDataCorruptedException;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionProperties;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Logger;

public abstract class AbstractArgumentHandler {
    private static final String INVALID_ARG = Messages.getString("ArgumentHandler.invalid.arg");
    private static final String NOT_A_VALID_PORT_NUMBER = Messages.getString("ArgumentHandler.invalid.port");
    private static final String DASH = "-";
    private static final String SAVE_INTERVAL = "-saveInterval";
    private static final String P = "-p";
    private static final String PORT = "-port";
    private static final String HOST = "-hostname";
    private static final String HOSTNAME = "-host";
    private static final String O = "-o";
    private static final String D = "-d";
    private static final String F = "-f";
    private static final String FILE = "-file";
    private static final String H = "-h";
    private static final String HELP = "-help";
    private static final String HELP_QUESTION = "-?";
    protected static final String EMPTY_STRING = "";
    private static final String NO_LIVE = "-noautoconnect";
    private static final String AUTO_RETRY_CONNECTION = "-autoretryconnection";
    private boolean connectionWizardRequired = true;
    private String[] strings;
    protected boolean doMonitor = true;
    protected int saveInterval = 60;
    private static final String HELP_TEXT = Messages.getString("ArgumentHandler.help.text");
    private static final Logger TRACE = LogFactory.getTrace(AbstractArgumentHandler.class);

    public AbstractArgumentHandler(Object object) {
        if (object instanceof String[]) {
            this.strings = new String[((String[])object).length];
            System.arraycopy((String[])object, 0, this.strings, 0, ((String[])object).length);
        } else {
            this.strings = new String[0];
        }
    }

    public boolean initialise(Object object, ConnectionProperties connectionProperties) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.strings.length; ++i) {
            String string;
            String string2 = this.strings[i];
            if (HELP.equals(string2) || HELP_QUESTION.equals(string2)) {
                this.printHelp();
                return false;
            }
            if (PORT.equals(string2) || P.equals(string2)) {
                if (++i >= this.strings.length) {
                    this.printHelp();
                    return false;
                }
                string = this.strings[i];
                if (!this.isOption(string)) {
                    try {
                        int n = Integer.parseInt(string);
                        if (connectionProperties.setPort(n)) continue;
                        this.printHelp();
                        return false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.printHelp();
                        System.out.println(MessageFormat.format(NOT_A_VALID_PORT_NUMBER, string));
                        return false;
                    }
                }
                this.printHelp();
                return false;
            }
            if (H.equals(string2) || HOSTNAME.equals(string2) || HOST.equals(string2)) {
                if (++i >= this.strings.length) {
                    this.printHelp();
                    return false;
                }
                string = this.strings[i];
                if (!this.isOption(string)) {
                    connectionProperties.setHostname(string);
                    continue;
                }
                this.printHelp();
                return false;
            }
            if (NO_LIVE.equals(string2)) {
                connectionProperties.setScan(false);
                continue;
            }
            if (AUTO_RETRY_CONNECTION.equals(string2)) {
                this.connectionWizardRequired = false;
                connectionProperties.setScan(false);
                connectionProperties.setRetry(true);
                continue;
            }
            if (F.equals(string2) || FILE.equals(string2)) {
                this.connectionWizardRequired = false;
                string = null;
                while (i < this.strings.length - 1 && !this.isOption(string)) {
                    if (this.isOption(string = this.strings[++i])) continue;
                    bl = true;
                    File file = new File(string);
                    try {
                        this.addFile(file);
                    }
                    catch (JavaDiagnosticsDataCorruptedException javaDiagnosticsDataCorruptedException) {
                        TRACE.warning(MessageFormat.format(Messages.getString("ArgumentHandler.32"), file.getAbsolutePath(), javaDiagnosticsDataCorruptedException));
                    }
                }
                if (!bl) {
                    this.printHelp();
                    return false;
                }
                --i;
                continue;
            }
            if (D.equals(string2)) {
                this.connectionWizardRequired = false;
                if (++i < this.strings.length) {
                    string = this.strings[i];
                    if (this.isOption(string)) {
                        this.printHelp();
                        return false;
                    }
                    File file = new File(string);
                    this.addDirectory(file);
                    bl = true;
                    continue;
                }
                this.printHelp();
                return false;
            }
            if (O.equals(string2)) {
                if (++i >= this.strings.length) continue;
                string = this.strings[i];
                if (this.isOption(string)) {
                    this.printHelp();
                    return false;
                }
                this.setOutputFolder(string);
                continue;
            }
            if (SAVE_INTERVAL.equals(string2)) {
                if (++i >= this.strings.length) continue;
                string = this.strings[i];
                if (this.isOption(string)) {
                    this.printHelp();
                    return false;
                }
                this.setSaveInterval(string);
                continue;
            }
            bl2 = true;
            System.out.println(MessageFormat.format(INVALID_ARG, string2));
        }
        if (bl2) {
            this.printHelp();
            return false;
        }
        if (!bl) {
            this.handleNoSourceArguments(connectionProperties);
        }
        this.postInitialise(connectionProperties);
        return true;
    }

    private void setSaveInterval(String string) {
        this.saveInterval = Integer.parseInt(string);
    }

    protected void postInitialise(ConnectionProperties connectionProperties) {
    }

    protected abstract void setOutputFolder(String var1);

    protected void handleNoSourceArguments(ConnectionProperties connectionProperties) {
    }

    protected void addFile(File file) throws JavaDiagnosticsDataCorruptedException {
    }

    protected void addDirectory(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            try {
                if (file2.isDirectory()) continue;
                this.addFile(file2);
                continue;
            }
            catch (JavaDiagnosticsDataCorruptedException javaDiagnosticsDataCorruptedException) {
                TRACE.warning(MessageFormat.format(Messages.getString("ArgumentHandler.34"), file2.getAbsolutePath(), javaDiagnosticsDataCorruptedException));
            }
        }
    }

    private boolean isOption(String string) {
        return string != null && string.startsWith(DASH);
    }

    protected String getAdditionalHelp() {
        return EMPTY_STRING;
    }

    private void printHelp() {
        System.out.println(HELP_TEXT + this.getAdditionalHelp());
    }

    public boolean isConnectionWizardRequired() {
        return this.connectionWizardRequired;
    }

    public boolean doMonitor() {
        return this.doMonitor;
    }

    public int getSaveInterval() {
        return this.saveInterval;
    }
}

