/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.postprocessor.analysis;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPoint;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalData;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCAxes;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCLabels;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCReasons;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCType;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.Messages;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class DerivedGCDataPostProcessor
implements PostProcessor {
    public static final String HEAP_CATEGORY = Messages.getString("VGCParser.heap.category");
    public static final String PAUSE_CATEGORY = Messages.getString("VGCParser.pause.category");
    public static final DataFactory heapFactory = DataFactory.getFactory(HEAP_CATEGORY);
    public static final DataFactory pauseFactory = DataFactory.getFactory(PAUSE_CATEGORY);
    private static final String COMMA = ",";
    private static final String ADD_SUMMARY_DATA_METHOD = "addSummaryData";
    private static final String FRAGMENTATION_COMMENT = Messages.getString("DerivedVGCDataPostProcessor.free.comment");
    public static final String SCAVENGE = "scavenge";
    private static final int UNSET = -1;
    private static final Logger TRACE = LogFactory.getTrace(DerivedGCDataPostProcessor.class);
    private final String className = this.getClass().getName();
    private static final DataFactory factory = DataFactory.getFactory(JVMLabels.GARBAGE_COLLECTION);
    private IncrementalProgress lastAmountFreedProgress = new IncrementalProgress();
    private IncrementalProgress lastFragmentationProgress = new IncrementalProgress();
    private IncrementalProgress lastUnusableAmountFreedProgress = new IncrementalProgress();
    private IncrementalProgress lastUnusableMashedProgress = new IncrementalProgress();
    private IncrementalProgress lastUnusableSOAProgress = new IncrementalProgress();

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(this.className, "postprocess");
        this.addSummaryData(dataBuilder, outputProperties);
        TRACE.exiting(this.className, "postprocess");
    }

    private void addSummaryData(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(this.className, ADD_SUMMARY_DATA_METHOD);
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(JVMLabels.GARBAGE_COLLECTION);
        if (dataBuilder2 != null) {
            this.addNewTwoDimensionalData(dataBuilder2, outputProperties);
        }
        TRACE.exiting(this.className, ADD_SUMMARY_DATA_METHOD);
    }

    private void addNewTwoDimensionalData(DataBuilder dataBuilder, OutputProperties outputProperties) {
        this.calculateAmountTenured(dataBuilder);
        this.calculateAmountFreed(dataBuilder);
        this.calculateUnusableHeap(dataBuilder);
        this.calculateFragmentation(dataBuilder, outputProperties);
    }

    private void calculateAmountTenured(DataBuilder dataBuilder) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(dataBuilder, GCLabels.FREE_TENURED_HEAP_BEFORE_GC);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = this.getTwoDimensionalData(dataBuilder, GCLabels.FREE_TENURED_HEAP_AFTER_GC);
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty() && twoDimensionalDataBuilder2 != null && !twoDimensionalDataBuilder2.isEmpty()) {
            TwoDimensionalDataBuilder twoDimensionalDataBuilder3 = this.getTwoDimensionalDataBuilder(dataBuilder, GCLabels.AMOUNT_TENURED);
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
            for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                DataPointBuilder dataPointBuilder;
                DataPointBuilder dataPointBuilder2 = dataPointBuilderArray[i];
                int n = dataPointBuilder2.getSequenceUID();
                double d = this.getGCScope(dataBuilder, n);
                if (d != (double)GCType.NURSERY_INT || (dataPointBuilder = twoDimensionalDataBuilder2.getDataPoint(n)) == null) continue;
                double d2 = dataPointBuilder.getRawY();
                double d3 = dataPointBuilder2.getRawY();
                double d4 = d3 - d2;
                if (twoDimensionalDataBuilder3 == null) {
                    AxisPair axisPair = twoDimensionalDataBuilder2.getAxisPair();
                    twoDimensionalDataBuilder3 = factory.createTwoDimensionalData(GCLabels.AMOUNT_TENURED, axisPair);
                    dataBuilder.addData(twoDimensionalDataBuilder3);
                }
                twoDimensionalDataBuilder3.addDataPoint(n, dataPointBuilder.getRawX(), d4);
            }
        }
    }

    private void calculateAmountFreed(DataBuilder dataBuilder) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(dataBuilder, GCLabels.FREE_NURSERY_HEAP_BEFORE_GC);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = this.getTwoDimensionalData(dataBuilder, GCLabels.FREE_NURSERY_HEAP_AFTER_ALL_GCS);
        if (twoDimensionalDataBuilder2 == null) {
            twoDimensionalDataBuilder2 = this.getTwoDimensionalData(dataBuilder, GCLabels.FREE_NURSERY_HEAP_AFTER_GC);
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder3 = this.getTwoDimensionalData(dataBuilder, GCLabels.FREE_FLAT_HEAP_BEFORE_GC);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder4 = this.getTwoDimensionalData(dataBuilder, GCLabels.FREE_FLAT_HEAP_AFTER_ALL_GCS);
        if (twoDimensionalDataBuilder4 == null) {
            twoDimensionalDataBuilder4 = this.getTwoDimensionalData(dataBuilder, GCLabels.FREE_FLAT_HEAP_AFTER_GC);
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder5 = this.getTwoDimensionalData(dataBuilder, GCLabels.AMOUNT_TENURED);
        if (twoDimensionalDataBuilder == null || twoDimensionalDataBuilder.isEmpty()) {
            this.calculateAmountFreedForFlatHeap(dataBuilder, twoDimensionalDataBuilder3, twoDimensionalDataBuilder4);
        } else {
            this.calculateAmountFreedForGenerationalHeap(dataBuilder, twoDimensionalDataBuilder, twoDimensionalDataBuilder2, twoDimensionalDataBuilder5, twoDimensionalDataBuilder3, twoDimensionalDataBuilder4);
        }
    }

    private void calculateAmountFreedForGenerationalHeap(DataBuilder dataBuilder, TwoDimensionalData twoDimensionalData, TwoDimensionalDataBuilder twoDimensionalDataBuilder, TwoDimensionalDataBuilder twoDimensionalDataBuilder2, TwoDimensionalDataBuilder twoDimensionalDataBuilder3, TwoDimensionalDataBuilder twoDimensionalDataBuilder4) {
        if (twoDimensionalDataBuilder2 != null) {
            TwoDimensionalDataBuilder twoDimensionalDataBuilder5 = this.getTwoDimensionalDataBuilder(dataBuilder, GCLabels.AMOUNT_FREED);
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalData.getDataPoints();
            for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                double d;
                double d2;
                DataPointBuilder dataPointBuilder;
                DataPointBuilder dataPointBuilder2;
                DataPointBuilder dataPointBuilder3 = dataPointBuilderArray[i];
                int n = dataPointBuilder3.getSequenceUID();
                if (this.lastAmountFreedProgress.hasProcessed(dataPointBuilder3, twoDimensionalDataBuilder5) || (dataPointBuilder2 = twoDimensionalDataBuilder.getDataPoint(n)) == null) continue;
                String string = dataPointBuilder2.getComment();
                if (this.getGCScope(dataBuilder, n) == (double)GCType.NURSERY_INT) {
                    DataPointBuilder dataPointBuilder4;
                    dataPointBuilder = twoDimensionalDataBuilder3.getDataPoint(n);
                    if (dataPointBuilder == null || (dataPointBuilder4 = twoDimensionalDataBuilder4.getDataPoint(n)) == null) continue;
                    d2 = dataPointBuilder.getRawY();
                    d = dataPointBuilder4.getRawY();
                } else {
                    dataPointBuilder = twoDimensionalDataBuilder2.getDataPoint(n);
                    if (dataPointBuilder == null) continue;
                    d2 = dataPointBuilder3.getRawY();
                    d = dataPointBuilder2.getRawY() - dataPointBuilder.getRawY();
                }
                double d3 = d - d2;
                if (twoDimensionalDataBuilder5 == null) {
                    AxisPair axisPair = twoDimensionalDataBuilder4.getAxisPair();
                    twoDimensionalDataBuilder5 = factory.createTwoDimensionalData(GCLabels.AMOUNT_FREED, axisPair);
                    dataBuilder.addData(twoDimensionalDataBuilder5);
                }
                twoDimensionalDataBuilder5.addDataPoint(n, dataPointBuilder3.getRawX(), d3, string);
                this.lastAmountFreedProgress.setProcessed(dataPointBuilder3);
            }
        }
    }

    private void calculateAmountFreedForFlatHeap(DataBuilder dataBuilder, TwoDimensionalData twoDimensionalData, TwoDimensionalDataBuilder twoDimensionalDataBuilder) {
        block5: {
            block4: {
                if (twoDimensionalData == null || twoDimensionalDataBuilder == null) break block4;
                TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = this.getTwoDimensionalDataBuilder(dataBuilder, GCLabels.AMOUNT_FREED);
                DataPointBuilder[] dataPointBuilderArray = twoDimensionalData.getDataPoints();
                for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                    DataPointBuilder dataPointBuilder;
                    DataPointBuilder dataPointBuilder2 = dataPointBuilderArray[i];
                    int n = dataPointBuilder2.getSequenceUID();
                    if (this.lastAmountFreedProgress.hasProcessed(dataPointBuilder2, twoDimensionalDataBuilder2) || (dataPointBuilder = twoDimensionalDataBuilder.getDataPoint(n)) == null) continue;
                    double d = dataPointBuilder.getRawY();
                    double d2 = dataPointBuilder2.getRawY();
                    double d3 = d - d2;
                    if (twoDimensionalDataBuilder2 == null) {
                        AxisPair axisPair = twoDimensionalDataBuilder.getAxisPair();
                        twoDimensionalDataBuilder2 = factory.createTwoDimensionalData(GCLabels.AMOUNT_FREED, axisPair);
                        dataBuilder.addData(twoDimensionalDataBuilder2);
                    }
                    twoDimensionalDataBuilder2.addDataPoint(n, dataPointBuilder.getRawX(), d3);
                    this.lastAmountFreedProgress.setProcessed(dataPointBuilder2);
                }
                break block5;
            }
            TwoDimensionalDataBuilder twoDimensionalDataBuilder3 = this.getTwoDimensionalData(dataBuilder, GCLabels.LIVE_FLAT_HEAP_BEFORE_GC);
            TwoDimensionalDataBuilder twoDimensionalDataBuilder4 = this.getTwoDimensionalData(dataBuilder, GCLabels.LIVE_FLAT_HEAP_AFTER_GC);
            if (twoDimensionalDataBuilder3 == null) break block5;
            TwoDimensionalDataBuilder twoDimensionalDataBuilder5 = this.getTwoDimensionalDataBuilder(dataBuilder, GCLabels.AMOUNT_FREED);
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder3.getDataPoints();
            for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                DataPointBuilder dataPointBuilder;
                DataPointBuilder dataPointBuilder3 = dataPointBuilderArray[i];
                int n = dataPointBuilder3.getSequenceUID();
                if (this.lastAmountFreedProgress.hasProcessed(dataPointBuilder3, twoDimensionalDataBuilder5) || (dataPointBuilder = twoDimensionalDataBuilder4.getDataPoint(n)) == null) continue;
                String string = dataPointBuilder.getComment();
                double d = dataPointBuilder3.getRawY();
                double d4 = dataPointBuilder.getRawY();
                double d5 = d - d4;
                if (twoDimensionalDataBuilder5 == null) {
                    AxisPair axisPair = twoDimensionalDataBuilder4.getAxisPair();
                    twoDimensionalDataBuilder5 = factory.createTwoDimensionalData(GCLabels.AMOUNT_FREED, axisPair);
                    dataBuilder.addData(twoDimensionalDataBuilder5);
                }
                twoDimensionalDataBuilder5.addDataPoint(n, dataPointBuilder3.getRawX(), d5, string);
                this.lastAmountFreedProgress.setProcessed(dataPointBuilder3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateFragmentation(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(dataBuilder, GCLabels.AMOUNT_FREED);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = this.getTwoDimensionalData(dataBuilder, GCLabels.UNUSED_HEAP);
        if (twoDimensionalDataBuilder2 == null) {
            twoDimensionalDataBuilder2 = this.getTwoDimensionalData(dataBuilder, GCLabels.UNUSED_TENURED_HEAP);
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder3 = this.getTwoDimensionalData(dataBuilder, GCLabels.MINIMUM_REQUESTED_BYTES);
        if (twoDimensionalDataBuilder2 != null && twoDimensionalDataBuilder3 != null && twoDimensionalDataBuilder != null) {
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder2.getDataPoints();
            XDataAxis xDataAxis = twoDimensionalDataBuilder.getXAxis();
            TwoDimensionalDataBuilder twoDimensionalDataBuilder4 = this.getTwoDimensionalDataBuilder(dataBuilder, GCLabels.FRAGMENTATION);
            String string = twoDimensionalDataBuilder3.getYAxis().getUnits();
            try {
                String string2 = twoDimensionalDataBuilder2.getYAxis().getBaseUnitName();
                twoDimensionalDataBuilder3.getYAxis().getAxis().setUnits(string2);
                for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                    DataPointBuilder dataPointBuilder = dataPointBuilderArray[i];
                    int n = dataPointBuilder.getSequenceUID();
                    if (this.lastFragmentationProgress.hasProcessed(dataPointBuilder, twoDimensionalDataBuilder4)) continue;
                    double d = this.getGCScope(dataBuilder, n);
                    double d2 = this.getGCReason(dataBuilder, n);
                    if (d != (double)GCType.NURSERY_INT && d2 != (double)GCReasons.SYS_INT && d2 != (double)GCReasons.CON_INT) {
                        DataPointBuilder dataPointBuilder2 = twoDimensionalDataBuilder3.getDataPoint(n);
                        if (dataPointBuilder2 == null) continue;
                        double d3 = dataPointBuilder2.getY();
                        double d4 = dataPointBuilder.getRawX();
                        double d5 = dataPointBuilder.getRawY() / d3;
                        String string3 = dataPointBuilder.getComment() + dataPointBuilder.getRawY() + COMMA + d3;
                        if (twoDimensionalDataBuilder4 == null) {
                            AxisPair axisPair = factory.createAxisPair(xDataAxis, GCAxes.NUMBER_AXIS.createDataAxis(outputProperties, UnitLabels.HASH_SIGN));
                            twoDimensionalDataBuilder4 = heapFactory.createTwoDimensionalData(GCLabels.FRAGMENTATION, axisPair);
                            dataBuilder.addData(twoDimensionalDataBuilder4);
                        }
                        twoDimensionalDataBuilder4.addDataPoint(n, d4, d5, string3);
                    }
                    this.lastFragmentationProgress.setProcessed(dataPointBuilder);
                }
            }
            finally {
                twoDimensionalDataBuilder3.getYAxis().getAxis().setUnits(string);
            }
        }
    }

    private void calculateUnusableHeap(DataBuilder dataBuilder) {
        boolean bl;
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = null;
        TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = this.getTwoDimensionalData(dataBuilder, GCLabels.FREE_TENURED_HEAP_BEFORE_GC);
        boolean bl2 = true;
        if (twoDimensionalDataBuilder2 == null || twoDimensionalDataBuilder2.isEmpty()) {
            twoDimensionalDataBuilder2 = this.getTwoDimensionalData(dataBuilder, GCLabels.FREE_SOA_BEFORE_GC);
            if (twoDimensionalDataBuilder2 == null) {
                twoDimensionalDataBuilder2 = this.getTwoDimensionalData(dataBuilder, GCLabels.FREE_FLAT_HEAP_BEFORE_GC);
            }
            bl2 = false;
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder3 = this.getTwoDimensionalData(dataBuilder, GCLabels.FLAT_HEAP_SIZE);
        int n = 0;
        if (twoDimensionalDataBuilder3 != null) {
            n = twoDimensionalDataBuilder3.getDataPoints().length;
        }
        boolean bl3 = bl = twoDimensionalDataBuilder2 != null && (double)twoDimensionalDataBuilder2.getDataPoints().length > (double)n * 0.9;
        twoDimensionalDataBuilder = bl ? this.doUnusableHeapFromSOA(dataBuilder, twoDimensionalDataBuilder2, bl2) : (twoDimensionalDataBuilder2 != null && !twoDimensionalDataBuilder2.isEmpty() ? this.mashTogetherSOAAndFlatHeapForUnusableHeap(dataBuilder, bl2) : this.doUnusableHeapBasedOnAmountFreed(dataBuilder, twoDimensionalDataBuilder2, bl2));
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty()) {
            dataBuilder.addData(twoDimensionalDataBuilder);
        }
    }

    private TwoDimensionalDataBuilder doUnusableHeapBasedOnAmountFreed(Data data, TwoDimensionalData twoDimensionalData, boolean bl) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = null;
        TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = this.getTwoDimensionalData(data, GCLabels.AMOUNT_FREED);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder3 = this.getTwoDimensionalData(data, GCLabels.FREE_TENURED_HEAP_AFTER_GC);
        if (twoDimensionalDataBuilder3 == null) {
            twoDimensionalDataBuilder3 = this.getTwoDimensionalData(data, GCLabels.FREE_FLAT_HEAP_AFTER_GC);
            bl = false;
        }
        if (!bl && twoDimensionalDataBuilder2 != null && twoDimensionalDataBuilder3 != null) {
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder3.getDataPoints();
            String string = bl ? GCLabels.UNUSED_TENURED_HEAP : GCLabels.UNUSED_HEAP;
            twoDimensionalDataBuilder = this.getTwoDimensionalDataBuilder(data, string);
            for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                DataPointBuilder dataPointBuilder = dataPointBuilderArray[i];
                int n = dataPointBuilder.getSequenceUID();
                if (this.lastUnusableAmountFreedProgress.hasProcessed(dataPointBuilder, twoDimensionalDataBuilder)) continue;
                double d = this.getGCScope(data, n);
                double d2 = this.getGCReason(data, n);
                if (d != (double)GCType.NURSERY_INT && d2 != (double)GCReasons.SYS_INT && d2 != (double)GCReasons.CON_INT) {
                    DataPointBuilder dataPointBuilder2 = twoDimensionalDataBuilder2.getDataPoint(n);
                    if (dataPointBuilder2 == null) continue;
                    double d3 = dataPointBuilder2.getRawY();
                    double d4 = dataPointBuilder.getRawY();
                    double d5 = dataPointBuilder.getRawX();
                    String string2 = MessageFormat.format(FRAGMENTATION_COMMENT, new Double(d3), new Double(d4));
                    double d6 = d4 - d3;
                    if (twoDimensionalDataBuilder == null) {
                        AxisPair axisPair = twoDimensionalDataBuilder2.getAxisPair();
                        twoDimensionalDataBuilder = heapFactory.createTwoDimensionalData(string, axisPair);
                    }
                    twoDimensionalDataBuilder.addDataPoint(n, d5, d6, string2);
                }
                this.lastUnusableAmountFreedProgress.setProcessed(dataPointBuilder);
            }
        }
        return twoDimensionalDataBuilder;
    }

    private TwoDimensionalDataBuilder mashTogetherSOAAndFlatHeapForUnusableHeap(Data data, boolean bl) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = null;
        TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = this.getTwoDimensionalData(data, GCLabels.FREE_SOA_BEFORE_GC);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder3 = this.getTwoDimensionalData(data, GCLabels.FREE_FLAT_HEAP_BEFORE_GC);
        if (!bl && twoDimensionalDataBuilder2 != null && twoDimensionalDataBuilder3 != null) {
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder3.getDataPoints();
            String string = GCLabels.UNUSED_HEAP;
            twoDimensionalDataBuilder = this.getTwoDimensionalDataBuilder(data, string);
            for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                DataPointBuilder dataPointBuilder = dataPointBuilderArray[i];
                int n = dataPointBuilder.getSequenceUID();
                if (this.lastUnusableMashedProgress.hasProcessed(dataPointBuilder, twoDimensionalDataBuilder)) continue;
                double d = this.getGCScope(data, n);
                double d2 = this.getGCReason(data, n);
                if (d != (double)GCType.NURSERY_INT && d2 != (double)GCReasons.SYS_INT && d2 != (double)GCReasons.CON_INT) {
                    DataPointBuilder dataPointBuilder2 = twoDimensionalDataBuilder2.getDataPoint(n);
                    double d3 = dataPointBuilder2 != null ? dataPointBuilder2.getRawY() : dataPointBuilder.getRawY();
                    double d4 = dataPointBuilder.getRawX();
                    if (twoDimensionalDataBuilder == null) {
                        AxisPair axisPair = twoDimensionalDataBuilder3.getAxisPair();
                        twoDimensionalDataBuilder = heapFactory.createTwoDimensionalData(string, axisPair);
                    }
                    twoDimensionalDataBuilder.addDataPoint(n, d4, d3);
                }
                this.lastUnusableMashedProgress.setProcessed(dataPointBuilder);
            }
        }
        return twoDimensionalDataBuilder;
    }

    private TwoDimensionalDataBuilder doUnusableHeapFromSOA(Data data, TwoDimensionalData twoDimensionalData, boolean bl) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = null;
        if (!bl) {
            TwoDimensionalData twoDimensionalData2 = twoDimensionalData;
            if (!bl && twoDimensionalData2 != null) {
                DataPointBuilder[] dataPointBuilderArray = twoDimensionalData2.getDataPoints();
                String string = GCLabels.UNUSED_HEAP;
                twoDimensionalDataBuilder = this.getTwoDimensionalDataBuilder(data, string);
                for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                    DataPointBuilder dataPointBuilder = dataPointBuilderArray[i];
                    int n = dataPointBuilder.getSequenceUID();
                    if (this.lastUnusableSOAProgress.hasProcessed(dataPointBuilder, twoDimensionalDataBuilder)) continue;
                    double d = this.getGCReason(data, n);
                    double d2 = this.getGCScope(data, n);
                    if (d2 != (double)GCType.NURSERY_INT && d != (double)GCReasons.SYS_INT && d != (double)GCReasons.CON_INT) {
                        if (twoDimensionalDataBuilder == null) {
                            AxisPair axisPair = twoDimensionalData2.getAxisPair();
                            twoDimensionalDataBuilder = heapFactory.createTwoDimensionalData(string, axisPair);
                        }
                        twoDimensionalDataBuilder.addDataPoint(n, dataPointBuilder.getRawX(), dataPointBuilder.getRawY());
                    }
                    this.lastUnusableSOAProgress.setProcessed(dataPointBuilder);
                }
            }
        }
        return twoDimensionalDataBuilder;
    }

    private TwoDimensionalDataBuilder getTwoDimensionalData(Data data, String string) {
        Data data2 = data.getData(string);
        if (data2 instanceof TwoDimensionalDataBuilder) {
            return (TwoDimensionalDataBuilder)data2;
        }
        return null;
    }

    private TwoDimensionalDataBuilder getTwoDimensionalDataBuilder(Data data, String string) {
        Data data2 = data.getData(string);
        if (data2 instanceof TwoDimensionalDataBuilder) {
            return (TwoDimensionalDataBuilder)data2;
        }
        return null;
    }

    private double getGCReason(Data data, int n) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalDataBuilder(data, GCLabels.GC_REASON_RECORD);
        if (twoDimensionalDataBuilder != null) {
            DataPointBuilder dataPointBuilder = twoDimensionalDataBuilder.getDataPoint(n);
            if (dataPointBuilder != null) {
                return dataPointBuilder.getY();
            }
            return -1.0;
        }
        return -1.0;
    }

    private double getGCScope(Data data, int n) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalDataBuilder(data, GCLabels.GC_TYPE_RECORD);
        if (twoDimensionalDataBuilder != null) {
            DataPointBuilder dataPointBuilder = twoDimensionalDataBuilder.getDataPoint(n);
            if (dataPointBuilder != null) {
                return dataPointBuilder.getRawY();
            }
            return -1.0;
        }
        return -1.0;
    }

    private static class IncrementalProgress {
        private int lastProcessedSequenceUID = -1;

        private IncrementalProgress() {
        }

        public boolean hasProcessed(DataPointBuilder dataPointBuilder, TwoDimensionalData twoDimensionalData) {
            DataPoint dataPoint;
            if (twoDimensionalData == null) {
                return false;
            }
            int n = dataPointBuilder.getSequenceUID();
            return this.lastProcessedSequenceUID != -1 && n <= this.lastProcessedSequenceUID && (dataPoint = twoDimensionalData.getDataPoint(n)) != null;
        }

        public void setProcessed(DataPointBuilder dataPointBuilder) {
            int n;
            this.lastProcessedSequenceUID = n = dataPointBuilder.getSequenceUID();
        }
    }
}

