/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.parser.converters;

import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.UnitConverterDefinition;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.NumberFormatter;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.UnitConverterDefinitionImpl;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCAxes;
import com.ibm.java.diagnostics.healthcenter.gc.parser.converters.TwoDimensionalDataConverter;

public class HeapPercentConverter
extends TwoDimensionalDataConverter {
    private final UnitConverterDefinition definition;

    public HeapPercentConverter(String string, TwoDimensionalDataBuilder twoDimensionalDataBuilder) {
        super(twoDimensionalDataBuilder);
        this.definition = new UnitConverterDefinitionImpl(GCAxes.BYTES, string, GCAxes.PERCENT_SIGN);
    }

    @Override
    public double convert(double d, int n) {
        DataPointBuilder dataPointBuilder = this.convertToData.getDataPointFromUncroppedData(n);
        int n2 = dataPointBuilder == null ? this.getIndexOfSequenceUID(n) : n;
        if ((double)n2 != this.UNSET) {
            double d2 = this.convertToData.getDataPointFromUncroppedData(n2).getRawY();
            double d3 = d / d2 * 100.0;
            return d3;
        }
        return this.UNSET;
    }

    private int getIndexOfSequenceUID(int n) {
        DataPointBuilder[] dataPointBuilderArray = this.binaryChop(this.convertToData.getDataPoints(), n);
        if (dataPointBuilderArray.length < 1) {
            return -1;
        }
        int n2 = dataPointBuilderArray[0].getSequenceUID();
        return n2;
    }

    @Override
    public String unconvertedFormat(double d) {
        return String.valueOf((int)d);
    }

    @Override
    public String unconvertedFormat(double d, int n) {
        return NumberFormatter.prettyString(d, n);
    }

    @Override
    public UnitConverterDefinition getDefinition() {
        return this.definition;
    }
}

