/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    private static String runtimeVersion = System.getProperty("java.runtime.version");
    private static String specVersion = System.getProperty("java.specification.version");
    private static String vmVersion = System.getProperty("java.vm.version");
    private static String fullVersion = System.getProperty("java.fullversion");
    private static String osName = System.getProperty("os.name");
    private static final String REALTIME_IDENTIFIER = "real-time";
    private static final String SOFT_REALTIME_IDENTIFER = "srt";
    private static final String ZOS = "z/OS";
    private static final int JAVA6_SR4 = 20090330;
    private static final int JAVA5_SR10 = 20090601;
    private static final int JAVA626_SR1 = 20110921;
    private static final Pattern VM_DATE_PATTERN = Pattern.compile("(.*)(\\d{8})(.*)");
    private static final String BLANK = "";

    public static void overrideJavaVersion(String string, String string2) {
        specVersion = string;
        runtimeVersion = string2;
    }

    public static boolean isIBM() {
        return System.getProperty("java.vm.vendor").contains("IBM");
    }

    public static boolean isRealTimeVM() {
        if (!Util.isIBM()) {
            return false;
        }
        if (System.getProperty("com.ibm.jvm.realtime") != null) {
            return System.getProperty("com.ibm.jvm.realtime").contains("hard");
        }
        return false;
    }

    public static boolean isHardRealTimeVM() {
        if (!Util.isIBM()) {
            return false;
        }
        if (fullVersion.contains(REALTIME_IDENTIFIER) && !fullVersion.contains(SOFT_REALTIME_IDENTIFER)) {
            return true;
        }
        if (System.getProperty("com.ibm.jvm.realtime") != null) {
            return System.getProperty("com.ibm.jvm.realtime").contains("hard");
        }
        return false;
    }

    public static boolean vmHasLOATracePoints() {
        if (Util.isIBM()) {
            String string = Util.getVMLevel(fullVersion);
            int n = Util.convertStringDateToInt(string);
            if (Util.getJavaLevel() > 6) {
                return true;
            }
            if (Util.getJavaLevel() == 6 && n > 20090330) {
                return true;
            }
            if (Util.getJavaLevel() == 5 && n >= 20090601) {
                return true;
            }
        }
        return false;
    }

    public static boolean vmHasJ9MethodLookup() {
        if (Util.isIBM()) {
            String string = Util.getVMLevel(fullVersion);
            int n = Util.convertStringDateToInt(string);
            return Util.is26VMOrLater() && n >= 20110921;
        }
        return false;
    }

    public static boolean j9DmpTrcAvailable() {
        if (Util.isIBM()) {
            String string = Util.getVMLevel(fullVersion);
            int n = Util.convertStringDateToInt(string);
            if (Util.is26VMOrLater()) {
                return n >= 20110921 || Util.getJavaLevel() == 7;
            }
            return false;
        }
        return false;
    }

    public static boolean canGetThreads() {
        if (fullVersion != null) {
            String string = Util.getVMLevel(fullVersion);
            int n = Util.convertStringDateToInt(string);
            if (Util.is26VMOrLater()) {
                return n >= 20110921;
            }
            return true;
        }
        return false;
    }

    public static boolean is26VMOrLater() {
        return Util.isIBM() && Util.getVMVersion() >= 2.6f;
    }

    public static boolean is27VMOrLater() {
        return Util.isIBM() && Util.getVMVersion() >= 2.7f;
    }

    private static int convertStringDateToInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private static String getVMLevel(String string) {
        String string2 = BLANK;
        Matcher matcher = VM_DATE_PATTERN.matcher(string);
        if (matcher.find() && matcher.groupCount() >= 3) {
            string2 = matcher.group(2);
        }
        return string2;
    }

    public static boolean isOkConsideringRealtime(int n) {
        boolean bl = Util.isRealTimeVM() ? (Util.is26VMOrLater() ? n == 285 || n == 286 || n == 467 || n == 468 || n == 474 || n == 475 || n >= 54 && n <= 57 : n >= 279 && n <= 282) : n != 285 && n != 286 && n != 467 && n != 468 && (n < 279 || n > 282);
        return bl;
    }

    public static int getJavaLevel() {
        int n = -1;
        String[] stringArray = specVersion.split("\\.");
        if (stringArray.length >= 2) {
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static int getServiceRefreshNumber() {
        int n = -1;
        Pattern pattern = Pattern.compile("(.*\\([SE][RA])(\\d+)(.*)");
        Matcher matcher = pattern.matcher(runtimeVersion);
        if (matcher.matches() && matcher.groupCount() > 2) {
            try {
                n = Integer.parseInt(matcher.group(2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    public static int getFixpackNumber() {
        int n = -1;
        Pattern pattern = Pattern.compile("(.*\\([SE][RA])(\\d+) [Ff][Pp](\\d+)(.*)");
        Matcher matcher = pattern.matcher(runtimeVersion);
        if (matcher.matches() && matcher.groupCount() > 3) {
            try {
                n = Integer.parseInt(matcher.group(3));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    public static String getVMVersionString() {
        return vmVersion;
    }

    public static float getVMVersion() {
        float f = -1.0f;
        if (vmVersion != null) {
            try {
                f = Float.parseFloat(vmVersion);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return f;
    }

    public static String findWriteableDirectory(String string) {
        if (Util.canWrite(string)) {
            return string;
        }
        String string2 = System.getProperty("user.dir");
        if (Util.canWrite(string2)) {
            return string2;
        }
        string2 = BLANK;
        if (Util.canWrite(string2)) {
            return string2;
        }
        string2 = System.getProperty("java.io.tmpdir");
        if (Util.canWrite(string2)) {
            return string2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(String string) {
        if (string != null) {
            File file = new File(string);
            if (!file.isDirectory()) {
                return false;
            }
            int n = 0;
            File file2 = new File(file, "hctest_" + n);
            while (file2.exists()) {
                file2 = new File(file, "hctest_" + ++n);
            }
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(file2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    boolean bl = false;
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (file2.exists()) {
                            try {
                                file2.delete();
                            }
                            catch (SecurityException securityException) {
                                // empty catch block
                            }
                        }
                    }
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                    if (file2.exists()) {
                        try {
                            file2.delete();
                        }
                        catch (SecurityException securityException) {}
                    }
                }
            }
        }
        return false;
    }

    public static boolean isZOS() {
        return osName.contains(ZOS);
    }
}

