/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.data;

import com.ibm.java.diagnostics.common.datamodel.data.ControllableDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.ControlledData;
import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.Messages;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StringDataImpl;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

public class SubsystemDataImpl
extends StringDataImpl
implements SubsystemDataBuilder {
    private static final Logger TRACE = LogFactory.getTrace(SubsystemDataImpl.class);
    private String perspectiveID;
    private final String configurationId;

    public SubsystemDataImpl(String string, String string2) {
        super(string);
        this.configurationId = string + CONFIGURATION;
        this.perspectiveID = string2;
    }

    @Override
    public String getPerspectiveID() {
        return this.perspectiveID;
    }

    @Override
    public void addControllableData(ControllableDataBuilder controllableDataBuilder) {
        assert (controllableDataBuilder != null);
        DataBuilder dataBuilder = this.getConfigurationParent();
        if (dataBuilder == null) {
            dataBuilder = new StringDataImpl(this.configurationId);
            DataImpl dataImpl = this.getParent();
            if (dataImpl != null) {
                DataBuilder dataBuilder2 = dataImpl.getTopLevelData(CONFIGURATION);
                if (dataBuilder2 == null) {
                    dataBuilder2 = new StringDataImpl(CONFIGURATION);
                    dataImpl.addData(dataBuilder2);
                }
                dataBuilder2.addData(dataBuilder);
            } else {
                TRACE.warning(Messages.getString("SubsystemDataImpl.non.existent.parent"));
            }
        }
        dataBuilder.addData(controllableDataBuilder);
    }

    @Override
    public Collection<ControlledData> getControllableData() {
        ArrayList<ControlledData> arrayList = new ArrayList<ControlledData>();
        DataBuilder dataBuilder = this.getConfigurationParent();
        if (dataBuilder != null) {
            Data[] dataArray;
            for (Data data : dataArray = dataBuilder.getChildren()) {
                if (!(data instanceof ControlledData)) continue;
                arrayList.add((ControlledData)data);
            }
        }
        return arrayList;
    }

    private DataBuilder getConfigurationParent() {
        DataBuilder dataBuilder;
        DataBuilder dataBuilder2 = null;
        DataImpl dataImpl = this.getParent();
        if (dataImpl != null && (dataBuilder = dataImpl.getTopLevelData(CONFIGURATION)) != null) {
            dataBuilder2 = dataBuilder.getData(this.configurationId);
        }
        return dataBuilder2;
    }

    @Override
    public Status getStatus() {
        DataBuilder[] dataBuilderArray = this.getChildren();
        Status status = Status.UNKNOWN;
        for (DataBuilder dataBuilder : dataBuilderArray) {
            if (dataBuilder.getStatus().compareTo(status) != 1) continue;
            status = dataBuilder.getStatus();
        }
        return status;
    }
}

