/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.converters;

import com.ibm.java.diagnostics.common.datamodel.data.axes.LinearUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AbstractUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.NumberFormatter;

public abstract class SimpleUnitConverter
extends AbstractUnitConverter
implements LinearUnitConverter {
    protected double normalisationOffset = Double.MAX_VALUE;
    protected final boolean normalised;
    protected double multiplier = 1.0;

    protected SimpleUnitConverter(boolean bl) {
        this.normalised = bl;
    }

    @Override
    public double convert(double d, int n) {
        return this.convert(d);
    }

    @Override
    public double convert(double d) {
        if (this.normalised) {
            return (d - this.normalisationOffset) * this.multiplier;
        }
        return d * this.multiplier;
    }

    @Override
    public double reverseConvert(double d) {
        if (this.normalised) {
            return d / this.multiplier + this.normalisationOffset;
        }
        return d / this.multiplier;
    }

    @Override
    public String unconvertedFormat(double d) {
        return NumberFormatter.prettyString(d);
    }

    @Override
    public String unconvertedFormat(double d, int n) {
        return NumberFormatter.prettyString(d, n);
    }

    @Override
    public void setOffset(double d) {
        this.normalisationOffset = d;
    }
}

