/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform.dom;

import javax.xml.transform.Result;
import org.w3c.dom.Node;

public class DOMResult
implements Result {
    public static final String FEATURE = "http://javax.xml.transform.dom.DOMResult/feature";
    private Node node;
    private Node nextSibling;
    private String systemId;

    public DOMResult() {
    }

    public DOMResult(Node node) {
        this.setNode(node);
        this.setNextSibling(null);
    }

    public DOMResult(Node node, Node node2) {
        this.setNode(node);
        this.setNextSibling(node2);
    }

    public DOMResult(Node node, String string) {
        this.setNode(node);
        this.setNextSibling(null);
        this.setSystemId(string);
    }

    public DOMResult(Node node, Node node2, String string) {
        this.setNode(node);
        this.setNextSibling(node2);
        this.setSystemId(string);
    }

    public void setNode(Node node) {
        if (this.nextSibling != null) {
            if (node == null) {
                throw new IllegalStateException("nextSibling cannot be contained in a null node.");
            }
            if ((node.compareDocumentPosition(this.nextSibling) & 0x10) == 0) {
                throw new IllegalStateException("The nextSibling is not contained by the node.");
            }
        }
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNextSibling(Node node) {
        this.nextSibling = node;
        if (node != null) {
            if (this.node == null) {
                throw new IllegalStateException("nextSibling cannot be contained in a null node.");
            }
            if ((this.node.compareDocumentPosition(node) & 0x10) == 0) {
                throw new IllegalArgumentException("The nextSibling is not contained by the node.");
            }
        }
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public void setSystemId(String string) {
        this.systemId = string;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }
}

