/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingDependencyInfo;
import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.TailRecursiveOptimizer;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.optimizers.DeadLetEliminatorOptimizer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class DeadParameterEliminatorOptimizer
extends TailRecursiveOptimizer {
    protected Module m_prog;
    protected HashMap m_originalParameterSets;
    protected static final Logger s_logger = Logger.getInstance(DeadParameterEliminatorOptimizer.class);
    boolean m_changed;
    ArrayList m_changedFunctions = new ArrayList();

    protected DeadParameterEliminatorOptimizer(Module module, HashMap hashMap) {
        this.m_prog = module;
        this.m_originalParameterSets = hashMap;
    }

    @Override
    protected Instruction optimizeStep2(Instruction instruction) {
        if (instruction instanceof FunctionCallInstruction) {
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
            Function function = this.m_prog.getFunction(functionCallInstruction.getFunction());
            Binding[] bindingArray = (Binding[])this.m_originalParameterSets.get(function);
            Function function2 = function.lookupDerivative(DeadParameterEliminatorOptimizer.class);
            if (function2 != null && functionCallInstruction.getChildInstructionCount() != function2.m_parameters.length) {
                ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
                int n = bindingArray.length;
                int n2 = 0;
                for (int i = 0; i < n && n2 < function2.m_parameters.length; ++i) {
                    if (function2.m_parameters[n2] != bindingArray[i]) continue;
                    arrayList.add(functionCallInstruction.getChildInstruction(i));
                    ++n2;
                }
                functionCallInstruction.m_parameters = new Instruction[arrayList.size()];
                arrayList.toArray(functionCallInstruction.m_parameters);
                functionCallInstruction.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
                this.m_changed = true;
                return instruction;
            }
        }
        return instruction;
    }

    @Override
    public void optimizeFunction(Function function) {
        this.m_changed = false;
        super.optimizeFunction(function);
        if (this.m_changed) {
            function.setBody(DeadLetEliminatorOptimizer.eliminateDeadLets(function.getBody(), function));
            this.m_changedFunctions.add(function);
        }
    }

    public static void eliminateDeadParameters(Module module) {
        s_logger.debug("starting dead param elimination");
        BuildFunctionCallGraph buildFunctionCallGraph = new BuildFunctionCallGraph();
        module.optimize(buildFunctionCallGraph);
        HashMap hashMap = buildFunctionCallGraph.m_callers;
        HashMap hashMap2 = new HashMap();
        final HashMap<Object, Binding[]> hashMap3 = new HashMap<Object, Binding[]>();
        ArrayList arrayList = new ArrayList(module.getFunctions());
        while (true) {
            AbstractCollection abstractCollection;
            Object object;
            Iterator iterator = arrayList.iterator();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (iterator.hasNext()) {
                Function function;
                Binding[] bindingArray;
                Instruction[] instructionArray;
                object = (Function)iterator.next();
                if (module.m_signature.containsFunction(((Function)object).getName())) continue;
                abstractCollection = new ArrayList();
                Iterator<Binding> iterator2 = new ArrayList();
                ArrayList<LiteralInstruction> arrayList3 = new ArrayList<LiteralInstruction>();
                int n = ((Function)object).m_parameters.length;
                HashMap hashMap4 = (HashMap)hashMap2.get(((Function)object).getName());
                if (hashMap4 == null) {
                    hashMap4 = new HashMap();
                    ((Function)object).determineDataDependencies(((Function)object).m_parameters, hashMap4);
                    hashMap2.put(((Function)object).getName(), hashMap4);
                }
                block2: for (int i = 0; i < n; ++i) {
                    instructionArray = (Instruction[])hashMap4.get(((Function)object).m_parameters[i]);
                    if (instructionArray == null || instructionArray.isEmpty()) continue;
                    bindingArray = instructionArray.iterator();
                    while (bindingArray.hasNext()) {
                        BindingDependencyInfo bindingDependencyInfo = (BindingDependencyInfo)bindingArray.next();
                        if (bindingDependencyInfo.getParent() instanceof FunctionCallInstruction) {
                            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)bindingDependencyInfo.getParent();
                            int n2 = functionCallInstruction.getChildInstructionIndex(bindingDependencyInfo.m_identifierInstruction);
                            if (n2 == -1) {
                                bindingArray.remove();
                                continue;
                            }
                            if (functionCallInstruction.getFunction().equals(((Function)object).getName())) continue;
                            ((ArrayList)abstractCollection).add(((Function)object).m_parameters[i]);
                            continue block2;
                        }
                        ((ArrayList)abstractCollection).add(((Function)object).m_parameters[i]);
                        continue block2;
                    }
                    if (instructionArray.isEmpty()) continue;
                    ((ArrayList)((Object)iterator2)).add(((Function)object).m_parameters[i]);
                    arrayList3.add(new LiteralInstruction(((Function)object).m_parameters[i].getBindingType(), null));
                }
                if (((ArrayList)abstractCollection).size() == n || (function = ((Function)object).lookupDerivative(DeadParameterEliminatorOptimizer.class)) != null && function.m_parameters.length == ((ArrayList)abstractCollection).size()) continue;
                s_logger.debug("shrinking " + ((Function)object).getName());
                hashMap3.put(object, ((Function)object).m_parameters);
                ((Function)object).registerDerivative(DeadParameterEliminatorOptimizer.class, (Function)object);
                ((Function)object).setMemoizeResult(((Function)object).getMemoizeResult());
                ((Function)object).m_parameters = new Binding[((ArrayList)abstractCollection).size()];
                ((ArrayList)abstractCollection).toArray(((Function)object).m_parameters);
                instructionArray = new Instruction[arrayList3.size()];
                arrayList3.toArray(instructionArray);
                bindingArray = new Binding[arrayList3.size()];
                ((ArrayList)((Object)iterator2)).toArray((Binding[])bindingArray);
                new TailRecursiveOptimizer(){

                    @Override
                    protected Instruction optimizeStep2(Instruction instruction) {
                        FunctionCallInstruction functionCallInstruction;
                        if (instruction instanceof FunctionCallInstruction && (functionCallInstruction = (FunctionCallInstruction)instruction).getFunction().equals(this.m_currentFunction.getOriginalFunction().getName())) {
                            Function function = this.m_currentFunction.getOriginalFunction();
                            Function function2 = this.m_currentFunction;
                            ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
                            Binding[] bindingArray = (Binding[])hashMap3.get(function);
                            int n = bindingArray.length;
                            int n2 = 0;
                            for (int i = 0; i < n && n2 < function2.m_parameters.length; ++i) {
                                if (bindingArray[i] != function2.m_parameters[n2]) continue;
                                arrayList.add(functionCallInstruction.getChildInstruction(i));
                                ++n2;
                            }
                            functionCallInstruction.m_parameters = new Instruction[arrayList.size()];
                            arrayList.toArray(functionCallInstruction.m_parameters);
                            functionCallInstruction.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
                            return functionCallInstruction;
                        }
                        return instruction;
                    }
                }.optimizeFunction((Function)object);
                arrayList2.add(((Function)object).getName());
                if (function == null) continue;
                function.registerDerivative(DeadParameterEliminatorOptimizer.class, (Function)object);
            }
            if (arrayList2.size() == 0) {
                s_logger.debug("finished dead param elimination");
                return;
            }
            object = new DeadParameterEliminatorOptimizer(module, hashMap3);
            abstractCollection = new HashSet();
            for (String string : arrayList2) {
                Collection collection = (Collection)hashMap.get(string);
                if (collection == null) continue;
                abstractCollection.addAll(collection);
            }
            for (String string : abstractCollection) {
                ((DeadParameterEliminatorOptimizer)object).optimizeFunction(module.getFunction(string));
            }
            arrayList = ((DeadParameterEliminatorOptimizer)object).m_changedFunctions;
        }
    }

    static class BuildFunctionCallGraph
    extends TailRecursiveOptimizer {
        protected HashMap m_callers = new HashMap();

        BuildFunctionCallGraph() {
        }

        @Override
        protected Instruction optimizeStep2(Instruction instruction) {
            if (instruction instanceof FunctionCallInstruction) {
                FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
                HashSet<String> hashSet = (HashSet<String>)this.m_callers.get(functionCallInstruction.getFunction());
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                    this.m_callers.put(functionCallInstruction.getFunction(), hashSet);
                }
                hashSet.add(this.getCurrentFunction().getName());
            }
            return instruction;
        }
    }
}

