/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.interpreter;

import com.ibm.xylem.Type;
import com.ibm.xylem.interpreter.IAppendableStream;
import com.ibm.xylem.interpreter.IConvertible;
import com.ibm.xylem.interpreter.IStream;
import com.ibm.xylem.interpreter.StreamUtilities;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.JavaObjectType;
import com.ibm.xylem.utils.XylemError;
import java.io.CharArrayWriter;
import java.util.Iterator;

public class CharArrayWriterStream
implements IAppendableStream,
IConvertible {
    protected CharArrayWriter m_caw = new CharArrayWriter();

    @Override
    public Iterator iterator() {
        final String string = this.m_caw.toString();
        return new Iterator(){
            int m_i = 0;
            int m_c = string.length();

            @Override
            public boolean hasNext() {
                return this.m_i < this.m_c;
            }

            public Object next() {
                return new Character(string.charAt(this.m_i++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String toString() {
        return this.m_caw.toString();
    }

    @Override
    public char[] toCharArray() {
        return this.m_caw.toCharArray();
    }

    @Override
    public Object convert(Type type) {
        if (type.equals(JavaObjectType.s_javaStringType)) {
            return this.m_caw.toString();
        }
        if (type.equals(CharType.s_charType.getStreamType())) {
            return this.toCharArray();
        }
        throw new XylemError("ERR_SYSTEM", "Cannot convert StringStream to " + type);
    }

    @Override
    public int size() {
        return this.m_caw.size();
    }

    @Override
    public Object get(int n) {
        return new Character(this.m_caw.toCharArray()[n]);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IStream)) {
            return false;
        }
        return StreamUtilities.equals(this, (IStream)object);
    }

    public int hashCode() {
        return StreamUtilities.hashCode(this);
    }

    @Override
    public void append(Object object) {
        if (object instanceof IStream) {
            char[] cArray = ((IStream)object).toCharArray();
            this.m_caw.write(cArray, 0, cArray.length);
        } else if (object instanceof Character) {
            this.m_caw.write(((Character)object).charValue());
        } else {
            throw new IllegalArgumentException();
        }
    }
}

