/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.types.UnionType;
import java.io.IOException;
import java.util.LinkedList;

public class UnionInjectInstruction
extends UnaryPrimopInstruction {
    protected Type m_unionType;
    protected int m_index;
    protected int m_unionSize;

    public UnionInjectInstruction(Type type, int n, int n2, Instruction instruction) {
        super(instruction);
        this.m_unionType = type;
        this.m_index = n;
        this.m_unionSize = n2;
    }

    public UnionInjectInstruction() {
    }

    public int getIndex() {
        return this.m_index;
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        throw new UnsupportedOperationException("UnionInjectInstruction should be removed by PolimorphicADTDesugarer.");
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        throw new UnsupportedOperationException("UnionInjectInstruction should be removed by PolimorphicADTDesugarer.");
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type[] typeArray = new Type[this.m_unionSize];
        for (int i = 0; i < this.m_unionSize; ++i) {
            typeArray[i] = i == this.m_index ? this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList) : new TypeVariable();
        }
        UnionType unionType = new UnionType(typeArray);
        typeEnvironment.unify(unionType, this.m_unionType, this);
        return this.setCachedType(this.m_unionType);
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_unionType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new UnionInjectInstruction(this.m_unionType, this.m_index, this.m_unionSize, this.m_operand.cloneWithoutTypeInformation());
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction) {
        return new UnionInjectInstruction(this.m_unionType, this.m_index, this.m_unionSize, instruction);
    }

    @Override
    public String innerToString() {
        return "union-inject " + this.m_unionType.prettyPrint() + " " + this.m_index + " " + this.m_unionSize;
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Object object = this.m_operand.evaluate(environment, function, iDebuggerInterceptor, false);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_unionType = readObjectFileHelper.readType();
        this.m_index = readObjectFileHelper.readInt();
        this.m_unionSize = readObjectFileHelper.readInt();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeType(this.m_unionType);
        writeObjectFileHelper.writeInt(this.m_index);
        writeObjectFileHelper.writeInt(this.m_unionSize);
    }

    @Override
    public boolean isStatic(BindingEnvironment bindingEnvironment) {
        return this.m_operand.isStatic(bindingEnvironment);
    }

    @Override
    public Type getTypeParameter(int n) {
        return this.m_unionType;
    }

    @Override
    public void setTypeParameter(int n, Type type) {
        if (n == 0) {
            this.m_unionType = type;
        }
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }
}

