/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.ObjectFactory;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.types.JavaClassInformation;
import com.ibm.xylem.types.JavaObjectType;
import com.ibm.xylem.utils.SecurityUtil;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.util.LinkedList;

public class StaticMemberInstruction
extends Instruction {
    protected String m_className;
    protected String m_fieldName;

    public StaticMemberInstruction() {
    }

    public StaticMemberInstruction(String string, String string2) {
        this(string, string2, null);
    }

    public StaticMemberInstruction(String string, String string2, Type type) {
        this.m_className = string;
        this.m_fieldName = string2;
        this.setCachedType(type);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        return this.setCachedType(this.computeType(typeEnvironment.getModule()));
    }

    Type computeType(Module module) {
        JavaObjectType javaObjectType = new JavaObjectType(this.m_className);
        JavaClassInformation javaClassInformation = javaObjectType.getInformation(module);
        JavaClassInformation.Field field = javaClassInformation.getField(this.m_fieldName);
        return field.getType();
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        super.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        if (this.getCachedType() == null) {
            this.setCachedType(this.computeType(typeEnvironment.getModule()));
        }
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.getCachedType();
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("gen code for: " + this);
            s_logger.debug("tenv: " + typeEnvironment);
            s_logger.debug("type: " + this.getCachedType());
        }
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        String string3 = this.m_className;
        dataFlowCodeGenerationHelper.appendAssignment(string2, this.getCachedType(), string3 + "." + this.m_fieldName, codeGenerationTracker);
        return string2;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        instructionListBuilder.appendGetStatic(this.m_className, this.m_fieldName, codeGenerationTracker.resolveType(this).getImplementationType(bCELCodeGenerationHelper));
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (SecurityUtil.disableExtensionCalls()) {
            throw new XylemError("ERR_FIELD_ACCESS_MODIFY_WHEN_JAVA_SECURITY_ENABLED", new Object[]{this.m_fieldName, this.m_className, "com.ibm.xtq.processor.overrideSecureProcessing"});
        }
        try {
            return ObjectFactory.findProviderClass(this.m_className, ObjectFactory.findClassLoader(), true).getDeclaredField(this.m_fieldName).get(null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new StaticMemberInstruction(this.m_className, this.m_fieldName);
    }

    @Override
    public Instruction cloneShallow() {
        return new StaticMemberInstruction(this.m_className, this.m_fieldName, this.getCachedType());
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        instructionArray[0] = this;
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen("java-static-field-ref " + this.m_className + " " + this.m_fieldName, n);
        prettyPrinter.print(")");
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_className = readObjectFileHelper.readString();
        this.m_fieldName = readObjectFileHelper.readString();
        Type type = readObjectFileHelper.readType();
        if (type == null) {
            throw new XylemError("ERR_SYSTEM", "null type");
        }
        this.setCachedType(type);
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeString(this.m_className);
        writeObjectFileHelper.writeString(this.m_fieldName);
        if (this.getCachedType() == null) {
            throw new XylemError("ERR_SYSTEM", "null type");
        }
        writeObjectFileHelper.writeType(this.getCachedType());
    }
}

