/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.types.BooleanType;
import com.ibm.xylem.types.DoubleType;
import com.ibm.xylem.types.FloatType;
import java.util.LinkedList;

public class NaNInstruction
extends UnaryPrimopInstruction {
    public NaNInstruction(Instruction instruction) {
        super(instruction);
    }

    public NaNInstruction() {
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new NaNInstruction(this.m_operand.cloneWithoutTypeInformation());
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type = this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        if (type != FloatType.s_floatType && type != DoubleType.s_doubleType) {
            typeEnvironment.unify(type, DoubleType.s_doubleType, this);
        }
        return this.setCachedType(BooleanType.s_booleanType);
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = codeGenerationTracker.generateConventionally(this.m_operand, dataFlowCodeGenerationHelper);
        String string3 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        if (this.m_operand.getCachedType() == FloatType.s_floatType) {
            dataFlowCodeGenerationHelper.appendAssignment(string3, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), "Float.isNaN(" + string2 + ")", codeGenerationTracker);
        } else {
            dataFlowCodeGenerationHelper.appendAssignment(string3, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), "Double.isNaN(" + string2 + ")", codeGenerationTracker);
        }
        return string3;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        codeGenerationTracker.generateConventionally(this.m_operand, bCELCodeGenerationHelper, null, instructionListBuilder);
        if (this.m_operand.getCachedType() == FloatType.s_floatType) {
            instructionListBuilder.appendInvokeStatic("java.lang.Float", "isNaN", (com.ibm.xtq.bcel.generic.Type)BasicType.BOOLEAN, new BasicType[]{BasicType.FLOAT});
        } else {
            instructionListBuilder.appendInvokeStatic("java.lang.Double", "isNaN", (com.ibm.xtq.bcel.generic.Type)BasicType.BOOLEAN, new BasicType[]{BasicType.DOUBLE});
        }
    }

    @Override
    public String innerToString() {
        return "nan?";
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        if (this.m_operand.evaluateType(function) == FloatType.s_floatType) {
            Boolean bl2 = ((Float)this.m_operand.evaluate(environment, function, iDebuggerInterceptor, false)).isNaN() ? Boolean.TRUE : Boolean.FALSE;
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, bl2);
        }
        Boolean bl3 = ((Double)this.m_operand.evaluate(environment, function, iDebuggerInterceptor, false)).isNaN() ? Boolean.TRUE : Boolean.FALSE;
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, bl3);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction) {
        return new NaNInstruction(instruction);
    }
}

