/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.types.ClassType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.UnitType;
import java.io.IOException;
import java.util.LinkedList;

public class MethodInvocationInstruction
extends NaryPrimopInstruction {
    protected String m_function;
    public Instruction m_object;

    public MethodInvocationInstruction() {
    }

    public MethodInvocationInstruction(String string, Instruction instruction, Instruction[] instructionArray) {
        super(instructionArray);
        this.m_function = string;
        this.m_object = instruction;
    }

    public Instruction getObject() {
        return this.m_object;
    }

    public String getFunction() {
        return this.m_function;
    }

    public void setFunction(String string) {
        this.m_function = string;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type = this.m_object.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        type = type.resolveType(typeEnvironment);
        if (type == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_object), this);
        }
        if (!(type instanceof NamedType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_object + " is not an object"), this);
        }
        ClassType classType = (ClassType)((NamedType)type).resolveName(typeEnvironment);
        if (classType == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_object + " is not a Xylem object"), this);
        }
        ClassType.Method method = classType.resolveMethod(this.m_function, typeEnvironment);
        if (method == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + classType.getName() + " has no method named " + this.m_function), this);
        }
        Binding[] bindingArray = method.m_parameters;
        if (bindingArray.length != this.m_parameters.length) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Method " + this.m_function + " of class " + classType.getName() + " takes " + method.m_parameters.length + " parameters"), this);
        }
        for (int i = 0; i < bindingArray.length; ++i) {
            typeEnvironment.unify(bindingArray[i].getBindingType(), this.m_parameters[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList), this);
        }
        return this.setCachedType(method.getReturnType());
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type = this.m_object.getType(typeEnvironment, bindingEnvironment);
        type = type.resolveType(typeEnvironment);
        ClassType classType = (ClassType)((NamedType)type).resolveName(typeEnvironment);
        ClassType.Method method = classType.resolveMethod(this.m_function, typeEnvironment);
        return method.getReturnType();
    }

    @Override
    public Instruction getChildInstruction(int n) {
        return n > 0 ? this.m_parameters[n - 1] : this.m_object;
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_parameters.length + 1;
    }

    @Override
    public void setChildInstruction(int n, Instruction instruction) {
        if (n == 0) {
            this.m_object = instruction;
        } else {
            this.m_parameters[n - 1] = instruction;
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        return new MethodInvocationInstruction(this.m_function, this.m_object.cloneWithoutTypeInformation(), instructionArray);
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_parameters.clone();
        return new MethodInvocationInstruction(this.m_function, this.m_object, instructionArray);
    }

    @Override
    public String innerToString() {
        return "method-invoke " + this.m_function;
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        Object object;
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            object = codeGenerationTracker.generateConventionally(this.m_parameters[i], dataFlowCodeGenerationHelper);
            stringBuffer.append((String)object);
        }
        String string3 = codeGenerationTracker.generateConventionally(this.m_object, dataFlowCodeGenerationHelper);
        object = codeGenerationTracker.resolveType(this);
        ClassType classType = (ClassType)((NamedType)codeGenerationTracker.resolveType(this.m_object)).resolveName(codeGenerationTracker.m_typeEnvironment);
        ClassType.Method method = classType.resolveMethod(this.m_function, typeEnvironment);
        String string4 = string3 + "." + method.getName() + "(" + stringBuffer.toString() + ")";
        if (method.getReturnType() instanceof UnitType) {
            dataFlowCodeGenerationHelper.append(string4 + ";\n");
            string4 = "1";
        }
        dataFlowCodeGenerationHelper.appendAssignment(string2, method.getReturnType(), string4, codeGenerationTracker);
        return string2;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        MethodInvocationInstruction methodInvocationInstruction = (MethodInvocationInstruction)object;
        return methodInvocationInstruction.m_function.equals(this.m_function);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.m_function.hashCode();
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        this.m_object = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_object, bindingEnvironment);
        super.generateReducedForm(reductionHelper, instructionArray, bindingEnvironment);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_object = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_function = readObjectFileHelper.readString();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeInstruction(this.m_object);
        writeObjectFileHelper.writeString(this.m_function);
    }
}

