/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.IImperativeInstruction;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.JavaClassImporter;
import com.ibm.xylem.JavaClassWrapper;
import com.ibm.xylem.JavaMethodWrapper;
import com.ibm.xylem.Module;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xylem.instructions.ObjectFactory;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IConvertible;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.types.JavaClassInformation;
import com.ibm.xylem.types.JavaObjectType;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.types.UnitType;
import com.ibm.xylem.utils.SecurityUtil;
import com.ibm.xylem.utils.WrappedRuntimeException;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class JavaMethodInvocationInstruction
extends NaryPrimopInstruction
implements IImperativeInstruction {
    protected String m_function;
    public Instruction m_object;
    protected String m_classname;
    protected Type m_type;

    public JavaMethodInvocationInstruction() {
    }

    public JavaMethodInvocationInstruction(String string, Instruction instruction, Instruction[] instructionArray, Type type) {
        super(instructionArray);
        this.m_function = string;
        this.m_object = instruction;
        this.setCachedType(type);
        this.m_type = type;
    }

    public JavaMethodInvocationInstruction(String string, String string2, Instruction[] instructionArray, Type type) {
        super(instructionArray);
        this.m_function = string;
        this.m_classname = string2;
        this.setCachedType(type);
    }

    public String getFunction() {
        return this.m_function;
    }

    public String getClassName() {
        return this.m_classname;
    }

    public void setFunction(String string) {
        this.m_function = string;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    public Instruction getObject() {
        return this.m_object;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        if (this.m_object != null) {
            this.m_object.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        }
        s_logger.debug("[JavaMethodInvocationInstruction.typeCheck] checking " + this);
        if (this.m_type == null) {
            Object object;
            int n;
            int n2;
            Object object2;
            JavaObjectType javaObjectType;
            if (this.m_object == null) {
                javaObjectType = new JavaObjectType(this.m_classname);
            } else {
                object2 = this.m_object.getCachedType();
                if (object2 == null) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not find the type of " + this.m_object), this);
                }
                if ((object2 = ((Type)object2).resolveType(typeEnvironment)) == null) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_object), this);
                }
                if (!(object2 instanceof JavaObjectType)) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_object + " is not a Java object"), this);
                }
                javaObjectType = (JavaObjectType)object2;
            }
            object2 = javaObjectType.getInformation(typeEnvironment.getModule());
            if (this.m_object == null) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Java instance method invocation without an object."), this);
            }
            Collection collection = this.getMethods((JavaClassInformation)object2, this.m_function, typeEnvironment.getModule());
            if (collection == null || collection.size() == 0) {
                if (javaObjectType.getInformation(typeEnvironment.getModule()).getBaseClassNames().size() == 0) {
                    s_logger.debug("[JavaMethodInvocationInstruction.typeCheck] could not find any base classes for " + javaObjectType.getClassName() + ".  Maybe I can't find the class either.");
                }
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + javaObjectType + " does not contain a method named " + this.m_function), this);
            }
            for (n2 = 0; n2 < this.m_parameters.length; ++n2) {
                this.m_parameters[n2].typeCheck(typeEnvironment, bindingEnvironment, linkedList);
            }
            n2 = 1;
            for (n = 0; n < this.m_parameters.length; ++n) {
                if (this.m_parameters[n].getCachedType().isFullySpecified()) continue;
                n2 = 0;
                break;
            }
            if (n2 == 0) {
                n = 0;
                for (Type[] typeArray : collection) {
                    object = typeArray.getParameterTypes();
                    if (((Type[])object).length != this.m_parameters.length) continue;
                    ++n;
                }
                if (n > 1) {
                    this.m_type = this.setCachedType(new TypeVariable());
                    return this.m_type;
                }
            }
            for (Object object3 : collection) {
                Type[] typeArray;
                typeArray = ((JavaClassInformation.Method)object3).getParameterTypes();
                if (typeArray.length != this.m_parameters.length) continue;
                object = typeEnvironment.copy();
                try {
                    int n3;
                    for (n3 = 0; n3 < typeArray.length; ++n3) {
                        ((TypeEnvironment)object).unify(typeArray[n3], this.m_parameters[n3].getCachedType(), this);
                    }
                    for (n3 = 0; n3 < typeArray.length; ++n3) {
                        typeEnvironment.unify(typeArray[n3], this.m_parameters[n3].getCachedType(), this);
                    }
                    this.m_type = this.setCachedType(((JavaClassInformation.Method)object3).getReturnType());
                    return this.m_type;
                }
                catch (TypeCheckException typeCheckException) {
                    s_logger.debug("[JavaMethodInvocationInstruction.typeCheck] method did not match.  reason: " + typeCheckException.getMessage());
                }
            }
            if (this.m_type == null) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not find a suitable method named " + this.m_function + " for " + this.m_object), this);
            }
        } else {
            for (int i = 0; i < this.m_parameters.length; ++i) {
                this.m_parameters[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList);
            }
        }
        return this.setCachedType(this.m_type);
    }

    private Collection getMethods(JavaClassInformation javaClassInformation, String string, Module module) {
        Set set;
        Collection collection = javaClassInformation.getMethods(string);
        return collection != null && collection.size() > 0 ? collection : ((set = javaClassInformation.getBaseClassNames()).size() < 1 ? null : this.getMethods(set, string, module));
    }

    private Collection getMethods(Set set, String string, Module module) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                JavaClassInformation javaClassInformation = JavaClassImporter.retrieveJavaClassInformation((String)iterator.next(), module);
                Collection collection = this.getMethods(javaClassInformation, string, module);
                if (collection == null || collection.size() <= 0) continue;
                return collection;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_type;
    }

    @Override
    public Instruction getChildInstruction(int n) {
        return n > 0 ? this.m_parameters[n - 1] : this.m_object;
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_parameters.length + 1;
    }

    @Override
    public void setChildInstruction(int n, Instruction instruction) {
        if (n == 0) {
            this.m_object = instruction;
        } else {
            this.m_parameters[n - 1] = instruction;
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        if (this.m_classname == null) {
            return new JavaMethodInvocationInstruction(this.m_function, this.m_object.cloneWithoutTypeInformation(), instructionArray, this.m_type);
        }
        return new JavaMethodInvocationInstruction(this.m_function, this.m_classname, instructionArray, this.m_type);
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_parameters.clone();
        if (this.m_classname == null) {
            return new JavaMethodInvocationInstruction(this.m_function, this.m_object, instructionArray, this.m_type);
        }
        return new JavaMethodInvocationInstruction(this.m_function, this.m_classname, instructionArray, this.m_type);
    }

    @Override
    public String innerToString() {
        return "java-method-invoke" + (this.m_type == null ? "" : "@" + this.m_type.prettyPrint());
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen(this.innerToString(), n);
        if (this.m_classname != null) {
            prettyPrinter.print(" \"" + this.m_classname + "\" ");
        } else {
            this.m_object.toString(prettyPrinter, n + 1);
        }
        prettyPrinter.printToken(this.m_function, n + 1);
        if (this.getChildInstructionCount() > 0) {
            for (int i = 1; i < this.getChildInstructionCount(); ++i) {
                Instruction instruction = this.getChildInstruction(i);
                if (instruction != null) {
                    instruction.toString(prettyPrinter, n + 1);
                    continue;
                }
                prettyPrinter.printToken("null", n + 1);
            }
        }
        prettyPrinter.printFormClose(n);
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            String string3 = codeGenerationTracker.generateConventionally(this.m_parameters[i], dataFlowCodeGenerationHelper);
            stringBuffer.append(string3);
            if (i >= this.m_parameters.length - 1) continue;
            stringBuffer.append(", ");
        }
        String string4 = this.m_classname == null ? codeGenerationTracker.generateConventionally(this.m_object, dataFlowCodeGenerationHelper) : this.m_classname;
        if (UnitType.s_unitType.equals(this.m_type.resolveType(codeGenerationTracker.m_typeEnvironment))) {
            dataFlowCodeGenerationHelper.append(string4 + "." + this.m_function + "(" + stringBuffer.toString() + ");\n");
            return "1";
        }
        dataFlowCodeGenerationHelper.appendAssignment(string2, this.m_type, string4 + "." + this.m_function + "(" + stringBuffer.toString() + ")", codeGenerationTracker);
        return string2;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        JavaMethodWrapper javaMethodWrapper = this.getMethod(codeGenerationTracker.getCurrentModule().getFunction(bCELCodeGenerationHelper.getCurrentFunction()));
        boolean bl = javaMethodWrapper.isStatic();
        if (!bl) {
            codeGenerationTracker.generateConventionally(this.m_object, bCELCodeGenerationHelper, null, instructionListBuilder);
        }
        com.ibm.xtq.bcel.generic.Type[] typeArray = new com.ibm.xtq.bcel.generic.Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            codeGenerationTracker.generateConventionally(this.m_parameters[i], bCELCodeGenerationHelper, null, instructionListBuilder);
            typeArray[i] = javaMethodWrapper.getParamType(i).getBCELType();
        }
        if (!bl) {
            if (javaMethodWrapper.declaringClassIsInterface()) {
                instructionListBuilder.appendInvokeInterface(javaMethodWrapper.getDeclaringClassName(), javaMethodWrapper.getName(), javaMethodWrapper.getReturnType().getBCELType(), typeArray);
            } else {
                instructionListBuilder.appendInvokeMethod(javaMethodWrapper.getDeclaringClassName(), javaMethodWrapper.getName(), javaMethodWrapper.getReturnType().getBCELType(), typeArray);
            }
        } else {
            instructionListBuilder.appendInvokeStatic(javaMethodWrapper.getDeclaringClassName(), javaMethodWrapper.getName(), javaMethodWrapper.getReturnType().getBCELType(), typeArray);
        }
        if (UnitType.s_unitType.equals(this.m_type)) {
            instructionListBuilder.appendConstant(1);
        }
    }

    private final JavaMethodWrapper getMethod(Function function) {
        Object object;
        JavaClassWrapper javaClassWrapper = null;
        if (this.m_object != null) {
            object = this.m_object.evaluateType(function);
            javaClassWrapper = object.getJavaType();
        } else {
            object = this.m_classname;
            while (javaClassWrapper == null) {
                try {
                    javaClassWrapper = new JavaClassWrapper(ObjectFactory.findProviderClass((String)object, ObjectFactory.findClassLoader(), true));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    int n = this.m_classname.lastIndexOf(46);
                    if (n != -1) {
                        object = object.substring(0, n) + "$" + object.substring(n + 1, object.length());
                        continue;
                    }
                    throw new XylemError("ERR_SYSTEM", "Could not find class for " + this.m_classname);
                }
            }
        }
        object = new JavaClassWrapper[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Type type = this.m_parameters[i].evaluateType(function);
            object[i] = type.getJavaType();
        }
        try {
            JavaMethodWrapper javaMethodWrapper = JavaClassWrapper.getMethod(javaClassWrapper, this.m_function, object);
            return javaMethodWrapper;
        }
        catch (Exception exception) {
            throw new WrappedRuntimeException(exception);
        }
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object;
        Object object2;
        int n;
        Object object3;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        if (SecurityUtil.disableExtensionCalls()) {
            String string = this.m_classname == null || this.m_classname.length() == 0 ? this.m_function : this.m_classname + "." + this.m_function;
            throw new XylemError("ERR_FUNCTION_CANNOT_BE_INVOKED_WHEN_JAVA_SECURITY_ENABLED", new Object[]{string, "com.ibm.xtq.processor.overrideSecureProcessing"});
        }
        Object object4 = null;
        JavaClassWrapper javaClassWrapper = null;
        if (this.m_object != null) {
            object3 = this.m_object.evaluateType(function);
            if (environment != null && (object4 = this.m_object.evaluate(environment, function, iDebuggerInterceptor, false)) instanceof IConvertible) {
                object4 = ((IConvertible)object4).convert((Type)object3);
            }
            javaClassWrapper = object3.getJavaType();
        } else {
            object3 = this.m_classname;
            while (javaClassWrapper == null) {
                try {
                    javaClassWrapper = new JavaClassWrapper(ObjectFactory.findProviderClass((String)object3, ObjectFactory.findClassLoader(), true));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    n = this.m_classname.lastIndexOf(46);
                    if (n != -1) {
                        object3 = object3.substring(0, n) + "$" + object3.substring(n + 1, object3.length());
                        continue;
                    }
                    throw new XylemError("ERR_SYSTEM", "Could not find class for " + this.m_classname);
                }
            }
        }
        object3 = new Object[this.m_parameters.length];
        JavaClassWrapper[] javaClassWrapperArray = new JavaClassWrapper[this.m_parameters.length];
        for (n = 0; n < this.m_parameters.length; ++n) {
            object2 = this.m_parameters[n].evaluateType(function);
            if (environment != null) {
                object = this.m_parameters[n].evaluate(environment, function, iDebuggerInterceptor, false);
                if (object instanceof IConvertible) {
                    object = ((IConvertible)object).convert((Type)object2);
                }
                object3[n] = object;
            }
            javaClassWrapperArray[n] = ((Type)object2).getJavaType();
        }
        try {
            JavaMethodWrapper javaMethodWrapper = JavaClassWrapper.getMethod(javaClassWrapper, this.m_function, javaClassWrapperArray);
            if (environment == null) {
                return javaMethodWrapper;
            }
            object2 = javaMethodWrapper.invoke(object4, (Object[])object3);
            object = this.evaluateType(function);
            Object object5 = object2 = ((Type)object).createStream(object2);
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, object5);
        }
        catch (InvocationTargetException invocationTargetException) {
            object2 = invocationTargetException.getTargetException();
            throw new WrappedRuntimeException((Throwable)object2);
        }
        catch (Exception exception) {
            throw new WrappedRuntimeException(exception);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        JavaMethodInvocationInstruction javaMethodInvocationInstruction = (JavaMethodInvocationInstruction)object;
        return javaMethodInvocationInstruction.m_function.equals(this.m_function);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.m_function.hashCode();
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        this.m_object = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_object, bindingEnvironment);
        super.generateReducedForm(reductionHelper, instructionArray, bindingEnvironment);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_object = readObjectFileHelper.readInstruction(bindingEnvironment);
        if (readObjectFileHelper.readBoolean()) {
            this.m_classname = readObjectFileHelper.readString();
        }
        this.m_function = readObjectFileHelper.readString();
        this.m_type = readObjectFileHelper.readType();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeInstruction(this.m_object);
        writeObjectFileHelper.writeBoolean(this.m_classname != null);
        if (this.m_classname != null) {
            writeObjectFileHelper.writeString(this.m_classname);
        }
        writeObjectFileHelper.writeString(this.m_function);
        writeObjectFileHelper.writeType(this.m_type);
    }
}

