/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.codegen;

import com.ibm.xylem.Logger;
import com.ibm.xylem.codegen.JavaCSettings;
import com.ibm.xylem.codegen.bcel.ClassCollector;
import com.ibm.xylem.config.Settings;

public class CodeGenerationSettings
extends Settings {
    static final Logger s_logger = Logger.getInstance(CodeGenerationSettings.class);
    protected boolean m_makeAllMethodsStatic = true;
    protected boolean m_multiClassMethodOutput = true;
    protected boolean m_singleThreadPerInstance = true;
    protected boolean m_enableTracing = false;
    protected boolean m_obfuscateFunctionNames = false;
    protected int m_maxFunctionsPerPartition = 800;
    protected boolean m_suppressComments = false;
    public boolean m_dumpxylem = false;
    protected int m_targetLanguage = 1;
    protected JavaCSettings m_javaCSettings = new JavaCSettings();
    protected int m_postReductionSplitLimit = 0;
    protected boolean m_threadSafe = false;
    protected boolean m_byteCodeLineNumbers = false;
    protected boolean m_bufferDiagnostics = false;
    protected ClassCollector m_classCollector = null;
    protected boolean m_bcelAutoSplitFunctions = false;
    protected int m_reservedBytes = 0;
    protected boolean m_orderSafeSplit = false;
    protected boolean m_externalizeStrings = false;
    protected boolean m_outlineStreamAppend = false;
    public static final int s_javaSource = 1;
    public static final int s_javaByteCode = 2;
    public static final int s_cpp = 3;
    public static final int s_cxo = 4;

    public void setMakeAllMethodsStatic(boolean bl) {
        this.m_makeAllMethodsStatic = bl;
    }

    public boolean isMakeAllMethodsStatic() {
        return this.m_makeAllMethodsStatic;
    }

    public void setTargetLanguage(int n) {
        this.m_targetLanguage = n;
    }

    public int getTargetLanguage() {
        return this.m_targetLanguage;
    }

    public void setSuppressComments(boolean bl) {
        this.m_suppressComments = bl;
    }

    public boolean isSuppressComments() {
        return this.m_suppressComments;
    }

    public void setMultiPartitionOutput(boolean bl) {
        this.m_multiClassMethodOutput = bl;
    }

    public boolean isMultiPartitionOutput() {
        return this.m_multiClassMethodOutput;
    }

    public void setSingleThreadPerInstance(boolean bl) {
        this.m_singleThreadPerInstance = bl;
    }

    public boolean isSingleThreadPerInstance() {
        return this.m_singleThreadPerInstance;
    }

    public void setFunctionCallTracing(boolean bl) {
        this.m_enableTracing = bl;
    }

    public boolean isFunctionCallTracing() {
        return this.m_enableTracing;
    }

    public void setObfuscateFunctionNames(boolean bl) {
        this.m_obfuscateFunctionNames = bl;
    }

    public boolean isObfuscateFunctionNames() {
        return this.m_obfuscateFunctionNames;
    }

    public void setMaxFunctionsPerPartition(int n) {
        this.m_maxFunctionsPerPartition = n;
    }

    public int getMaxFunctionsPerPartition() {
        return this.m_maxFunctionsPerPartition;
    }

    public JavaCSettings getJavaCSettings() {
        return this.m_javaCSettings;
    }

    public boolean getBCELAutoSplitFunctions() {
        return this.m_bcelAutoSplitFunctions;
    }

    public void setBCELAutoSplitFunctions(boolean bl) {
        this.m_bcelAutoSplitFunctions = bl;
    }

    public int getReservedBytes() {
        return this.m_reservedBytes;
    }

    public void setReservedBytes(int n) {
        this.m_reservedBytes = n;
    }

    public boolean getOrderSafeSplit() {
        return this.m_orderSafeSplit;
    }

    public void setOrderSafeSplit(boolean bl) {
        this.m_orderSafeSplit = bl;
    }

    public boolean isExternalizeStrings() {
        return this.m_externalizeStrings;
    }

    public void setExternalizeStrings(boolean bl) {
        this.m_externalizeStrings = bl;
    }

    public boolean isOutlineStreamAppend() {
        return this.m_outlineStreamAppend;
    }

    public void setOutlineStreamAppend(boolean bl) {
        this.m_outlineStreamAppend = bl;
    }

    public int parseOption(String[] stringArray, int n) {
        if (stringArray[n].equals("-help") || stringArray[n].equals("-?") || stringArray[n].equals("-h")) {
            System.out.println("\t[-language java|cpp]\n\t[-disablejavac]\n\t[-dumpxylem]\n\t[-suppressComments]\n\t[-combinePartitions]\n\t[-enableTracing]\n\t[-newsplit n]\n\t[-maxfunctionsperpartition n]\n\t[-reservebytes bytes]\n\t[-generateBCEL]\n\t[-autosplitBCEL]\n\t[-obfuscate]\n\t[-externStrings]\n\t[-outlineAppend]\n\t[-generateCXO]\n");
            return n;
        }
        if (stringArray[n].equals("-language")) {
            if (++n == stringArray.length) {
                s_logger.error("-language missing parameter");
                return -1;
            }
            if (!stringArray[n].equals("java")) {
                if (stringArray[n].equals("cpp")) {
                    this.setTargetLanguage(3);
                } else {
                    s_logger.error("invalid language: " + stringArray[n]);
                    return -1;
                }
            }
            return n;
        }
        if (stringArray[n].equals("-suppressComments")) {
            this.setSuppressComments(true);
            return n;
        }
        if (stringArray[n].equals("-combinepartitions")) {
            this.setMultiPartitionOutput(false);
            return n;
        }
        if (stringArray[n].equals("-enabletracing")) {
            this.setFunctionCallTracing(true);
            return n;
        }
        if (stringArray[n].equals("-newsplit")) {
            if (++n == stringArray.length) {
                s_logger.error("-newsplit missing parameter");
                return -1;
            }
            try {
                this.setPostReductionSplitLimit(Integer.parseInt(stringArray[n]));
            }
            catch (NumberFormatException numberFormatException) {
                s_logger.error("invalid split limit: " + stringArray[n]);
                return -1;
            }
            return n;
        }
        if (stringArray[n].equals("-generateBCEL")) {
            this.setTargetLanguage(2);
            return n;
        }
        if (stringArray[n].equals("-generateCXO")) {
            this.setTargetLanguage(4);
            return n;
        }
        if (stringArray[n].equals("-autosplitBCEL")) {
            this.setBCELAutoSplitFunctions(true);
            return n;
        }
        if (stringArray[n].equals("-obfuscate")) {
            this.setObfuscateFunctionNames(true);
            return n;
        }
        if (stringArray[n].equals("-externStrings")) {
            this.setExternalizeStrings(true);
            return n;
        }
        if (stringArray[n].equals("-outlineAppend")) {
            this.setOutlineStreamAppend(true);
            return n;
        }
        if (stringArray[n].equals("-maxfunctionsperpartition")) {
            if (++n == stringArray.length) {
                s_logger.error("-maxfunctionsperpartition missing parameter");
                return -1;
            }
            this.setMaxFunctionsPerPartition(Integer.parseInt(stringArray[n]));
            return n;
        }
        if (stringArray[n].equals("-reservebytes")) {
            if (++n == stringArray.length) {
                s_logger.error("-reservebytes missing parameter");
                return -1;
            }
            this.setReservedBytes(Integer.parseInt(stringArray[n]));
            return n;
        }
        if (stringArray[n].equals("-disablejavac")) {
            this.getJavaCSettings().setJavaCDisabled(true);
            return n;
        }
        if (stringArray[n].equals("-dumpxylem")) {
            this.m_dumpxylem = true;
            return n;
        }
        return -2;
    }

    public int getPostReductionSplitLimit() {
        return this.m_postReductionSplitLimit;
    }

    public void setPostReductionSplitLimit(int n) {
        this.m_postReductionSplitLimit = n;
    }

    public boolean isThreadSafe() {
        return this.m_threadSafe;
    }

    public void setThreadSafe(boolean bl) {
        this.m_threadSafe = bl;
    }

    public boolean isByteCodeLineNumbers() {
        return this.m_byteCodeLineNumbers;
    }

    public boolean isBufferDiagnostics() {
        return this.m_bufferDiagnostics;
    }

    public void setBCELClassCollector(ClassCollector classCollector) {
        this.m_classCollector = classCollector;
    }

    public ClassCollector getBCELClassCollector() {
        return this.m_classCollector;
    }
}

