/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.autof;

import com.ibm.xtq.ast.nodes.XTQProgram;
import com.ibm.xtq.ast.parsers.xslt.SourceLoader;
import com.ibm.xtq.xslt.drivers.ParamReferenceIdentifier;
import com.ibm.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xtq.xslt.runtime.RuntimeLibrary;
import com.ibm.xtq.xslt.xylem.autof.FunctionComparator;
import com.ibm.xylem.Function;
import com.ibm.xylem.FunctionSignature;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.LogManager;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.commandline.CommandLineParserSingleInputFile;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.InputSource;

public class OverlapDetectionXSLTCompiler {
    static final Logger s_logger = Logger.getInstance(OverlapDetectionXSLTCompiler.class);

    public static void main(String[] stringArray) {
        LogManager.initializeLogger();
        CLP cLP = new CLP();
        if (!cLP.parseCommandLine(stringArray)) {
            return;
        }
        try {
            Module module = XSLTCompiler.compileRuntimeLibrary("1.0");
            for (int i = 0; i < cLP.m_inputFiles.size(); ++i) {
                URL uRL = (URL)cLP.m_inputFiles.get(i);
                Module module2 = OverlapDetectionXSLTCompiler.compileIndividualModule(uRL, module, cLP.m_settings);
                module2.removeDeadFunctions();
                File file = (File)cLP.m_outputFiles.get(i);
                if (cLP.m_dumpXylem) {
                    File file2 = new File(file.getAbsolutePath() + ".xylem");
                    s_logger.info("Xylem dump being written to file " + file2);
                    PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
                    module2.dump(printWriter);
                    printWriter.close();
                }
                ParamReferenceIdentifier.createParamReferences(module2);
                s_logger.info("Writing file " + file.getAbsolutePath());
                OverlapDetectionXSLTCompiler.writeIndividualModule(module2, file);
            }
            s_logger.info("Done");
        }
        catch (Exception exception) {
            s_logger.error("", exception);
        }
    }

    public static Module compileIndividualModule(URL uRL, Module module, XSLTCompilerSettings xSLTCompilerSettings, SourceLoader sourceLoader, boolean bl) throws Exception {
        Object object;
        InputSource inputSource;
        s_logger.info("Compiling stylesheet: " + uRL);
        XSLTCompiler xSLTCompiler = new XSLTCompiler(xSLTCompilerSettings);
        if (null != sourceLoader) {
            xSLTCompiler.setSourceLoader(sourceLoader);
        }
        xSLTCompiler.setRuntimeLibrary(module);
        if (null != sourceLoader && bl) {
            inputSource = sourceLoader.loadSource("", uRL.toString(), null);
        } else {
            object = uRL.openStream();
            inputSource = new InputSource((InputStream)object);
            inputSource.setSystemId(uRL.toString());
        }
        object = xSLTCompiler.buildAST(inputSource, uRL.toString());
        Module module2 = xSLTCompiler.translate((XTQProgram)object);
        module2.typeCheck(false);
        return module2;
    }

    public static Module compileIndividualModule(URL uRL, Module module, XSLTCompilerSettings xSLTCompilerSettings) throws Exception {
        return OverlapDetectionXSLTCompiler.compileIndividualModule(uRL, module, xSLTCompilerSettings, null, false);
    }

    public static void writeIndividualModule(Module module, File file) throws Exception {
        Object object;
        Object object2;
        ArrayList arrayList = new ArrayList(module.getFunctions());
        Collections.sort(arrayList, FunctionComparator.CMP);
        Iterator<Object> iterator = arrayList.iterator();
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        final HashMap hashMap = new HashMap();
        ArrayList<Record> arrayList2 = new ArrayList<Record>();
        String[] stringArray = new ObjectOutputStream(byteArrayOutputStream);
        WriteObjectFileHelper writeObjectFileHelper = new WriteObjectFileHelper(module, (ObjectOutput)stringArray){

            @Override
            public void writeInstructionTag(Instruction instruction) throws IOException {
                Integer n = (Integer)hashMap.get(instruction.getClass());
                if (n == null) {
                    n = new Integer(hashMap.size());
                    hashMap.put(instruction.getClass(), n);
                }
                this.writeInt(n);
                this.writeType(instruction.getCachedType());
            }
        };
        while (iterator.hasNext()) {
            int n = byteArrayOutputStream.size();
            object2 = (Function)iterator.next();
            object = new FunctionSignature((Function)object2);
            boolean bl = module.m_signature.containsFunction(((Function)object2).getName());
            if (((Function)object2).isDerivative()) {
                ((FunctionSignature)object).setFunctionName(((Function)object2).getOriginalFunction().getName());
            }
            if (((Function)object2).getName().equals("xdm-names")) {
                object3 = object2;
                continue;
            }
            if (((Function)object2).getName().equals("xdm-uris")) {
                object4 = object2;
                continue;
            }
            if (((Function)object2).getName().equals("xdm-types")) {
                object5 = object2;
                continue;
            }
            ((Function)object2).write(writeObjectFileHelper);
            int n2 = byteArrayOutputStream.size();
            Record record = new Record((FunctionSignature)object, n, n2 - n, ((Function)object2).getName(), bl);
            arrayList2.add(record);
        }
        writeObjectFileHelper.close();
        byteArrayOutputStream.close();
        stringArray = XSLTLinker.retrieveXDMStringArray(object3);
        writeObjectFileHelper = XSLTLinker.retrieveXDMStringArray(object4);
        int[] nArray = XSLTLinker.retrieveXDMIntArray(object5);
        object2 = new ByteArrayOutputStream();
        object = new ObjectOutputStream((OutputStream)object2);
        Object object6 = new WriteObjectFileHelper(module, (ObjectOutput)object);
        ((WriteObjectFileHelper)object6).writeObject(stringArray);
        ((WriteObjectFileHelper)object6).writeObject(writeObjectFileHelper);
        ((WriteObjectFileHelper)object6).writeObject(nArray);
        ((WriteObjectFileHelper)object6).writeInt(arrayList2.size());
        for (Record record : arrayList2) {
            ((WriteObjectFileHelper)object6).writeInt(record.m_offset);
            ((WriteObjectFileHelper)object6).writeInt(record.m_size);
            ((WriteObjectFileHelper)object6).writeString(record.m_originalName);
            ((WriteObjectFileHelper)object6).writeBoolean(record.m_exported);
            record.m_signature.write((WriteObjectFileHelper)object6);
        }
        ((ObjectOutputStream)object).writeInt(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            ((ObjectOutputStream)object).writeObject(entry.getValue());
            ((ObjectOutputStream)object).writeObject(entry.getKey());
        }
        ((WriteObjectFileHelper)object6).close();
        object = new FileOutputStream(file);
        object6 = new DataOutputStream((OutputStream)object);
        byte[] byArray = ((ByteArrayOutputStream)object2).toByteArray();
        ((DataOutputStream)object6).writeInt(byArray.length);
        ((DataOutputStream)object6).flush();
        ((FileOutputStream)object).write(byArray);
        ((FileOutputStream)object).write(byteArrayOutputStream.toByteArray());
        ((FilterOutputStream)object6).close();
    }

    private static class CLP
    extends CommandLineParserSingleInputFile {
        ArrayList m_inputFiles = new ArrayList();
        ArrayList m_outputFiles = new ArrayList();
        XSLTCompilerSettings m_settings = new XSLTCompilerSettings();
        boolean m_dumpXylem = false;

        private CLP() {
        }

        @Override
        protected int parseOption(String[] stringArray, int n) {
            if (stringArray[n].equals("-help") || stringArray[n].equals("-?") || stringArray[n].equals("-h")) {
                System.out.println("Usage: OverlapDetectionXSLTCompiler\n  [-help | -h | -?]          Prints this message\n  [-command commandfile]     Specifies a newline-delimited file with command line args\n  [-version | -showversion]  Prints the Xylem compiler version\n  [-xslt-version 1.0|2.0]    Specifies the version of XSLT to use\n  [-traceserialization]      Makes the translet insert diagnostic PIs into its output\n  [-dumpxylem]               Dumps out generated Xylem IL\n  [-traceimportsandincludes] Prints out the names/sizes of imported/included stylesheets\n  (input.xsl output.o)+      Compiles input.xsl into output.o\n");
                return -1;
            }
            if ("-command".equals(stringArray[n])) {
                if (n == stringArray.length) {
                    s_logger.error("-command missing parameter");
                    return -1;
                }
                if (!this.handleCommandOption(stringArray[++n])) {
                    return -1;
                }
                return n;
            }
            if (stringArray[n].equals("-xslt-version")) {
                if (++n == stringArray.length) {
                    s_logger.error("-xslt-version missing parameter");
                    return -1;
                }
                this.m_settings.setVersion(stringArray[n]);
                if (!stringArray[n].equals("1.0") && !stringArray[n].equals("2.0")) {
                    s_logger.error("invalid version: " + stringArray[n]);
                    return -1;
                }
                return n;
            }
            if (stringArray[n].equals("-version")) {
                System.out.println(RuntimeLibrary.verboseVersionWithCopyright());
                return -1;
            }
            if (stringArray[n].equals("-showversion")) {
                System.out.println(RuntimeLibrary.verboseVersionWithCopyright());
                return n;
            }
            if (stringArray[n].equals("-dumpxylem")) {
                this.m_dumpXylem = true;
                return n;
            }
            if (stringArray[n].equals("-traceserialization")) {
                this.m_settings.setSerializationTraceEnabled(true);
                return n;
            }
            if (stringArray[n].equals("-traceimportsandincludes")) {
                this.m_settings.setTraceImportsAndIncludes(true);
                return n;
            }
            if (n == stringArray.length) {
                s_logger.error("input filename " + stringArray[n - 1] + " missing corrsponding output filename");
                return -1;
            }
            this.m_inputFile = this.validateInputFilename(stringArray[n], false);
            if (this.m_inputFile == null) {
                return -1;
            }
            this.m_inputFiles.add(this.m_inputFile);
            this.m_outputFiles.add(new File(stringArray[++n]));
            return n;
        }
    }

    static class Record {
        FunctionSignature m_signature;
        int m_offset;
        int m_size;
        String m_originalName;
        boolean m_exported;

        Record(FunctionSignature functionSignature, int n, int n2, String string, boolean bl) {
            this.m_signature = functionSignature;
            this.m_offset = n;
            this.m_size = n2;
            this.m_originalName = string;
            this.m_exported = bl;
        }
    }
}

