/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.runtime;

import com.ibm.xtq.common.utils.Util;
import com.ibm.xtq.common.utils.XML11Char;
import com.ibm.xtq.common.utils.XMLChar;
import com.ibm.xtq.common.utils.XMLString;
import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.XDMNode;
import com.ibm.xtq.xml.xdm.ref.XDMUnionCursor;
import com.ibm.xtq.xslt.runtime.AbstractTranslet;
import com.ibm.xtq.xslt.runtime.Constants;
import com.ibm.xtq.xslt.runtime.Operators;
import com.ibm.xtq.xslt.runtime.RuntimeLibrary;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class BasisLibrary
extends Operators
implements Constants {
    public static final int NUM_OF_TYPES = 50;
    private static final String EMPTYSTRING = "";
    private static final double lowerBounds = 0.001;
    private static final double upperBounds = 1.0E7;
    private static final DecimalFormat defaultFormatter;
    private static final String defaultPattern = "";
    private static FieldPosition _fieldPosition;
    private static int prefixIndex;
    private static ResourceBundle m_bundle;
    public static final String ERROR_MESSAGES_KEY = "error-messages";

    public static int countF(XDMCursor xDMCursor) {
        return xDMCursor.getLength();
    }

    public static int positionF(XDMCursor xDMCursor) {
        return xDMCursor.getCurrentPos();
    }

    public static double sumF(XDMCursor xDMCursor) {
        try {
            double d = 0.0;
            if (!xDMCursor.isEmpty()) {
                do {
                    d += Double.parseDouble(xDMCursor.getStringValueX());
                } while (xDMCursor.nextNode());
            }
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public static String stringF(Object object) {
        if (object instanceof XDMCursor) {
            ((XDMCursor)object).resetIteration();
            return ((XDMCursor)object).isEmpty() ? "" : ((XDMCursor)object).getStringValueX();
        }
        if (object instanceof Double) {
            return RuntimeLibrary.doubleToString10((Double)object);
        }
        if (object instanceof Float) {
            return RuntimeLibrary.floatToString10(((Float)object).floatValue());
        }
        return object.toString();
    }

    public static String stringF(Object object, int n) {
        if (object instanceof XDMCursor) {
            ((XDMCursor)object).resetIteration();
            return ((XDMCursor)object).isEmpty() ? "" : ((XDMCursor)object).getStringValueX();
        }
        if (object instanceof Double) {
            int n2;
            Double d = (Double)object;
            String string = d.toString();
            if (string.charAt((n2 = string.length()) - 2) == '.' && string.charAt(n2 - 1) == '0') {
                return string.substring(0, n2 - 2);
            }
            return string;
        }
        return object.toString();
    }

    public static String stringF(Object object, XDMCursor xDMCursor) {
        if (object instanceof XDMCursor) {
            ((XDMCursor)object).resetIteration();
            return ((XDMCursor)object).isEmpty() ? "" : ((XDMCursor)object).getStringValueX();
        }
        if (object instanceof Double) {
            int n;
            Double d = (Double)object;
            String string = d.toString();
            if (string.charAt((n = string.length()) - 2) == '.' && string.charAt(n - 1) == '0') {
                return string.substring(0, n - 2);
            }
            return string;
        }
        if (object != null) {
            return object.toString();
        }
        return BasisLibrary.stringF(xDMCursor);
    }

    public static double numberF(Object object) {
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        if (object instanceof String) {
            return BasisLibrary.stringToReal((String)object);
        }
        if (object instanceof XDMCursor) {
            XDMCursor xDMCursor = (XDMCursor)object;
            return BasisLibrary.stringToReal(xDMCursor.getStringValueX());
        }
        String string = object.getClass().getName();
        BasisLibrary.runTimeError("INVALID_ARGUMENT_ERR", string, "number()");
        return 0.0;
    }

    public static String substringF(String string, double d) {
        int n = string.length();
        return BasisLibrary.substringF(string, d, (double)n - d + 1.0);
    }

    public static String substringF(String string, int n) {
        try {
            int n2 = string.length();
            int n3 = n - 1;
            if (n3 > n2) {
                return "";
            }
            if (n3 < 1) {
                n3 = 0;
            }
            return string.substring(n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            BasisLibrary.runTimeError("ERR_SYSTEM", "substring()");
            return null;
        }
    }

    public static String substringF(String string, double d, double d2) {
        try {
            int n = string.length();
            int n2 = (int)Math.round(d) - 1;
            int n3 = n2 + (int)Math.round(d2);
            if (Double.isInfinite(d2)) {
                n3 = Integer.MAX_VALUE;
            }
            if (Double.isNaN(d) || Double.isNaN(d2)) {
                return "";
            }
            if (Double.isInfinite(d)) {
                return "";
            }
            if (n2 > n) {
                return "";
            }
            if (n3 < 0) {
                return "";
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n3 > n) {
                return string.substring(n2);
            }
            return string.substring(n2, n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            BasisLibrary.runTimeError("ERR_SYSTEM", "substring()");
            return null;
        }
    }

    public static String substringF(String string, int n, int n2) {
        try {
            int n3 = n - 1;
            int n4 = n3 + n2;
            int n5 = string.length();
            if (n3 > n5) {
                return "";
            }
            if (n4 < 0) {
                return "";
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 > n5) {
                return string.substring(n3);
            }
            return string.substring(n3, n4);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            BasisLibrary.runTimeError("ERR_SYSTEM", "substring()");
            return null;
        }
    }

    public static String substring_afterF(String string, String string2) {
        int n = string.indexOf(string2);
        if (n >= 0) {
            return string.substring(n + string2.length());
        }
        return "";
    }

    public static String substring_beforeF(String string, String string2) {
        int n = string.indexOf(string2);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return "";
    }

    public static String translateF(String string, String string2, String string3) {
        if (null == string) {
            return "";
        }
        int n = string3.length();
        int n2 = string2.length();
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n3; ++i) {
            int n4;
            char c = string.charAt(i);
            for (n4 = 0; n4 < n2; ++n4) {
                if (c != string2.charAt(n4)) continue;
                if (n4 >= n) break;
                stringBuffer.append(string3.charAt(n4));
                break;
            }
            if (n4 != n2) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String normalize_spaceF(XDMCursor xDMCursor) {
        return BasisLibrary.normalize_spaceF(xDMCursor.getStringValueX());
    }

    public static String normalize_spaceF(String string) {
        int n;
        if (null == string) {
            return "";
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < n2 && BasisLibrary.isWhiteSpace(string.charAt(n)); ++n) {
        }
        while (true) {
            if (n < n2 && !BasisLibrary.isWhiteSpace(string.charAt(n))) {
                stringBuffer.append(string.charAt(n++));
                continue;
            }
            if (n == n2) break;
            while (n < n2 && BasisLibrary.isWhiteSpace(string.charAt(n))) {
                ++n;
            }
            if (n >= n2) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String generate_idF(XDMCursor xDMCursor, AbstractTranslet abstractTranslet) {
        if (xDMCursor == null || xDMCursor.isEmpty()) {
            return "";
        }
        return abstractTranslet.generate_id_support(xDMCursor);
    }

    public static XDMCursor idF(XDMCursor xDMCursor, Object object) {
        if (object instanceof XDMCursor) {
            XDMCursor xDMCursor2 = ((XDMCursor)object).cloneXDMCursor();
            XDMCursor xDMCursor3 = BasisLibrary.idF(xDMCursor, xDMCursor2.getStringValueX());
            while (xDMCursor2.nextNode()) {
                xDMCursor3 = new XDMUnionCursor(xDMCursor3, BasisLibrary.idF(xDMCursor, xDMCursor2.getStringValueX()));
            }
            return xDMCursor3;
        }
        if (object instanceof char[]) {
            return BasisLibrary.idF(xDMCursor, new String((char[])object));
        }
        if (object instanceof String) {
            int n;
            String string = (String)object;
            int n2 = 0;
            LinkedList<String> linkedList = new LinkedList<String>();
            for (int i = 0; i < string.length(); ++i) {
                n = string.charAt(i);
                switch (n) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        linkedList.add(string.substring(n2, i));
                        n2 = i + 1;
                    }
                }
            }
            if (n2 < string.length()) {
                linkedList.add(string.substring(n2));
            }
            XDMCursor xDMCursor4 = xDMCursor.getElementById((String)linkedList.get(0));
            for (n = 1; n < linkedList.size(); ++n) {
                xDMCursor4 = new XDMUnionCursor(xDMCursor4, xDMCursor.getElementById((String)linkedList.get(n)));
            }
            xDMCursor4.resetIteration();
            do {
                n = 0;
            } while (xDMCursor4.nextNode());
            xDMCursor4.resetIteration();
            return xDMCursor4;
        }
        BasisLibrary.runTimeError("ERR_SYSTEM", "Don't know how to do this kind of xpath id() function");
        return null;
    }

    public static char[] unparsed_entity_uriF(XDMCursor xDMCursor, char[] cArray) {
        String string;
        String string2;
        if (xDMCursor == null) {
            BasisLibrary.runTimeError("ERR_SYSTEM", "unparsed-entity-uri called with a bad cursor.");
        }
        if ((string2 = xDMCursor.getUnparsedEntityURI(string = new String(cArray))) == null) {
            return new String("").toCharArray();
        }
        return string2.toCharArray();
    }

    public static String getLocalName(String string) {
        int n = string.lastIndexOf(58);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(64)) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static void unresolved_externalF(String string) {
        BasisLibrary.runTimeError("EXTERNAL_FUNC_ERR", string);
    }

    public static void unsupported_ElementF(String string, boolean bl) {
        if (bl) {
            BasisLibrary.runTimeError("UNSUPPORTED_EXT_ERR", string);
        } else {
            BasisLibrary.runTimeError("UNSUPPORTED_XSL_ERR", string);
        }
    }

    public static void unsupported_functionF(String string) {
        BasisLibrary.runTimeError("UNSUPPORTED_FUNC_ERR", string);
    }

    public static String system_propertyF(String string) {
        if (string.equals("xsl:version")) {
            return "1.0";
        }
        if (string.equals("xsl:vendor")) {
            return "IBM Corporation";
        }
        if (string.equals("xsl:vendor-url")) {
            return "http://www.ibm.com/";
        }
        BasisLibrary.runTimeError("INVALID_ARGUMENT_ERR", string, "system-property()");
        return "";
    }

    public static String objectTypeF(Object object) {
        if (object instanceof String) {
            return "string";
        }
        if (object instanceof Boolean) {
            return "boolean";
        }
        if (object instanceof Number) {
            return "number";
        }
        if (object instanceof XDMCursor) {
            return "node-set";
        }
        return "unknown";
    }

    public static XDMCursor nodesetF(Object object) {
        if (object instanceof XDMCursor) {
            return (XDMCursor)object;
        }
        String string = object.getClass().getName();
        BasisLibrary.runTimeError("DATA_CONVERSION_ERR", "node-set", string);
        return null;
    }

    private static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    private static boolean compareStrings(String string, String string2, int n) {
        switch (n) {
            case 0: {
                return string.equals(string2);
            }
            case 1: {
                return !string.equals(string2);
            }
            case 2: {
                return BasisLibrary.stringToReal(string) > BasisLibrary.stringToReal(string2);
            }
            case 3: {
                return BasisLibrary.stringToReal(string) < BasisLibrary.stringToReal(string2);
            }
            case 4: {
                return BasisLibrary.stringToReal(string) >= BasisLibrary.stringToReal(string2);
            }
            case 5: {
                return BasisLibrary.stringToReal(string) <= BasisLibrary.stringToReal(string2);
            }
        }
        BasisLibrary.runTimeError("ERR_SYSTEM", "compare()");
        return false;
    }

    public static boolean compare(XDMCursor xDMCursor, XDMCursor xDMCursor2, int n) {
        if (xDMCursor.isEmpty() || xDMCursor2.isEmpty()) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            String string = xDMCursor2.getStringValueX();
            arrayList.add(string);
        } while (xDMCursor2.nextNode());
        int n2 = arrayList.size();
        do {
            String string = xDMCursor.getStringValueX();
            for (int i = n2 - 1; i >= 0; --i) {
                if (!BasisLibrary.compareStrings(string, (String)arrayList.get(i), n)) continue;
                return true;
            }
        } while (xDMCursor.nextNode());
        return false;
    }

    public static boolean nodesetContainsNode(XDMCursor xDMCursor, XDMNode xDMNode) {
        if (xDMCursor.isEmpty()) {
            return false;
        }
        do {
            if (!xDMNode.isSameNode(xDMCursor)) continue;
            return true;
        } while (xDMCursor.nextNode());
        xDMCursor.resetIteration();
        return false;
    }

    public static boolean compare(XDMNode xDMNode, XDMCursor xDMCursor, int n) {
        switch (n) {
            case 0: {
                if (xDMCursor.isEmpty()) break;
                String string = xDMNode.getStringValueX();
                do {
                    if (!xDMNode.isSameNode(xDMCursor) && !string.equals(xDMCursor.getStringValue())) continue;
                    return true;
                } while (xDMCursor.nextNode());
                break;
            }
            case 1: {
                if (xDMCursor.isEmpty()) break;
                String string = xDMNode.getStringValueX();
                do {
                    if (xDMNode.isSameNode(xDMCursor) || string.equals(xDMCursor.getStringValueX())) continue;
                    return true;
                } while (xDMCursor.nextNode());
                break;
            }
            case 3: {
                if (xDMCursor.isEmpty()) break;
                do {
                    if (xDMCursor.relativeDocOrder(xDMNode) <= 0) continue;
                    return true;
                } while (xDMCursor.nextNode());
                break;
            }
            case 2: {
                if (xDMCursor.isEmpty()) break;
                do {
                    if (xDMCursor.relativeDocOrder(xDMNode) >= 0) continue;
                    return true;
                } while (xDMCursor.nextNode());
            }
        }
        return false;
    }

    public static boolean compare(XDMCursor xDMCursor, double d, int n) {
        switch (n) {
            case 0: {
                if (xDMCursor.isEmpty()) break;
                do {
                    if (BasisLibrary.numberF(xDMCursor.getStringValueX()) != d) continue;
                    return true;
                } while (xDMCursor.nextNode());
                break;
            }
            case 1: {
                if (xDMCursor.isEmpty()) break;
                do {
                    if (BasisLibrary.numberF(xDMCursor.getStringValueX()) == d) continue;
                    return true;
                } while (xDMCursor.nextNode());
                break;
            }
            case 2: {
                if (xDMCursor.isEmpty()) break;
                do {
                    if (!(BasisLibrary.numberF(xDMCursor.getStringValueX()) > d)) continue;
                    return true;
                } while (xDMCursor.nextNode());
                break;
            }
            case 3: {
                if (xDMCursor.isEmpty()) break;
                do {
                    if (!(BasisLibrary.numberF(xDMCursor.getStringValueX()) < d)) continue;
                    return true;
                } while (xDMCursor.nextNode());
                break;
            }
            case 4: {
                if (xDMCursor.isEmpty()) break;
                do {
                    if (!(BasisLibrary.numberF(xDMCursor.getStringValueX()) >= d)) continue;
                    return true;
                } while (xDMCursor.nextNode());
                break;
            }
            case 5: {
                if (xDMCursor.isEmpty()) break;
                do {
                    if (!(BasisLibrary.numberF(xDMCursor.getStringValueX()) <= d)) continue;
                    return true;
                } while (xDMCursor.nextNode());
                break;
            }
            default: {
                BasisLibrary.runTimeError("ERR_SYSTEM", "compare()");
            }
        }
        return false;
    }

    public static boolean compare(XDMCursor xDMCursor, String string, int n) {
        switch (n) {
            case 0: {
                if (xDMCursor.isEmpty()) break;
                do {
                    String string2;
                    if (!(string2 = xDMCursor.getStringValueX()).equals(string)) continue;
                    return true;
                } while (xDMCursor.nextNode());
                break;
            }
            case 1: {
                if (xDMCursor.isEmpty()) break;
                do {
                    String string3;
                    if ((string3 = xDMCursor.getStringValueX()).equals(string)) continue;
                    return true;
                } while (xDMCursor.nextNode());
                break;
            }
            case 2: {
                if (xDMCursor.isEmpty()) break;
                do {
                    String string4;
                    if (!(BasisLibrary.numberF(string4 = xDMCursor.getStringValueX()) > BasisLibrary.numberF(string))) continue;
                    return true;
                } while (xDMCursor.nextNode());
                break;
            }
            case 3: {
                if (xDMCursor.isEmpty()) break;
                do {
                    String string5;
                    if (!(BasisLibrary.numberF(string5 = xDMCursor.getStringValueX()) < BasisLibrary.numberF(string))) continue;
                    return true;
                } while (xDMCursor.nextNode());
                break;
            }
            case 4: {
                if (xDMCursor.isEmpty()) break;
                do {
                    String string6;
                    if (!(BasisLibrary.numberF(string6 = xDMCursor.getStringValueX()) >= BasisLibrary.numberF(string))) continue;
                    return true;
                } while (xDMCursor.nextNode());
                break;
            }
            case 5: {
                if (xDMCursor.isEmpty()) break;
                do {
                    String string7;
                    if (!(BasisLibrary.numberF(string7 = xDMCursor.getStringValueX()) <= BasisLibrary.numberF(string))) continue;
                    return true;
                } while (xDMCursor.nextNode());
                break;
            }
            default: {
                BasisLibrary.runTimeError("ERR_SYSTEM", "compare()");
            }
        }
        return false;
    }

    public static boolean compare(Object object, Object object2, int n) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = bl = BasisLibrary.hasSimpleType(object) && BasisLibrary.hasSimpleType(object2);
        if (n != 0 && n != 1 && bl) {
            switch (n) {
                case 2: {
                    return BasisLibrary.numberF(object) > BasisLibrary.numberF(object2);
                }
                case 3: {
                    return BasisLibrary.numberF(object) < BasisLibrary.numberF(object2);
                }
                case 4: {
                    return BasisLibrary.numberF(object) >= BasisLibrary.numberF(object2);
                }
                case 5: {
                    return BasisLibrary.numberF(object) <= BasisLibrary.numberF(object2);
                }
            }
            BasisLibrary.runTimeError("ERR_SYSTEM", "compare()");
        }
        if (bl) {
            bl2 = object instanceof Boolean || object2 instanceof Boolean ? BasisLibrary.booleanF(object) == BasisLibrary.booleanF(object2) : (object instanceof Double || object2 instanceof Double || object instanceof Integer || object2 instanceof Integer ? BasisLibrary.numberF(object) == BasisLibrary.numberF(object2) : BasisLibrary.stringF(object).equals(BasisLibrary.stringF(object2)));
            if (n == 1) {
                bl2 = !bl2;
            }
        } else {
            Object object3;
            if (BasisLibrary.hasSimpleType(object) && object2 instanceof XDMCursor) {
                object3 = object2;
                object2 = object;
                object = object3;
                n = BasisLibrary.getReverseOp(n);
            }
            object3 = (XDMCursor)object;
            object3.resetIteration();
            if (object2 instanceof XDMCursor) {
                bl2 = BasisLibrary.compare((XDMCursor)object3, (XDMCursor)object2, n);
            } else if (object2 instanceof String) {
                bl2 = BasisLibrary.compare((XDMCursor)object3, (String)object2, n);
            } else if (object2 instanceof Number) {
                double d = ((Number)object2).doubleValue();
                bl2 = BasisLibrary.compare((XDMCursor)object3, d, n);
            } else if (object2 instanceof Boolean) {
                boolean bl4 = (Boolean)object2;
                bl2 = object3.nextNode() == bl4;
            } else {
                if (object2 == null) {
                    return false;
                }
                String string = object2.getClass().getName();
                BasisLibrary.runTimeError("INVALID_ARGUMENT_ERR", string, "compare()");
            }
        }
        return bl2;
    }

    public static boolean testLanguage(String string, XDMCursor xDMCursor) {
        String string2 = BasisLibrary.getLanguage(xDMCursor);
        if (string2 == null) {
            return false;
        }
        string2 = string2.toLowerCase();
        if ((string = string.toLowerCase()).length() == 2) {
            return string2.startsWith(string);
        }
        return string2.equals(string);
    }

    public static String getLanguage(XDMCursor xDMCursor) {
        XDMCursor xDMCursor2 = xDMCursor.getTypedAxisCursor(2, xDMCursor.getExpandedTypeID("http://www.w3.org/XML/1998/namespace", "lang", 2));
        if (!xDMCursor2.isEmpty()) {
            return xDMCursor2.getStringValueX();
        }
        XDMCursor xDMCursor3 = xDMCursor.getAxisCursor(0);
        if (!xDMCursor3.isEmpty()) {
            do {
                if ((xDMCursor2 = xDMCursor2.newContext(xDMCursor3)).isEmpty()) continue;
                return xDMCursor2.getStringValueX();
            } while (xDMCursor3.nextNode());
        }
        return null;
    }

    private static boolean hasSimpleType(Object object) {
        return object instanceof Boolean || object instanceof Double || object instanceof Integer || object instanceof String;
    }

    public static double stringToReal(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public static int stringToInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static int stringToInt(XMLString xMLString) {
        try {
            return Integer.parseInt(((Object)xMLString).toString());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static String realToString(double d) {
        double d2 = Math.abs(d);
        if (d2 >= 0.001 && d2 < 1.0E7) {
            int n;
            String string = Double.toString(d);
            if (string.charAt((n = string.length()) - 2) == '.' && string.charAt(n - 1) == '0') {
                return string.substring(0, n - 2);
            }
            if (string.indexOf(46) != 0 && string.indexOf(69) < 0 && string.charAt(n - 1) == '0') {
                return string.substring(0, n - 1);
            }
            return string;
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return Double.toString(d);
        }
        if (d == 0.0) {
            return "0";
        }
        return BasisLibrary.formatNumber(d, "", defaultFormatter);
    }

    public static int realToInt(double d) {
        return (int)d;
    }

    public static String formatNumber(double d, String string, DecimalFormat decimalFormat) {
        if (decimalFormat == null) {
            decimalFormat = defaultFormatter;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = decimalFormat.toPattern();
            int n = string2.indexOf(46);
            if (n >= 1 && string2.charAt(n - 1) == '#') {
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(string2.substring(0, n - 1));
                stringBuffer2.append("0");
                stringBuffer2.append(string2.substring(n));
                decimalFormat.applyLocalizedPattern(stringBuffer2.toString());
            } else if (n == 0) {
                StringBuffer stringBuffer3 = new StringBuffer();
                stringBuffer3.append("0");
                stringBuffer3.append(string2);
                decimalFormat.applyLocalizedPattern(stringBuffer3.toString());
            }
            decimalFormat.format(d, stringBuffer, _fieldPosition);
            return stringBuffer.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BasisLibrary.runTimeError("FORMAT_NUMBER_ERR", Double.toString(d), string);
            return "";
        }
    }

    private static void copyNodes(NodeList nodeList, Document document, Node node) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            short s = node2.getNodeType();
            String string = null;
            try {
                string = node2.getNodeValue();
            }
            catch (DOMException dOMException) {
                BasisLibrary.runTimeError("ERR_SYSTEM", dOMException.getMessage());
                return;
            }
            String string2 = node2.getNodeName();
            Node node3 = null;
            switch (s) {
                case 2: {
                    node3 = document.createAttributeNS(node2.getNamespaceURI(), string2);
                    break;
                }
                case 4: {
                    node3 = document.createCDATASection(string);
                    break;
                }
                case 8: {
                    node3 = document.createComment(string);
                    break;
                }
                case 11: {
                    node3 = document.createDocumentFragment();
                    break;
                }
                case 9: {
                    node3 = document.createElementNS(null, "__document__");
                    BasisLibrary.copyNodes(node2.getChildNodes(), document, node3);
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    Element element = document.createElementNS(node2.getNamespaceURI(), string2);
                    if (node2.hasAttributes()) {
                        NamedNodeMap namedNodeMap = node2.getAttributes();
                        for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                            Node node4 = namedNodeMap.item(j);
                            element.setAttributeNS(node4.getNamespaceURI(), node4.getNodeName(), node4.getNodeValue());
                        }
                    }
                    BasisLibrary.copyNodes(node2.getChildNodes(), document, element);
                    node3 = element;
                    break;
                }
                case 6: {
                    break;
                }
                case 5: {
                    node3 = document.createEntityReference(string2);
                    break;
                }
                case 12: {
                    break;
                }
                case 7: {
                    node3 = document.createProcessingInstruction(string2, string);
                    break;
                }
                case 3: {
                    node3 = document.createTextNode(string);
                }
            }
            try {
                node.appendChild(node3);
                continue;
            }
            catch (DOMException dOMException) {
                BasisLibrary.runTimeError("ERR_SYSTEM", dOMException.getMessage());
                return;
            }
        }
    }

    public static XDMCursor getSingleNode(XDMCursor xDMCursor) {
        return xDMCursor.singleNode();
    }

    public static void checkAttribQName(String string) {
        int n = string.indexOf(":");
        int n2 = string.lastIndexOf(":");
        String string2 = string.substring(n2 + 1);
        if (n > 0) {
            String string3;
            String string4 = string.substring(0, n);
            if (n != n2 && !XMLChar.isValidNCName(string3 = string.substring(n + 1, n2))) {
                BasisLibrary.runTimeError("INVALID_QNAME_ERR", string3 + ":" + string2);
            }
            if (!XMLChar.isValidNCName(string4)) {
                BasisLibrary.runTimeError("INVALID_QNAME_ERR", string4 + ":" + string2);
            }
        }
        if (!XMLChar.isValidNCName(string2) || string2.equals("xmlns")) {
            BasisLibrary.runTimeError("INVALID_QNAME_ERR", string2);
        }
    }

    public static void checkNCName(String string) {
        if (!XMLChar.isValidNCName(string)) {
            BasisLibrary.runTimeError("INVALID_NCNAME_ERR", string);
        }
    }

    public static void checkQName(String string) {
        if (!XMLChar.isValidQName(string)) {
            BasisLibrary.runTimeError("INVALID_QNAME_ERR", string);
        }
    }

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        return n > 0 ? string.substring(0, n) : null;
    }

    public static String generatePrefix() {
        return "ns" + prefixIndex++;
    }

    public static void runTimeError(String string) {
        throw new RuntimeException(m_bundle.getString(string));
    }

    public static void runTimeError(String string, Object[] objectArray) {
        String string2 = MessageFormat.format(m_bundle.getString(string), objectArray);
        throw new RuntimeException(string2);
    }

    public static void runTimeError(String string, Object object) {
        BasisLibrary.runTimeError(string, new Object[]{object});
    }

    public static void runTimeError(String string, Object object, Object object2) {
        BasisLibrary.runTimeError(string, new Object[]{object, object2});
    }

    public static void consoleOutput(String string) {
        System.out.println(string);
    }

    public static String replace(String string, char c, String string2) {
        return string.indexOf(c) < 0 ? string : BasisLibrary.replace(string, String.valueOf(c), new String[]{string2});
    }

    public static String replace(String string, String string2, String[] stringArray) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            int n2 = string2.indexOf(c);
            if (n2 >= 0) {
                stringBuffer.append(stringArray[n2]);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String qnameToString(QName qName) {
        return Util.getStringRep(qName);
    }

    private static String getBaseFromURI(String string) {
        int n = string.lastIndexOf(92) + 1;
        int n2 = string.lastIndexOf(47) + 1;
        return string.substring(0, Math.max(n, n2));
    }

    public static double roundF(double d) {
        return d < -0.5 || d > 0.0 ? Math.floor(d + 0.5) : (d == 0.0 ? d : (Double.isNaN(d) ? Double.NaN : -0.0));
    }

    public static boolean booleanF(Object object) {
        if (object instanceof Double) {
            double d = (Double)object;
            return d != 0.0 && !Double.isNaN(d);
        }
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue() != 0.0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return !((String)object).equals("");
        }
        if (object instanceof XDMCursor) {
            XDMCursor xDMCursor = (XDMCursor)object;
            return !xDMCursor.isEmpty();
        }
        String string = object.getClass().getName();
        BasisLibrary.runTimeError("INVALID_ARGUMENT_ERR", string, "number()");
        return false;
    }

    public static QName validateQNameF(char[] cArray, boolean bl, boolean bl2, Hashtable hashtable) {
        String string;
        int n = -1;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != ':') continue;
            n = i;
            break;
        }
        String string2 = n < 0 ? "" : String.valueOf(cArray, 0, n);
        String string3 = string = n == cArray.length ? "" : String.valueOf(cArray, n + 1, cArray.length - (n + 1));
        if (bl) {
            if (n == -1 || !XMLChar.isValidNCName(string2) || !XMLChar.isValidNCName(string)) {
                BasisLibrary.runTimeError("INVALID_QNAME_BUT_NOT_NCNAME_ERR", new String(cArray));
            }
        } else if (n >= 0 && !XMLChar.isValidNCName(string2) || !XMLChar.isValidNCName(string)) {
            BasisLibrary.runTimeError("INVALID_QNAME_ERR", new String(cArray));
        }
        String string4 = "";
        if (string2.length() == 0) {
            if (bl2 && (string4 = (String)hashtable.get(string2)) == null) {
                string4 = "";
            }
        } else {
            string4 = (String)hashtable.get(string2);
            if (string4 == null) {
                BasisLibrary.runTimeError("UNRESOLVED_PREFIX_ERR", string2);
            }
        }
        return new QName(string4, string, string2);
    }

    public static QName validateXML11QNameF(char[] cArray, boolean bl, boolean bl2, Hashtable hashtable) {
        String string;
        int n = -1;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != ':') continue;
            n = i;
            break;
        }
        String string2 = n < 0 ? "" : String.valueOf(cArray, 0, n);
        String string3 = string = n == cArray.length ? "" : String.valueOf(cArray, n + 1, cArray.length - (n + 1));
        if (bl) {
            if (n == -1 || !XML11Char.isXML11ValidNCName(string2) || !XML11Char.isXML11ValidNCName(string)) {
                BasisLibrary.runTimeError("INVALID_QNAME_BUT_NOT_NCNAME_ERR", new String(cArray));
            }
        } else if (n >= 0 && !XML11Char.isXML11ValidNCName(string2) || !XML11Char.isXML11ValidNCName(string)) {
            BasisLibrary.runTimeError("INVALID_QNAME_ERR", new String(cArray));
        }
        String string4 = "";
        if (string2.length() == 0) {
            if (bl2 && (string4 = (String)hashtable.get(string2)) == null) {
                string4 = "";
            }
        } else {
            string4 = (String)hashtable.get(string2);
            if (string4 == null) {
                BasisLibrary.runTimeError("UNRESOLVED_PREFIX_ERR", string2);
            }
        }
        return new QName(string4, string, string2);
    }

    public static final QName construct_QNameF(char[] cArray, char[] cArray2) {
        String string = String.valueOf(cArray);
        String string2 = String.valueOf(cArray2);
        String string3 = "";
        int n = string2.indexOf(":");
        if (n != -1) {
            string3 = string2.substring(0, n);
        }
        String string4 = string2.substring(n + 1);
        return new QName(string, string4, string3);
    }

    public static final char[] getLocalCurrency() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        String string = decimalFormatSymbols.getCurrencySymbol();
        char[] cArray = string.toCharArray();
        return cArray;
    }

    public static final boolean prefixResolveF(char[] cArray, Hashtable hashtable) {
        String string;
        String string2;
        int n = -1;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != ':') continue;
            n = i;
            break;
        }
        String string3 = string2 = n < 0 ? "" : String.valueOf(cArray, 0, n);
        return string2.length() == 0 || (string = (String)hashtable.get(string2)) != null;
    }

    public static final boolean elementAvailableF(char[] cArray, char[] cArray2, HashMap hashMap) {
        String string = String.valueOf(cArray);
        String string2 = String.valueOf(cArray2);
        String string3 = "{" + string + "}" + string2;
        Object v = hashMap.get(string3);
        return v != null;
    }

    public static final boolean functionAvailableF(char[] cArray, char[] cArray2, HashMap hashMap) {
        Object v;
        String string = String.valueOf(cArray);
        String string2 = String.valueOf(cArray2);
        if (string != null && string.length() != 0) {
            string2 = string + ":" + string2;
        }
        return (v = hashMap.get(string2)) != null;
    }

    static {
        Object object = NumberFormat.getInstance(Locale.getDefault());
        ((NumberFormat)object).setMaximumFractionDigits(1000);
        defaultFormatter = object instanceof DecimalFormat ? (DecimalFormat)object : new DecimalFormat();
        defaultFormatter.setGroupingUsed(false);
        _fieldPosition = new FieldPosition(0);
        prefixIndex = 0;
        object = "com.ibm.xtq.xslt.runtime.res.RuntimeMessages";
        m_bundle = ResourceBundle.getBundle((String)object);
    }
}

