/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xdm.ref;

import com.ibm.xtq.common.utils.ObjectVector;
import com.ibm.xtq.xml.xdm.Axis;
import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.XDMException;
import com.ibm.xtq.xml.xdm.ref.XDMCursorProxyCursor;
import com.ibm.xtq.xml.xdm.res.XMLMessages;

public class XDMDupFilterCursor
extends XDMCursorProxyCursor {
    private ObjectVector _nodes = new ObjectVector();
    int m_length = -1;
    private int _nodesSize = 0;
    private XDMCursor _lastNext = null;
    private XDMCursor m_source;
    protected int m_position;

    public XDMDupFilterCursor(XDMCursor xDMCursor) {
        super(xDMCursor);
        this.m_source = xDMCursor;
        this.init();
    }

    public void setRestartable(boolean bl) {
    }

    public void init() {
        this._nodes.removeAllElements();
        if (!this.m_source.isEmpty()) {
            this.m_currentCursor = this.m_source.cloneXDMCursor();
            do {
                this._nodes.addElement(this.m_currentCursor.singleNode());
            } while (this.m_currentCursor.nextNode());
        }
        this._nodesSize = this._nodes.size();
        if (this._nodesSize > 0) {
            if (!this.m_currentCursor.isDocOrdered()) {
                this.quicksort(0, this._nodesSize - 1);
            }
            this.m_position = 0;
            this._lastNext = this.m_currentCursor = (XDMCursor)this._nodes.elementAt(this.m_position);
        }
    }

    @Override
    public boolean nextNode() {
        while (this.m_position < this._nodesSize - 1) {
            XDMCursor xDMCursor = (XDMCursor)this._nodes.elementAt(++this.m_position);
            if (this._lastNext != null && xDMCursor.isSameNode(this._lastNext)) continue;
            this._lastNext = xDMCursor;
            this.m_currentCursor = xDMCursor;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this._nodes == null || this._nodesSize == 0;
    }

    @Override
    public void resetIteration() {
        this.m_position = 0;
        this._lastNext = this.m_currentCursor = (XDMCursor)this._nodes.elementAt(this.m_position);
    }

    @Override
    public int getLength() {
        if (this.m_length < 0) {
            this.m_length = 0;
            if (!this.isEmpty()) {
                XDMCursor xDMCursor = this.cloneWithReset();
                do {
                    ++this.m_length;
                } while (xDMCursor.nextNode());
            }
        }
        return this.m_length;
    }

    @Override
    public int getCurrentPos() {
        return this.m_position;
    }

    @Override
    public boolean setCurrentPos(int n) {
        if (n <= this.m_position) {
            return true;
        }
        if (n < this.getLength()) {
            while (this.m_position <= n) {
                this.nextNode();
            }
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        XDMDupFilterCursor xDMDupFilterCursor = (XDMDupFilterCursor)super.clone();
        xDMDupFilterCursor.m_source = this.m_source.cloneXDMCursor();
        try {
            xDMDupFilterCursor._nodes = (ObjectVector)this._nodes.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "ObjectVector.clone() failed. This should never arise."));
        }
        return xDMDupFilterCursor;
    }

    @Override
    public XDMCursor cloneWithReset() {
        XDMCursor xDMCursor = (XDMCursor)this.clone();
        xDMCursor.resetIteration();
        return xDMCursor;
    }

    @Override
    public XDMCursor cloneXDMCursor() {
        return (XDMCursor)this.clone();
    }

    @Override
    public XDMCursor newContext(XDMCursor xDMCursor, Object object, boolean bl) {
        if (!bl) {
            this.m_source = this.m_currentCursor = this.m_source.newContext(xDMCursor, object, false);
            this.m_length = -1;
            this.m_position = 0;
            this.init();
            return this;
        }
        return new XDMDupFilterCursor(this.m_source.newContext(xDMCursor, object, true));
    }

    @Override
    public XDMCursor getTypedAxisCursor(int n, int n2) {
        if (this.m_source == null) {
            throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "The iterator for axis " + Axis.getName(n) + " is not implemented."));
        }
        return this.m_currentCursor.getTypedAxisCursor(n, n2);
    }

    @Override
    public XDMCursor getAxisCursor(int n) {
        if (this.m_source == null) {
            throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "The iterator for axis " + Axis.getName(n) + " is not implemented."));
        }
        return this.m_currentCursor.getAxisCursor(n);
    }

    @Override
    public XDMCursor singleNode() {
        return this.m_currentCursor;
    }

    private void quicksort(int n, int n2) {
        while (n < n2) {
            int n3 = this.partition(n, n2);
            this.quicksort(n, n3);
            n = n3 + 1;
        }
    }

    private int partition(int n, int n2) {
        XDMCursor xDMCursor = (XDMCursor)this._nodes.elementAt(n + n2 >>> 1);
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if (xDMCursor.relativeDocOrder((XDMCursor)this._nodes.elementAt(--n4)) < 0) {
                continue;
            }
            while (xDMCursor.relativeDocOrder((XDMCursor)this._nodes.elementAt(++n3)) > 0) {
            }
            if (n3 >= n4) break;
            XDMCursor xDMCursor2 = (XDMCursor)this._nodes.elementAt(n3);
            this._nodes.setElementAt(this._nodes.elementAt(n4), n3);
            this._nodes.setElementAt(xDMCursor2, n4);
        }
        return n4;
    }
}

