/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.CastLibrary;
import com.ibm.xtq.xml.datamodel.DateTimeBase;
import com.ibm.xtq.xml.datamodel.DynamicError;
import com.ibm.xtq.xml.datamodel.XDataTypeUtils;
import com.ibm.xtq.xml.datamodel.XDateTime;
import com.ibm.xtq.xml.datamodel.XDayTimeDuration;
import com.ibm.xtq.xml.datamodel.XGDay;
import com.ibm.xtq.xml.datamodel.XGMonth;
import com.ibm.xtq.xml.datamodel.XGMonthDay;
import com.ibm.xtq.xml.datamodel.XGYear;
import com.ibm.xtq.xml.datamodel.XGYearMonth;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.datamodel.XYearMonthDuration;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeError;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.DateDV;
import org.apache.xerces.impl.dv.xs.TypeValidator;

public class XDate
extends XItemBase {
    private static TypeValidator m_validator = new DateDV();
    private final XDayTimeDuration ZERO_DTD = new XDayTimeDuration(0, 0, 0, 0.0);
    private int m_year;
    private int m_month;
    private int m_day;
    private XDayTimeDuration m_timezone;

    protected XDate(DateTimeBase dateTimeBase) {
        this(dateTimeBase.getYear(), dateTimeBase.getMonth(), dateTimeBase.getDay(), null, Type.DATE);
    }

    public XDate(int n, int n2, int n3) {
        this(n, n2, n3, null, Type.DATE);
    }

    public XDate(int n, int n2, int n3, ItemType itemType) {
        this(n, n2, n3, null, itemType);
    }

    public XDate(int n, int n2, int n3, XDayTimeDuration xDayTimeDuration) {
        this(n, n2, n3, xDayTimeDuration, Type.DATE);
    }

    public XDate(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, new XDayTimeDuration(0, n4, n5, 0.0), Type.DATE);
    }

    public XDate(int n, int n2, int n3, XDayTimeDuration xDayTimeDuration, ItemType itemType) {
        this.m_year = n;
        this.m_month = n2;
        this.m_day = n3;
        this.m_timezone = xDayTimeDuration;
        this.m_type = itemType;
    }

    @Override
    public int getPrimitiveId() {
        return 11;
    }

    public static XDate parse(String string) {
        try {
            return new XDate((DateTimeBase)m_validator.getActualValue(string, null));
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new DynamicError(invalidDatatypeValueException.toString());
        }
    }

    public XDateTime normalize() {
        if (this.m_timezone != null && !this.m_timezone.equals(this.ZERO_DTD)) {
            XDateTime xDateTime = new XDateTime(this.getYear(), this.getMonth(), this.getDay(), 0, 0, 0.0, 0, 0);
            return xDateTime.subtract(this.m_timezone);
        }
        return new XDateTime(this.getYear(), this.getMonth(), this.getDay(), 0, 0, 0.0);
    }

    public int getYear() {
        return this.m_year;
    }

    public int getMonth() {
        return this.m_month;
    }

    public int getDay() {
        return this.m_day;
    }

    public XDayTimeDuration getTimeZone() {
        return this.m_timezone;
    }

    public int getTimeZoneHour() {
        return this.m_timezone != null ? this.m_timezone.getHours() : Integer.MAX_VALUE;
    }

    public int getTimeZoneMinute() {
        return this.m_timezone != null ? this.m_timezone.getMinutes() : Integer.MAX_VALUE;
    }

    @Override
    public XDate toDate() {
        return this;
    }

    public XDateTime toDateTime() {
        return new XDateTime(this.m_year, this.m_month, this.m_day, 0, 0, 0.0, this.m_timezone);
    }

    @Override
    public XGDay toGDay() {
        String string = CastLibrary.convertTo2CharString(this.m_day);
        String string2 = CastLibrary.convertTZtoString(this.m_timezone);
        return XGDay.parse("---" + string + string2);
    }

    @Override
    public XGMonth toGMonth() {
        String string = CastLibrary.convertTo2CharString(this.m_month);
        String string2 = CastLibrary.convertTZtoString(this.m_timezone);
        return XGMonth.parse("--" + string + string2);
    }

    @Override
    public XGMonthDay toGMonthDay() {
        String string = CastLibrary.convertTo2CharString(this.m_month);
        String string2 = CastLibrary.convertTo2CharString(this.m_day);
        String string3 = CastLibrary.convertTZtoString(this.m_timezone);
        return XGMonthDay.parse("--" + string + "-" + string2 + string3);
    }

    @Override
    public XGYear toGYear() {
        String string = CastLibrary.convertYearToString(this.m_year);
        String string2 = CastLibrary.convertTZtoString(this.m_timezone);
        return XGYear.parse(string + string2);
    }

    @Override
    public XGYearMonth toGYearMonth() {
        String string = CastLibrary.convertYearToString(this.m_year);
        String string2 = CastLibrary.convertTo2CharString(this.m_month);
        String string3 = CastLibrary.convertTZtoString(this.m_timezone);
        return XGYearMonth.parse(string + "-" + string2 + string3);
    }

    @Override
    public String toString() {
        return CastLibrary.composeDateStrRep(this.m_year, this.m_month, this.m_day, this.m_timezone);
    }

    @Override
    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    public XDate add(XYearMonthDuration xYearMonthDuration) {
        int n = this.m_month + xYearMonthDuration.getMonths();
        int n2 = (int)XDataTypeUtils.modulo((double)n, 1, 13);
        int n3 = XDataTypeUtils.fQuotient(n, 1, 13);
        int n4 = this.m_year + xYearMonthDuration.getYears() + n3;
        int n5 = this.m_day;
        n5 = XDataTypeUtils.normalizeDay(n5, n2, n4);
        int[] nArray = new int[3];
        nArray = XDataTypeUtils.normalizeDate(n5, n2, n4);
        return new XDate(nArray[2], nArray[1], nArray[0], this.m_timezone);
    }

    public XDate add(XDayTimeDuration xDayTimeDuration) {
        int n = XDataTypeUtils.normalizeDay(this.m_day, this.m_month, this.m_year);
        n += xDayTimeDuration.getDays();
        if (xDayTimeDuration.getHours() < 0 || xDayTimeDuration.getMinutes() < 0 || xDayTimeDuration.getSeconds() < 0.0) {
            --n;
        }
        int[] nArray = new int[3];
        nArray = XDataTypeUtils.normalizeDate(n, this.m_month, this.m_year);
        return new XDate(nArray[2], nArray[1], nArray[0], this.m_timezone);
    }

    @Override
    public XItem add(XItem xItem) {
        switch (xItem.getPrimitiveId()) {
            case 7: {
                return this.add(xItem.toYearMonthDuration());
            }
            case 8: {
                return this.add(xItem.toDayTimeDuration());
            }
        }
        throw new TypeError();
    }

    public XDayTimeDuration subtract(XDate xDate) {
        XDateTime xDateTime = this.normalize();
        XDateTime xDateTime2 = xDate.normalize();
        return xDateTime.subtract(xDateTime2);
    }

    public XDate subtract(XYearMonthDuration xYearMonthDuration) {
        return this.add(XDataTypeUtils.negate(xYearMonthDuration));
    }

    public XDate subtract(XDayTimeDuration xDayTimeDuration) {
        return this.add(XDataTypeUtils.negate(xDayTimeDuration));
    }

    @Override
    public XItem subtract(XItem xItem) {
        switch (xItem.getPrimitiveId()) {
            case 11: {
                return this.subtract(xItem.toDate());
            }
            case 7: {
                return this.subtract(xItem.toYearMonthDuration());
            }
            case 8: {
                return this.subtract(xItem.toDayTimeDuration());
            }
        }
        throw new TypeError();
    }

    @Override
    public final int compareTo(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 11: {
                return this.compareTo(xItem.toDate());
            }
        }
        throw new TypeError();
    }

    public final int compareTo(XDate xDate) throws TypeError {
        int n = XDataTypeUtils.numberOfDays(this.m_day, this.m_month, this.m_year) - XDataTypeUtils.numberOfDays(xDate.getDay(), xDate.getMonth(), xDate.getYear());
        return XItemBase.FormatCompareOut(n);
    }

    public final boolean equals(XDate xDate) throws TypeError {
        return this.compareTo(xDate) == 0;
    }

    public final boolean notEquals(XDate xDate) throws TypeError {
        return !this.equals(xDate);
    }

    public final boolean greaterThan(XDate xDate) throws TypeError {
        return this.compareTo(xDate) > 0;
    }

    public final boolean greaterOrEquals(XDate xDate) throws TypeError {
        return this.compareTo(xDate) >= 0;
    }

    public final boolean lessThan(XDate xDate) throws TypeError {
        return this.compareTo(xDate) < 0;
    }

    public final boolean lessOrEquals(XDate xDate) throws TypeError {
        return this.compareTo(xDate) <= 0;
    }
}

