/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.bcel.generic;

import com.ibm.xtq.bcel.Constants;
import com.ibm.xtq.bcel.ExceptionConstants;
import com.ibm.xtq.bcel.generic.AllocationInstruction;
import com.ibm.xtq.bcel.generic.ArrayType;
import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.ExceptionThrower;
import com.ibm.xtq.bcel.generic.Instruction;
import com.ibm.xtq.bcel.generic.StackProducer;
import com.ibm.xtq.bcel.generic.Type;
import com.ibm.xtq.bcel.generic.Visitor;
import com.ibm.xtq.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class NEWARRAY
extends Instruction
implements AllocationInstruction,
ExceptionThrower,
StackProducer {
    private byte type;

    NEWARRAY() {
    }

    public NEWARRAY(byte type) {
        super((short)188, (short)2);
        this.type = type;
    }

    public NEWARRAY(BasicType type) {
        this(type.getType());
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        out.writeByte(this.type);
    }

    public final byte getTypecode() {
        return this.type;
    }

    public final Type getType() {
        return new ArrayType(BasicType.getType(this.type), 1);
    }

    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + Constants.TYPE_NAMES[this.type];
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.type = bytes.readByte();
        this.length = (short)2;
    }

    public Class[] getExceptions() {
        return new Class[]{ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION};
    }

    public void accept(Visitor v) {
        v.visitAllocationInstruction(this);
        v.visitExceptionThrower(this);
        v.visitStackProducer(this);
        v.visitNEWARRAY(this);
    }
}

