/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast.nodes;

import com.ibm.xtq.ast.XPath20Exception;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.Node;
import com.ibm.xtq.ast.nodes.SimpleNode;
import com.ibm.xtq.ast.nodes.TypeExpr;
import com.ibm.xtq.ast.nodes.VarDecl;
import com.ibm.xtq.ast.nodes.VariableRef;
import com.ibm.xtq.ast.parsers.xpath.Token;
import com.ibm.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xtq.common.utils.Assert;
import com.ibm.xtq.common.utils.Util;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class QuantifiedExpr
extends Expr {
    public static final int SOME = 1;
    public static final int EVERY = 2;
    public static final int FLWOR = 3;
    private int _quantifiedExprType = -1;
    protected List _vardecls = new ArrayList();
    protected Expr _resExpr;
    protected static final short FQ_EXPECT_RANGE_VAR = 0;
    protected static final short FQ_EXPECT_IN_SEQ = 1;
    protected static final short FQ_EXPECT_RESULT = 2;
    private short _fqState = (short)2;

    public QuantifiedExpr(int n) {
        super(n);
        if (n == 42) {
            this._quantifiedExprType = 3;
        }
    }

    protected String getKeyword1() {
        switch (this.getQuantifiedExprType()) {
            case 2: {
                return "every";
            }
            case 1: {
                return "some";
            }
            case 3: {
                return "for";
            }
        }
        throw new XPath20Exception("ERR_INVALID_EXPRESSION", String.valueOf(this.getId()));
    }

    protected String getKeyword2() {
        switch (this.getQuantifiedExprType()) {
            case 1: 
            case 2: {
                return "satisfies";
            }
        }
        throw new XPath20Exception("ERR_INVALID_EXPRESSION", String.valueOf(this.getId()));
    }

    protected String getSeparator() {
        return "in";
    }

    @Override
    public void getXQueryString(StringBuffer stringBuffer, boolean bl, String string) {
        boolean bl2 = true;
        if (bl2) {
            stringBuffer.append('(');
        }
        stringBuffer.append(this.getKeyword1()).append(' ');
        for (int i = this._vardecls.size() - 1; i >= 0; --i) {
            VarDecl varDecl = (VarDecl)this._vardecls.get(i);
            stringBuffer.append("$").append(Util.getStringRep(varDecl.getQName())).append(" ");
            stringBuffer.append(' ').append("in").append(' ');
            varDecl.getExpression().getXQueryString(stringBuffer, bl, string + " ");
            if (i == 0) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(' ').append(this.getKeyword2()).append(' ');
        this._resExpr.getXQueryString(stringBuffer, bl, string + " ");
        if (bl2) {
            stringBuffer.append(')');
        }
    }

    @Override
    protected short getOperatorPrecedence() {
        return 2;
    }

    public int getClauseCount() {
        return this._vardecls == null ? 0 : this._vardecls.size();
    }

    public QName getVariableName(int n) {
        return this.getVardecl(n).getQName();
    }

    public TypeExpr getType(int n) {
        return this.getVardecl(n).getType();
    }

    public Expr getExpr(int n) {
        return this.getVardecl(n).getExpression();
    }

    public Expr getResultingExpr() {
        return this._resExpr;
    }

    public Expr replaceResultingExpr(Expr expr) {
        expr = QuantifiedExpr.parentless(expr);
        Expr expr2 = this._resExpr;
        this._resExpr = expr;
        return expr2;
    }

    protected short getFQState() {
        return this._fqState;
    }

    protected void setFQState(short s) {
        this._fqState = s;
    }

    @Override
    public void jjtAddChild(ASTBuildingContext aSTBuildingContext, Node node, int n) {
        switch (node.getId()) {
            default: 
        }
        switch (this._fqState) {
            case 0: {
                VarDecl varDecl = this.getVardecl(0);
                Assert._assert(node instanceof VariableRef, ((SimpleNode)node).toString());
                QName qName = ((VariableRef)this.reducedNode(aSTBuildingContext, (SimpleNode)node)).getVariableName();
                varDecl.setQName(qName);
                this.setFQState((short)1);
                break;
            }
            case 1: {
                VarDecl varDecl = new VarDecl(29);
                varDecl.setLocal(true);
                node = this.reducedNode(aSTBuildingContext, (SimpleNode)node);
                Assert._assert(node instanceof Expr, ((SimpleNode)node).toString());
                varDecl.setExpression((Expr)node);
                ((Expr)node).jjtSetParent(varDecl);
                this._vardecls.add(0, varDecl);
                varDecl.jjtSetParent(this);
                this.setFQState((short)0);
                break;
            }
            case 2: {
                this._resExpr = (Expr)this.reducedNode(aSTBuildingContext, (SimpleNode)node);
                this.setFQState((short)1);
            }
        }
    }

    @Override
    protected int initialChildNumber() {
        return 3;
    }

    public VarDecl getVardecl(int n) {
        return (VarDecl)this._vardecls.get(n);
    }

    public void setVardecl(int n, VarDecl varDecl) {
        this._vardecls.set(n, varDecl);
    }

    public void addVardecl(VarDecl varDecl) {
        this._vardecls.add(varDecl);
    }

    @Override
    public void processToken(ASTBuildingContext aSTBuildingContext, Token token) {
        this.setValue(token.image);
    }

    @Override
    public void processValue(ASTBuildingContext aSTBuildingContext, String string) {
        this.setValue(string);
    }

    private void setValue(String string) {
        if (string.equals("some")) {
            this.setQuantifiedExprType(1);
        } else if (string.equals("every")) {
            this.setQuantifiedExprType(2);
        }
    }

    public int getQuantifiedExprType() {
        return this._quantifiedExprType;
    }

    public void setQuantifiedExprType(int n) {
        this._quantifiedExprType = n;
    }
}

