/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast.nodes;

import com.ibm.xtq.ast.XPath20Exception;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.parsers.xpath.Token;
import com.ibm.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xtq.ast.parsers.xpath.XPathVisitor;
import com.ibm.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xtq.utils.XPathError;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Literal
extends Expr {
    protected Object m_literal;

    public Literal(int n) {
        super(n);
    }

    @Override
    public void getXQueryString(StringBuffer stringBuffer, boolean bl) {
        switch (this.getId()) {
            case 5: {
                stringBuffer.append('\'').append(this.m_literal.toString()).append('\'');
                break;
            }
            default: {
                stringBuffer.append(this.m_literal.toString());
            }
        }
    }

    public void setIntValue(BigInteger bigInteger) {
        this.m_literal = bigInteger;
        this.id = 97;
    }

    public void setDecimalValue(BigDecimal bigDecimal) {
        this.m_literal = bigDecimal;
        this.id = 98;
    }

    public void setStringValue(String string) {
        this.m_literal = string;
        this.id = 5;
    }

    public void setDoubleValue(double d) {
        this.m_literal = new Double(d);
        this.id = 99;
    }

    public BigDecimal getDecimalLiteral() throws XPath20Exception {
        if (this.getId() == 98) {
            return (BigDecimal)this.m_literal;
        }
        throw new XPath20Exception("ERR_SYSTEM", "Invalid method call: the literal is not a decimal");
    }

    public double getDecimalLiteralAsDouble() throws XPath20Exception {
        return this.getDecimalLiteral().doubleValue();
    }

    public double getDoubleLiteral() throws XPath20Exception {
        if (this.getId() == 99) {
            return (Double)this.m_literal;
        }
        throw new XPath20Exception("ERR_SYSTEM", "Invalid method call: the literal is not a double");
    }

    public BigInteger getIntegerLiteral() throws XPath20Exception {
        if (this.getId() == 97) {
            return (BigInteger)this.m_literal;
        }
        throw new XPath20Exception("ERR_SYSTEM", "Invalid method call: the literal is not an integer");
    }

    public int getIntegerLiteralAsInt() throws XPath20Exception {
        return this.getIntegerLiteral().intValue();
    }

    public String getStringLiteral() {
        if (this.getId() == 5) {
            return (String)this.m_literal;
        }
        throw new XPath20Exception("ERR_SYSTEM", "Invalid method call: the literal is not a string");
    }

    @Override
    public String getXQueryString(boolean bl) {
        return this.m_literal.toString();
    }

    @Override
    public void processToken(ASTBuildingContext aSTBuildingContext, Token token) {
        super.processToken(aSTBuildingContext, token);
        switch (this.id) {
            case 97: {
                this.m_literal = new BigInteger(token.image);
                break;
            }
            case 99: {
                this.m_literal = new Double(token.image);
                break;
            }
            case 5: 
            case 185: {
                String string = token.image.substring(1, token.image.length() - 1);
                String string2 = aSTBuildingContext.getExpressionFactory().getLanguage();
                if (!string2.equals("XPath1") && !string2.equals("XSLT1")) {
                    char c = token.image.charAt(0);
                    char[] cArray = new char[string.length()];
                    int n = 0;
                    for (int i = 0; i < string.length(); ++i) {
                        char c2 = string.charAt(i);
                        if (c2 == c) {
                            cArray[n++] = c2;
                            ++i;
                            continue;
                        }
                        cArray[n++] = c2;
                    }
                    string = new String(cArray, 0, n);
                }
                this.m_literal = string;
                break;
            }
            case 98: {
                this.m_literal = new BigDecimal(token.image);
                break;
            }
            default: {
                throw new XPathError("ERR_SYSTEM", "Invalid JJTree id:" + this.id);
            }
        }
    }

    @Override
    public String toString() {
        return XPathTreeConstants.jjtNodeName[this.id] + " " + this.getClass() + " " + this.getXQueryString(false);
    }

    @Override
    public Object jjtAccept(XPathVisitor xPathVisitor, Object object) {
        return xPathVisitor.visit(this, null);
    }

    @Override
    public int getId() {
        switch (this.id) {
            case 5: 
            case 147: 
            case 185: {
                return 5;
            }
        }
        return super.getId();
    }

    @Override
    public void getXQueryString(StringBuffer stringBuffer, boolean bl, String string) {
        switch (this.getId()) {
            case 5: {
                StringBuffer stringBuffer2 = new StringBuffer(this.m_literal.toString());
                for (int i = 0; i < stringBuffer2.length(); ++i) {
                    if (stringBuffer2.charAt(i) != '\'') continue;
                    stringBuffer2.insert(i, '\'');
                    ++i;
                }
                stringBuffer.append('\'').append(stringBuffer2.toString()).append('\'');
                break;
            }
            default: {
                stringBuffer.append(this.m_literal.toString());
            }
        }
    }

    @Override
    public String getValue() {
        return this.m_literal.toString();
    }
}

