/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util;

import com.ibm.xml.xlxp.api.util.NamespaceContext;
import com.ibm.xml.xlxp.api.util.SimpleDataBufferFactory;
import com.ibm.xml.xlxp.api.util.XMLTracer;
import com.ibm.xml.xlxp.scan.DocumentEntityScanner;
import com.ibm.xml.xlxp.scan.ScannerHelper;
import com.ibm.xml.xlxp.scan.util.AttrList;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.NSDeclList;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;
import java.util.Random;

public class SimpleScannerHelper
implements ScannerHelper {
    protected static final boolean ENABLE_TRACING = false;
    protected static final int USE_HASHTABLE_ATTR_COUNT = 16;
    protected static final int MAX_HASH_COLLISIONS = 640;
    protected static final int MULTIPLIERS_SIZE = 32;
    protected static final int MULTIPLIERS_MASK = 31;
    protected static final int CLEANUP_XML_DECL = 1;
    protected static final int CLEANUP_TEXT_DECL = 2;
    protected static final int CLEANUP_START_ELEMENT = 4;
    protected static final int CLEANUP_LEAF_ELEMENT = 8;
    protected static final int CLEANUP_END_ELEMENT = 16;
    protected static final int CLEANUP_CHARACTERS = 32;
    protected static final int CLEANUP_PROCESSING_INSTRUCTION = 64;
    protected static final int CLEANUP_COMMENT = 128;
    protected static final int CLEANUP_DOCTYPE = 256;
    protected static final int CLEANUP_ENTITY_REFERENCE = 512;
    protected static final int CLEANUP_RECOVERABLE_ERROR = 1024;
    protected final DocumentEntityScanner fDocumentEntityScanner;
    protected final DataBufferFactory fBufferFactory;
    protected final SymbolTable fSymbolTable;
    protected final XMLTracer fTracer;
    protected final NamespaceContext fNamespaceContext;
    protected NSDeclList fNSDecls;
    protected AttrList fAttributes;
    protected final boolean fComponentsInternal;
    protected boolean fIsNamespaceAware;
    protected boolean fHasDefaultAttributes;
    protected boolean fSeenAttrWithPrefix;
    protected boolean fSeenNSDecl;
    protected boolean fSeenDefaultNamespaceMapping;
    protected int fNamespaceDeclPrefix;
    protected int fAttValueOffset;
    protected ParsedEntity fCurrentEntity;
    protected int fElementDepth;
    protected boolean fInElementContent;
    protected QName fElementType;
    protected int fNSContext;
    protected int fAttributeCount;
    protected QName[] fAttributeNames;
    protected int[] fAttributeTypes;
    protected XMLString[] fAttributeValues;
    protected boolean[] fAttributeValueNormalized;
    protected boolean[] fAttributeSpecified;
    protected XMLString fEntityName;
    protected XMLString fTarget;
    protected XMLString fContent;
    protected XMLString fVersion;
    protected XMLString fEncName;
    protected XMLString fStandalone;
    protected int fSingleCh;
    protected int fCleanupFlags;
    protected String fErrorURI;
    protected int fErrorCode;
    protected int fErrorParamsCount;
    protected XMLString[] fErrorParams;
    protected long fErrorOffset;
    protected Object fExtensionState;
    private final XMLStringBuffer fStringBuffer;
    private final XMLString fTempString;
    private QName[] fElementTypeStack;
    private int[] fElementEntityStack;
    private int[] fAttrHashtable;
    private int[] fNextAttrInBucket;
    private int[] fHashMultipliers;

    protected SimpleScannerHelper() {
        this(new DocumentEntityScanner(), new SimpleDataBufferFactory(), null, true);
    }

    protected SimpleScannerHelper(DocumentEntityScanner documentEntityScanner, DataBufferFactory dataBufferFactory, SymbolTable symbolTable, boolean bl) {
        this.fDocumentEntityScanner = documentEntityScanner;
        this.fBufferFactory = dataBufferFactory;
        this.fComponentsInternal = symbolTable == null;
        this.fSymbolTable = this.fComponentsInternal ? new SymbolTable(dataBufferFactory) : symbolTable;
        this.fStringBuffer = new XMLStringBuffer(dataBufferFactory);
        this.fDocumentEntityScanner.setScannerHelper(this);
        this.fTracer = null;
        this.fIsNamespaceAware = true;
        this.fNamespaceContext = new NamespaceContext(this, this.fSymbolTable);
        this.fTempString = new XMLString();
        this.fNSDecls = new NSDecls();
        this.fAttributes = new Attrs();
        this.fElementTypeStack = new QName[32];
        this.fElementEntityStack = new int[32];
        if (bl) {
            this.initializeLocals();
        }
    }

    protected void initializeLocals() {
        this.fElementType = new QName();
        this.fAttributeNames = new QName[8];
        int n = 0;
        while (n < 8) {
            this.fAttributeNames[n] = new QName();
            ++n;
        }
        this.fAttributeTypes = new int[8];
        this.fAttributeValues = new XMLString[8];
        n = 0;
        while (n < 8) {
            this.fAttributeValues[n] = new XMLString();
            ++n;
        }
        this.fAttributeValueNormalized = new boolean[8];
        this.fAttributeSpecified = new boolean[8];
        this.fEntityName = new XMLString();
        this.fTarget = new XMLString();
        this.fContent = new XMLString();
        this.fVersion = new XMLString();
        this.fEncName = new XMLString();
        this.fStandalone = new XMLString();
        this.fErrorParams = new XMLString[8];
        n = 0;
        while (n < 8) {
            this.fErrorParams[n] = new XMLString();
            ++n;
        }
    }

    public void reset(boolean bl) {
        this.fStringBuffer.reset(bl);
        this.fSeenDefaultNamespaceMapping = false;
        this.fErrorParamsCount = 0;
        this.fElementDepth = 0;
        this.fInElementContent = false;
        int n = 0;
        while (n < this.fElementTypeStack.length) {
            if (this.fElementTypeStack[n] == null || this.fElementTypeStack[n].firstBuffer == null) break;
            this.fElementTypeStack[n].clear();
            ++n;
        }
        if (this.fElementType.firstBuffer != null) {
            this.fElementType.clear();
        }
        if (this.fContent.firstBuffer != null) {
            this.fContent.clear();
        }
        if (this.fEntityName.firstBuffer != null) {
            this.fEntityName.clear();
        }
        if (this.fTarget.firstBuffer != null) {
            this.fTarget.clear();
        }
        if (this.fVersion.firstBuffer != null) {
            this.fVersion.clear();
        }
        if (this.fEncName.firstBuffer != null) {
            this.fEncName.clear();
        }
        if (this.fStandalone.firstBuffer != null) {
            this.fStandalone.clear();
        }
        n = 0;
        while (n < this.fAttributeNames.length) {
            if (this.fAttributeNames[n].firstBuffer == null) break;
            this.fAttributeNames[n].clear();
            ++n;
        }
        n = 0;
        while (n < this.fAttributeValues.length) {
            if (this.fAttributeValues[n].firstBuffer == null) break;
            this.fAttributeValues[n].clear();
            ++n;
        }
        n = 0;
        while (n < this.fErrorParams.length) {
            if (this.fErrorParams[n].firstBuffer == null) break;
            this.fErrorParams[n].clear();
            ++n;
        }
        if (!bl) {
            n = 0;
            while (n < this.fElementTypeStack.length) {
                if (this.fElementTypeStack[n] == null) break;
                this.fElementTypeStack[n] = null;
                ++n;
            }
        }
        this.fDocumentEntityScanner.reset(bl);
        if (this.fComponentsInternal) {
            this.fSymbolTable.reset(bl);
            this.fBufferFactory.reset(bl);
        }
    }

    protected void moveToStringBuffer(XMLString xMLString) {
        this.fStringBuffer.addXMLString(xMLString, xMLString);
    }

    public void dropBufferReferences() {
        int n;
        if ((this.fCleanupFlags & 3) != 0) {
            if (this.fVersion.firstBuffer != null) {
                this.fVersion.clear();
            }
            if (this.fEncName.firstBuffer != null) {
                this.fEncName.clear();
            }
            if (this.fStandalone.firstBuffer != null) {
                this.fStandalone.clear();
            }
            this.fCleanupFlags &= 0xFFFFFFFC;
            if (this.fCleanupFlags == 0) {
                return;
            }
        }
        if ((this.fCleanupFlags & 0xE0) != 0) {
            if (this.fContent.firstBuffer != null) {
                this.fContent.clear();
            }
            this.fCleanupFlags &= 0xFFFFFF5F;
            if (this.fCleanupFlags == 0) {
                return;
            }
        }
        if ((this.fCleanupFlags & 0x40) != 0) {
            if (this.fTarget.firstBuffer != null) {
                this.fTarget.clear();
            }
            this.fCleanupFlags &= 0xFFFFFFBF;
            if (this.fCleanupFlags == 0) {
                return;
            }
        }
        if ((this.fCleanupFlags & 4) != 0) {
            if (this.fElementType.firstBuffer != null) {
                this.fElementType.clear();
            }
            n = 0;
            while (n < this.fAttributeNames.length) {
                if (this.fAttributeNames[n].firstBuffer == null) break;
                this.fAttributeNames[n].clear();
                this.fAttributeValues[n].clear();
                ++n;
            }
            this.fCleanupFlags &= 0xFFFFFFFB;
            if (this.fCleanupFlags == 0) {
                return;
            }
        }
        if ((this.fCleanupFlags & 0x10) != 0) {
            if (this.fElementType.firstBuffer != null) {
                this.fElementType.clear();
            }
            this.fCleanupFlags &= 0xFFFFFFEF;
            if (this.fCleanupFlags == 0) {
                return;
            }
        }
        if ((this.fCleanupFlags & 0x200) != 0) {
            if (this.fEntityName.firstBuffer != null) {
                this.fEntityName.clear();
            }
            this.fCleanupFlags &= 0xFFFFFDFF;
            if (this.fCleanupFlags == 0) {
                return;
            }
        }
        if ((this.fCleanupFlags & 0x400) != 0) {
            n = 0;
            while (n < this.fErrorParams.length) {
                if (this.fErrorParams[n].firstBuffer == null) break;
                this.fErrorParams[n].clear();
                ++n;
            }
            this.fCleanupFlags &= 0xFFFFFBFF;
            if (this.fCleanupFlags == 0) {
                return;
            }
        }
        if (this.fCleanupFlags == 0) {
            return;
        }
    }

    public void setNamespaceAwareness(boolean bl) {
        this.fIsNamespaceAware = bl;
    }

    public NamespaceContext namespaceContext() {
        return this.fNamespaceContext;
    }

    public void setDocumentEntity(ParsedEntity parsedEntity) {
        this.fCurrentEntity = parsedEntity;
        this.fDocumentEntityScanner.setDocumentEntity(parsedEntity);
    }

    public void setEntityContent(ParsedEntity parsedEntity) {
        this.fCurrentEntity = parsedEntity;
        this.fDocumentEntityScanner.setEntityContent(parsedEntity);
    }

    public void initialize() {
        this.fNamespaceContext.initialize();
        this.fNSContext = 0;
    }

    public void parseDocumentEntity(ParsedEntity parsedEntity) {
        this.fCurrentEntity = parsedEntity;
        this.fDocumentEntityScanner.setDocumentEntity(parsedEntity);
        this.produceEvents();
    }

    public boolean produceEvents() {
        while (this.fDocumentEntityScanner.produceEvent()) {
            if (!this.fCurrentEntity.loadCalled) continue;
            this.fCurrentEntity.loadCalled = false;
            if (this.fCleanupFlags == 0) continue;
            this.dropBufferReferences();
        }
        return true;
    }

    public boolean produceStartDocumentEvent() {
        return true;
    }

    public boolean produceEndDocumentEvent() {
        return false;
    }

    public boolean produceXMLDeclEvent() {
        this.fCleanupFlags |= 1;
        return true;
    }

    public boolean produceTextDeclEvent() {
        this.fCleanupFlags |= 2;
        return true;
    }

    public boolean produceEmptyElementEvent() {
        this.fCleanupFlags |= 4;
        return true;
    }

    public boolean produceStartElementEvent() {
        this.fCleanupFlags |= 4;
        return true;
    }

    public boolean produceEndElementEvent(QName qName) {
        this.currentElementType().setValues(qName);
        this.setElementNSContext(this.endNamespacesScope());
        this.fCleanupFlags |= 0x10;
        return true;
    }

    public boolean produceCharactersEvent() {
        this.setCurrentNSContext();
        this.fCleanupFlags |= 0x20;
        return true;
    }

    public boolean produceWhitespaceEvent() {
        this.setCurrentNSContext();
        this.fCleanupFlags |= 0x20;
        return true;
    }

    public boolean produceCharacterEvent(int n) {
        this.setCurrentNSContext();
        this.setSingleCh(n);
        return true;
    }

    public boolean producePredefinedEntityEvent(int n) {
        this.setCurrentNSContext();
        this.setSingleCh(n);
        return true;
    }

    public boolean produceProcessingInstructionEvent() {
        this.setCurrentNSContext();
        this.fCleanupFlags |= 0x40;
        return true;
    }

    public boolean produceCommentEvent() {
        this.setCurrentNSContext();
        this.fCleanupFlags |= 0x80;
        return true;
    }

    public boolean produceStartCDATASectionEvent() {
        this.setCurrentNSContext();
        return true;
    }

    public boolean produceEndCDATASectionEvent() {
        this.setCurrentNSContext();
        return true;
    }

    public boolean produceStartEntityEvent() {
        this.setCurrentNSContext();
        this.fCleanupFlags |= 0x200;
        return true;
    }

    public boolean produceEndEntityEvent() {
        this.setCurrentNSContext();
        this.fCleanupFlags |= 0x200;
        return true;
    }

    public boolean produceWarningEvent(String string, int n) {
        this.saveErrorContext(string, n);
        this.fCleanupFlags |= 0x400;
        return true;
    }

    public boolean produceRecoverableErrorEvent(String string, int n) {
        this.saveErrorContext(string, n);
        this.fCleanupFlags |= 0x400;
        return true;
    }

    public boolean produceFatalErrorEvent(String string, int n) {
        this.saveErrorContext(string, n);
        return false;
    }

    public boolean produceExtensionEvent(Object object) {
        this.fExtensionState = object;
        return false;
    }

    public QName setupStartElement() {
        if (this.fElementDepth == 0) {
            this.fHasDefaultAttributes = this.fDocumentEntityScanner.hasDefaultAttributes();
        }
        this.setElementNSContext(this.startNamespacesScope());
        this.setupAttributes();
        this.fSeenAttrWithPrefix = false;
        this.fSeenNSDecl = false;
        return this.currentElementType();
    }

    protected void setupAttributes() {
        this.fAttributeCount = 0;
    }

    protected void processAttributeName(QName qName, boolean bl) {
        if (this.fIsNamespaceAware) {
            int n = qName.prefixHandle;
            int n2 = qName.localHandle;
            if (n != 1) {
                if (n == 0) {
                    this.fNamespaceDeclPrefix = n2 != 1 ? -1 : 0;
                } else {
                    this.fNamespaceDeclPrefix = -1;
                    this.fSeenAttrWithPrefix = true;
                }
            } else {
                this.fNamespaceDeclPrefix = n2;
            }
        } else {
            this.fNamespaceDeclPrefix = -1;
        }
        this.setupCurrentAttribute(bl);
        this.currentAttributeValue().endOffset = -1;
        this.fAttValueOffset = -1;
    }

    protected void setupCurrentAttribute(boolean bl) {
        if (this.fAttributeCount + 1 == this.fAttributeNames.length) {
            this.growAttributes();
        }
        this.fAttributeTypes[this.fAttributeCount] = 0;
        this.fAttributeValueNormalized[this.fAttributeCount] = bl;
        this.fAttributeSpecified[this.fAttributeCount] = bl;
    }

    protected void setCurrentAttributeType(int n) {
        this.fAttributeTypes[this.fAttributeCount] = n;
    }

    protected void growAttributes() {
        int n = this.fAttributeNames.length;
        QName[] qNameArray = new QName[n << 1];
        System.arraycopy(this.fAttributeNames, 0, qNameArray, 0, n);
        this.fAttributeNames = qNameArray;
        int n2 = (n << 1) - 1;
        while (n2 >= n) {
            this.fAttributeNames[n2] = new QName();
            --n2;
        }
        XMLString[] xMLStringArray = new XMLString[n << 1];
        System.arraycopy(this.fAttributeValues, 0, xMLStringArray, 0, n);
        this.fAttributeValues = xMLStringArray;
        n2 = (n << 1) - 1;
        while (n2 >= n) {
            this.fAttributeValues[n2] = new XMLString();
            --n2;
        }
        int[] nArray = new int[n << 1];
        System.arraycopy(this.fAttributeTypes, 0, nArray, 0, n);
        this.fAttributeTypes = nArray;
        boolean[] blArray = new boolean[n << 1];
        System.arraycopy(this.fAttributeValueNormalized, 0, blArray, 0, n);
        this.fAttributeValueNormalized = blArray;
        blArray = new boolean[n << 1];
        System.arraycopy(this.fAttributeSpecified, 0, blArray, 0, n);
        this.fAttributeSpecified = blArray;
    }

    protected boolean finishElement() {
        if (this.fIsNamespaceAware) {
            if (!this.resolveNamespaceURIs()) {
                return false;
            }
            if (this.fNamespaceContext.nsDeclCount(this.nsContext()) > 1 && !this.fNamespaceContext.checkDuplicateNamespaces(this.currentElementType())) {
                return false;
            }
        }
        return this.fAttributeCount <= 1 || this.checkDuplicateAttrs();
    }

    protected boolean addDefaultAttributes(QName qName, NSDeclList nSDeclList, AttrList attrList) {
        return this.fDocumentEntityScanner.addDefaultAttributes(qName, nSDeclList, attrList, this.fIsNamespaceAware);
    }

    public boolean finishEmptyElement() {
        if ((!this.fHasDefaultAttributes || this.addDefaultAttributes(this.currentElementType(), this.fNSDecls, this.fAttributes)) && this.finishElement()) {
            this.endNamespacesScope();
            this.fDocumentEntityScanner.finishEmptyElement(this.fElementDepth);
            return this.produceEmptyElementEvent();
        }
        return false;
    }

    public boolean finishStartElement() {
        if ((!this.fHasDefaultAttributes || this.addDefaultAttributes(this.currentElementType(), this.fNSDecls, this.fAttributes)) && this.finishElement()) {
            QName qName = this.fElementType;
            this.pushElement(qName);
            this.fDocumentEntityScanner.finishStartElement();
            return this.produceStartElementEvent();
        }
        return false;
    }

    public void setNSDeclURI(int n, int n2) {
        this.fNamespaceContext.setNSDeclURI(this.nsContext(), n, n2);
    }

    public boolean setNamespaceURI(QName qName) {
        if (qName.prefixHandle != 0 || qName == this.currentElementType()) {
            return this.fNamespaceContext.setNamespaceURI(this.nsContext(), qName);
        }
        return true;
    }

    protected int resolveAttrListNamespaceURIs(int n) {
        int n2 = 0;
        while (n2 < this.fAttributeCount) {
            QName qName = this.fAttributeNames[n2];
            int n3 = qName.prefixHandle;
            if (n3 != 0 && n3 != 1 && !this.fNamespaceContext.setNamespaceURI(n, qName)) {
                return n3;
            }
            ++n2;
        }
        return 0;
    }

    protected boolean resolveNamespaceURIs() {
        int n;
        int n2 = this.nsContext();
        if (this.fSeenAttrWithPrefix && (n = this.resolveAttrListNamespaceURIs(n2)) != 0) {
            return this.undeclaredPrefix(n);
        }
        QName qName = this.currentElementType();
        if (qName.prefixHandle != 0 || this.fSeenDefaultNamespaceMapping) {
            if (!this.fNamespaceContext.setNamespaceURI(n2, qName)) {
                return this.undeclaredPrefix(qName.prefixHandle);
            }
        } else {
            qName.nsHandle = 0;
        }
        return true;
    }

    private boolean undeclaredPrefix(int n) {
        this.fSymbolTable.setStringValues(n, this.fTempString);
        this.setParameter(0, this.fTempString);
        return this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 50);
    }

    protected boolean checkDuplicateAttrs() {
        QName qName = this.checkDuplicateAttrs2();
        if (qName != null) {
            return this.duplicateAttribute(qName);
        }
        return true;
    }

    protected boolean duplicateAttribute(QName qName) {
        this.setParameter(0, this.currentElementType());
        this.setParameter(1, qName);
        return this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 17);
    }

    protected QName checkDuplicateAttrs2() {
        int n = this.fAttributeCount;
        if (n < 16) {
            int n2 = 0;
            while (n2 < this.fAttributeCount - 1) {
                QName qName = this.fAttributeNames[n2];
                int n3 = qName.localHandle;
                int n4 = n2 + 1;
                while (n4 < this.fAttributeCount) {
                    if (this.fAttributeNames[n4].localHandle == n3 && this.fAttributeNames[n4].nsHandle == this.fAttributeNames[n2].nsHandle) {
                        return this.fAttributeNames[n4];
                    }
                    ++n4;
                }
                ++n2;
            }
            return null;
        }
        return this.checkManyDuplicateAttrs(n);
    }

    protected QName checkManyDuplicateAttrs(int n) {
        int n2 = n >> 4;
        int n3 = 1024;
        while (n3 < n2) {
            n3 <<= 1;
        }
        if (this.fAttrHashtable == null || n3 > this.fAttrHashtable.length) {
            this.fAttrHashtable = new int[n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            this.fAttrHashtable[n4] = -1;
            ++n4;
        }
        --n3;
        int n5 = this.fAttributeNames.length;
        if (this.fNextAttrInBucket == null || n5 > this.fNextAttrInBucket.length) {
            this.fNextAttrInBucket = new int[n5];
        }
        this.fHashMultipliers = null;
        n4 = 0;
        while (n4 < this.fAttributeCount) {
            int n6 = this.fAttributeNames[n4].localHandle;
            int n7 = this.fAttributeNames[n4].nsHandle;
            int n8 = this.attrHash(n6, n7);
            int n9 = n8 & n3;
            int n10 = 0;
            int n11 = this.fAttrHashtable[n9];
            if (n11 >= 0) {
                int n12 = n11;
                while (n12 >= 0) {
                    if (this.fAttributeNames[n12].localHandle == n6 && this.fAttributeNames[n12].nsHandle == n7) {
                        return this.fAttributeNames[n4];
                    }
                    ++n10;
                    n12 = this.fNextAttrInBucket[n12];
                }
            }
            this.fNextAttrInBucket[n4] = n11;
            this.fAttrHashtable[n9] = n4;
            if (n10 >= 640) {
                this.rebalanceAttrHashtable(n3, n4 + 1);
            }
            ++n4;
        }
        return null;
    }

    private void rebalanceAttrHashtable(int n, int n2) {
        if (this.fHashMultipliers == null) {
            this.fHashMultipliers = new int[33];
        }
        int[] nArray = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727};
        Random random = new Random();
        int n3 = 0;
        while (n3 < this.fHashMultipliers.length) {
            this.fHashMultipliers[n3] = nArray[random.nextInt(nArray.length)];
            ++n3;
        }
        n3 = 0;
        while (n3 < this.fAttrHashtable.length) {
            this.fAttrHashtable[n3] = -1;
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = this.fAttributeNames[n3].localHandle;
            int n6 = this.fAttributeNames[n3].nsHandle;
            int n7 = this.attrHash(n5, n6);
            int n8 = n7 & n;
            this.fNextAttrInBucket[n3] = n4 = this.fAttrHashtable[n8];
            this.fAttrHashtable[n8] = n3++;
        }
    }

    private int attrHash(int n, int n2) {
        if (this.fHashMultipliers == null) {
            return n + n2;
        }
        return this.attrHash0(n) + this.attrHash0(n2) * this.fHashMultipliers[32];
    }

    private int attrHash0(int n) {
        if (n == 0) {
            return 0;
        }
        this.fSymbolTable.setStringValues(n, this.fTempString);
        String string = this.fTempString.toString();
        int n2 = 0;
        int n3 = string.length();
        int[] nArray = this.fHashMultipliers;
        int n4 = 0;
        while (n4 < n3) {
            n2 = n2 * nArray[n4 & 0x1F] + string.charAt(n4);
            ++n4;
        }
        return n2;
    }

    protected void pushElement(QName qName) {
        QName qName2;
        if (this.fElementDepth == this.fElementTypeStack.length) {
            this.growElements();
        }
        if ((qName2 = this.fElementTypeStack[this.fElementDepth]) != null) {
            this.fSymbolTable.shareQNameValues(qName, qName2);
        } else {
            qName2 = this.fElementTypeStack[this.fElementDepth] = new QName();
            this.fSymbolTable.shareQNameValues(qName, qName2);
        }
        this.fElementEntityStack[this.fElementDepth] = this.fCurrentEntity.id;
        ++this.fElementDepth;
    }

    public int elementDepth() {
        return this.fElementDepth;
    }

    public QName popElement() {
        --this.fElementDepth;
        if (this.fElementEntityStack[this.fElementDepth] == this.fCurrentEntity.id) {
            return this.fElementTypeStack[this.fElementDepth];
        }
        return null;
    }

    public QName topElement() {
        return this.fElementTypeStack[this.fElementDepth];
    }

    private void growElements() {
        QName[] qNameArray = new QName[this.fElementDepth << 1];
        System.arraycopy(this.fElementTypeStack, 0, qNameArray, 0, this.fElementDepth);
        this.fElementTypeStack = qNameArray;
        int[] nArray = new int[this.fElementDepth << 1];
        System.arraycopy(this.fElementEntityStack, 0, nArray, 0, this.fElementDepth);
        this.fElementEntityStack = nArray;
    }

    public boolean continueAfterEndOfEntity() {
        return true;
    }

    public int scanQName(ParsedEntity parsedEntity, QName qName) {
        if (this.fIsNamespaceAware) {
            if (parsedEntity.unbuffered) {
                return this.fSymbolTable.scanQNameUnbuffered(parsedEntity, qName);
            }
            return this.fSymbolTable.scanQNameBuffered(parsedEntity, qName);
        }
        return this.fSymbolTable.scanName(parsedEntity, qName);
    }

    public int scanNCName(ParsedEntity parsedEntity, XMLString xMLString) {
        if (this.fIsNamespaceAware) {
            return this.fSymbolTable.scanNCName(parsedEntity, xMLString);
        }
        return this.fSymbolTable.scanName(parsedEntity, xMLString);
    }

    public boolean scanStartElementBuffered(ParsedEntity parsedEntity) {
        return this.fDocumentEntityScanner.scanStartElementBuffered();
    }

    public boolean scanStartElementUnbuffered(ParsedEntity parsedEntity) {
        return this.fDocumentEntityScanner.scanStartElementUnbuffered();
    }

    public boolean scanEndElementBuffered(ParsedEntity parsedEntity) {
        return this.fDocumentEntityScanner.scanEndElementBuffered();
    }

    /*
     * Unable to fully structure code
     */
    public boolean scanEndElementUnbuffered(ParsedEntity var1_1) {
        block6: {
            block5: {
                var2_2 = this.popElement();
                var1_1.offset += 2;
                if (var2_2 == null) break block6;
                var3_3 = var1_1.bytes;
                var4_4 = var1_1.offset;
                var5_5 = var2_2.bytes;
                var6_6 = var2_2.length;
                var7_7 = var4_4 + var6_6;
                var8_8 = var2_2.endOffset - 1;
                var9_9 = var7_7 - 1;
                if (var5_5 != null && var7_7 <= var1_1.endOffset) {
                    while (var5_5[var8_8] == var3_3[var9_9]) {
                        if (var9_9-- > var4_4) {
                            --var8_8;
                            continue;
                        }
                        break block5;
                    }
                    return this.scanEndElementNoMatch(var1_1, var2_2);
                }
                return this.scanEndElementUnbuffered2(var1_1, var2_2);
            }
            var10_10 = var3_3[var7_7];
            if (var10_10 != 62) ** GOTO lbl26
            var1_1.offset = var7_7 + 1;
            this.fDocumentEntityScanner.finishEndElementUnbuffered(this.fElementDepth);
            return this.produceEndElementEvent(var2_2);
lbl-1000:
            // 1 sources

            {
                var10_10 = var3_3[++var7_7];
lbl26:
                // 2 sources

                ** while (var10_10 == 32 || var10_10 == 10 || var10_10 == 9 || var10_10 == 13)
            }
lbl27:
            // 1 sources

            if (var10_10 == 62) {
                var1_1.offset = var7_7 + 1;
                this.fDocumentEntityScanner.finishEndElementUnbuffered(this.fElementDepth);
                return this.produceEndElementEvent(var2_2);
            }
            this.setParameter(0, var2_2);
            return this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 18);
        }
        this.setParameter(0, this.topElement());
        return this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 20);
    }

    private boolean scanEndElementUnbuffered2(ParsedEntity parsedEntity, QName qName) {
        boolean bl = qName.bytes != null ? this.skippedBytesInRange(parsedEntity, qName.bytes, qName.startOffset, qName.endOffset) : this.skippedBytesBuffered2(parsedEntity, qName.firstBuffer, qName.lastBuffer, qName.startOffset, qName.endOffset);
        int n = parsedEntity.offset;
        if (bl) {
            byte by = parsedEntity.bytes[n];
            if (by != 62) {
                while (by == 32 || by == 10 || by == 9 || by == 13) {
                    by = parsedEntity.bytes[++n];
                }
                if (by != 62) {
                    this.setParameter(0, qName);
                    return this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 18);
                }
            }
            parsedEntity.offset = n + 1;
            this.fDocumentEntityScanner.finishEndElementUnbuffered(this.fElementDepth);
            return this.produceEndElementEvent(qName);
        }
        return this.scanEndElementNoMatch(parsedEntity, qName);
    }

    private boolean scanEndElementNoMatch(ParsedEntity parsedEntity, QName qName) {
        QName qName2 = new QName();
        this.fSymbolTable.scanQNameBuffered(parsedEntity, qName2);
        this.setParameter(0, qName2);
        this.setParameter(1, qName);
        qName2.clear();
        return this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 14);
    }

    protected int loadMore(ParsedEntity parsedEntity) {
        if (parsedEntity != null) {
            parsedEntity.load();
            if (parsedEntity.error == null) {
                return parsedEntity.bytes[parsedEntity.offset];
            }
            return 0;
        }
        return 0;
    }

    protected boolean skippedBytesInRange(ParsedEntity parsedEntity, byte[] byArray, int n, int n2) {
        if (parsedEntity.bytes[parsedEntity.offset] == byArray[n] && parsedEntity.offset + (n2 - n) <= parsedEntity.endOffset) {
            int n3 = parsedEntity.offset++;
            byte by = parsedEntity.bytes[parsedEntity.offset];
            while (++n < n2) {
                if (by == byArray[n]) {
                    ++parsedEntity.offset;
                    by = parsedEntity.bytes[parsedEntity.offset];
                    continue;
                }
                parsedEntity.offset = n3;
                return false;
            }
            if (by == 0 && parsedEntity.offset == parsedEntity.endOffset) {
                this.loadMore(parsedEntity);
            }
            return true;
        }
        return this.skippedBytesBuffered(parsedEntity, byArray, n, n2);
    }

    protected boolean skippedBytesBuffered(ParsedEntity parsedEntity, byte[] byArray, int n, int n2) {
        if (parsedEntity.bytes[parsedEntity.offset] == byArray[n]) {
            boolean bl = false;
            int n3 = parsedEntity.offset++;
            int n4 = n + 1;
            int n5 = parsedEntity.bytes[parsedEntity.offset];
            while (n4 < n2) {
                if (n5 == byArray[n4]) {
                    ++parsedEntity.offset;
                    ++n4;
                    n5 = parsedEntity.bytes[parsedEntity.offset];
                    continue;
                }
                if (n5 != 0 || parsedEntity.offset < parsedEntity.endOffset) {
                    if (bl) {
                        parsedEntity.resetToMark();
                    } else {
                        parsedEntity.offset = n3;
                    }
                    return false;
                }
                if (!bl) {
                    int n6 = parsedEntity.offset;
                    parsedEntity.offset = n3;
                    parsedEntity.setMark();
                    parsedEntity.offset = n6;
                    bl = true;
                }
                if ((n5 = this.loadMore(parsedEntity)) != 0) continue;
                parsedEntity.resetToMark();
                return false;
            }
            if (bl) {
                parsedEntity.clearMark();
            }
            if (n5 == 0 && parsedEntity.offset == parsedEntity.endOffset) {
                this.loadMore(parsedEntity);
            }
            return true;
        }
        return false;
    }

    protected boolean skippedBytesBuffered2(ParsedEntity parsedEntity, DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2) {
        byte[] byArray = dataBuffer.bytes;
        int n3 = dataBuffer.endOffset;
        if (parsedEntity.bytes[parsedEntity.offset] == byArray[n]) {
            int n4;
            boolean bl;
            block10: {
                bl = false;
                int n5 = parsedEntity.offset++;
                n4 = parsedEntity.bytes[parsedEntity.offset];
                ++n;
                while (true) {
                    if (n == n3) {
                        if (dataBuffer == dataBuffer2) break block10;
                        dataBuffer = dataBuffer.next;
                        byArray = dataBuffer.bytes;
                        n = dataBuffer.startOffset;
                        int n6 = n3 = dataBuffer == dataBuffer2 ? n2 : dataBuffer.endOffset;
                    }
                    if (n4 == byArray[n]) {
                        ++parsedEntity.offset;
                        ++n;
                        n4 = parsedEntity.bytes[parsedEntity.offset];
                        continue;
                    }
                    if (n4 != 0 || parsedEntity.offset < parsedEntity.endOffset) {
                        if (bl) {
                            parsedEntity.resetToMark();
                        } else {
                            parsedEntity.offset = n5;
                        }
                        return false;
                    }
                    if (!bl) {
                        int n7 = parsedEntity.offset;
                        parsedEntity.offset = n5;
                        parsedEntity.setMark();
                        parsedEntity.offset = n7;
                        bl = true;
                    }
                    if ((n4 = this.loadMore(parsedEntity)) == 0) break;
                }
                parsedEntity.resetToMark();
                return false;
            }
            if (bl) {
                parsedEntity.clearMark();
            }
            if (n4 == 0 && parsedEntity.offset == parsedEntity.endOffset) {
                this.loadMore(parsedEntity);
            }
            return true;
        }
        return false;
    }

    public boolean scanAttrValueBuffered(ParsedEntity parsedEntity, XMLString xMLString, int n) {
        return this.fDocumentEntityScanner.scanAttrValueBuffered(xMLString, n);
    }

    public boolean scanAttrValueUnbuffered(ParsedEntity parsedEntity, XMLString xMLString, int n) {
        return this.fDocumentEntityScanner.scanAttrValueUnbuffered(xMLString, n);
    }

    public boolean scanNamespaceURIBuffered(ParsedEntity parsedEntity, XMLString xMLString, int n) {
        return this.fDocumentEntityScanner.scanNamespaceURIBuffered(xMLString, n);
    }

    public boolean scanNamespaceURIUnbuffered(ParsedEntity parsedEntity, XMLString xMLString, int n) {
        return this.fDocumentEntityScanner.scanNamespaceURIUnbuffered(xMLString, n);
    }

    public void setInElementContent(boolean bl) {
        this.fInElementContent = bl;
    }

    public boolean scanContentBuffered(ParsedEntity parsedEntity) {
        if (this.fInElementContent) {
            return this.fDocumentEntityScanner.scanElementContentBuffered(this.fContent);
        }
        return this.fDocumentEntityScanner.scanContentBuffered(this.fContent);
    }

    public boolean scanContentUnbuffered(ParsedEntity parsedEntity) {
        if (this.fInElementContent) {
            return this.fDocumentEntityScanner.scanElementContentUnbuffered(this.fContent);
        }
        return this.fDocumentEntityScanner.scanContentUnbuffered(this.fContent);
    }

    public QName currentElementType() {
        return this.fElementType;
    }

    public QName currentAttributeName() {
        return this.fAttributeNames[this.fAttributeCount];
    }

    public XMLString currentAttributeValue() {
        return this.fAttributeValues[this.fAttributeCount];
    }

    protected int startNamespacesScope() {
        return this.fIsNamespaceAware || this.fElementDepth == 0 ? this.fNamespaceContext.startNamespacesScope() : this.fNamespaceContext.currentContext();
    }

    protected int endNamespacesScope() {
        return this.fIsNamespaceAware || this.fElementDepth == 0 ? this.fNamespaceContext.endNamespacesScope() : this.fNamespaceContext.currentContext();
    }

    public XMLString setupSpecifiedAttribute() {
        this.processAttributeName(this.currentAttributeName(), true);
        return this.currentAttributeValue();
    }

    public boolean addSpecifiedAttribute() {
        if (this.fNamespaceDeclPrefix == -1) {
            return this.saveSpecifiedAttValue();
        }
        return this.saveSpecifiedNamespaceURI();
    }

    public void attributeValueCharacters(XMLString xMLString, boolean bl) {
        if (xMLString.length == 0) {
            return;
        }
        if (this.fAttValueOffset == -1) {
            XMLString xMLString2 = this.currentAttributeValue();
            if (xMLString == xMLString2) {
                if (bl) {
                    return;
                }
                this.fAttValueOffset = this.fStringBuffer.getOffset();
            } else {
                this.fAttValueOffset = this.fStringBuffer.getOffset();
                if (xMLString2.endOffset != -1) {
                    this.fStringBuffer.appendXMLString(xMLString2);
                }
            }
        }
        if (bl) {
            this.fStringBuffer.appendXMLString(xMLString);
        } else {
            this.fStringBuffer.normalizedAppend(xMLString);
        }
    }

    public void attributeValueCharacter(int n, boolean bl) {
        if (this.fAttValueOffset == -1) {
            XMLString xMLString = this.currentAttributeValue();
            this.fAttValueOffset = this.fStringBuffer.getOffset();
            if (xMLString.endOffset != -1) {
                this.fStringBuffer.appendXMLString(xMLString);
            }
        }
        this.fStringBuffer.appendChar(n);
    }

    public boolean saveSpecifiedAttValue() {
        this.saveAttValue();
        return this.saveAttribute();
    }

    protected boolean saveAttribute() {
        ++this.fAttributeCount;
        return true;
    }

    public boolean saveSpecifiedNamespaceURI() {
        return this.saveNamespaceDecl(this.currentAttributeName(), this.saveAttValue());
    }

    protected boolean saveNamespaceDecl(QName qName, XMLString xMLString) {
        boolean bl;
        if (this.fNamespaceDeclPrefix == 0) {
            this.fSeenDefaultNamespaceMapping = true;
        }
        if ((bl = this.fNamespaceContext.createPrefixMapping(this.fNamespaceDeclPrefix, this.fSymbolTable.addSymbol(xMLString), qName.handle, this.fCurrentEntity.isXML10)) && !this.fSeenNSDecl) {
            this.setCurrentNSContext();
            this.fSeenNSDecl = true;
        }
        return bl;
    }

    protected XMLString saveAttValue() {
        XMLString xMLString = this.currentAttributeValue();
        if (this.fAttValueOffset != -1) {
            this.fStringBuffer.setStringValues(this.fAttValueOffset, this.fStringBuffer.getOffset(), xMLString);
        } else if (xMLString.endOffset == -1) {
            this.fStringBuffer.setStringValues(0, 0, xMLString);
        }
        return xMLString;
    }

    public void setAttributeType(int n, int n2) {
        this.fAttributeTypes[n] = n2;
    }

    public boolean addDefaultAttribute(QName qName, int n, XMLString xMLString) {
        this.processAttributeName(qName, false);
        this.currentAttributeName().setValues(qName);
        this.setCurrentAttributeType(n);
        this.currentAttributeValue().setValues(xMLString);
        return this.saveAttribute();
    }

    public boolean addDefaultNSDecl(QName qName, XMLString xMLString) {
        if (this.fIsNamespaceAware) {
            this.processAttributeName(qName, false);
            return this.saveNamespaceDecl(qName, xMLString);
        }
        return this.addDefaultAttribute(qName, 14, xMLString);
    }

    public XMLString contentToProduce() {
        return this.fContent;
    }

    public XMLString versionToProduce() {
        return this.fVersion;
    }

    public XMLString encNameToProduce() {
        return this.fEncName;
    }

    public XMLString standaloneToProduce() {
        return this.fStandalone;
    }

    public XMLString targetToProduce() {
        return this.fTarget;
    }

    public XMLString entityNameToProduce() {
        return this.fEntityName;
    }

    public void setParameter(int n, XMLString xMLString) {
        if (n >= this.fErrorParamsCount) {
            if (n + 1 <= this.fErrorParams.length) {
                this.fErrorParamsCount = n + 1;
            } else {
                int n2 = this.fErrorParams.length;
                XMLString[] xMLStringArray = new XMLString[n2 << 1];
                System.arraycopy(this.fErrorParams, 0, xMLStringArray, 0, n2);
                this.fErrorParams = xMLStringArray;
                int n3 = (n2 << 1) - 1;
                while (n3 >= n2) {
                    this.fErrorParams[n3] = new XMLString();
                    --n3;
                }
                this.fErrorParamsCount = n + 1;
            }
        }
        this.fErrorParams[n].setValues(xMLString);
    }

    public void setParameter(int n, String string) {
        this.fStringBuffer.addString(string, this.fTempString);
        this.setParameter(n, this.fTempString);
    }

    public void setParameter(int n, int n2) {
        this.fSymbolTable.setStringValues(n2, this.fTempString);
        this.setParameter(n, this.fTempString);
    }

    public void setParameter(int n, QName qName) {
        this.setParameter(n, qName.handle);
    }

    public void setInvalidCharParameter(int n, int n2) {
        this.setParameter(n, Integer.toHexString(n2));
    }

    public boolean reportWarning(String string, int n) {
        return this.produceWarningEvent(string, n);
    }

    public boolean reportRecoverableError(String string, int n) {
        return this.produceRecoverableErrorEvent(string, n);
    }

    public boolean reportFatalError(String string, int n) {
        boolean bl = this.produceFatalErrorEvent(string, n);
        this.fDocumentEntityScanner.endDocument();
        return bl;
    }

    protected int helperAttributeCount() {
        return this.fAttributeCount;
    }

    protected void setSingleCh(int n) {
        this.fSingleCh = n;
    }

    protected int nsContext() {
        return this.fNSContext;
    }

    protected void setNSContext(int n) {
        this.fNSContext = n;
    }

    private void setElementNSContext(int n) {
        this.setNSContext(n);
    }

    protected void setCurrentNSContext() {
        this.setNSContext(this.fNamespaceContext.currentContext());
    }

    protected void saveErrorContext(String string, int n) {
        this.fNSContext = this.fNamespaceContext.currentContext();
        this.fErrorURI = string;
        this.fErrorCode = n;
    }

    protected class Attrs
    implements AttrList {
        protected Attrs() {
        }

        public int attributeCount() {
            return SimpleScannerHelper.this.helperAttributeCount();
        }

        public QName attributeName(int n) {
            return SimpleScannerHelper.this.fAttributeNames[n];
        }

        public int attributeType(int n) {
            return SimpleScannerHelper.this.fAttributeTypes[n];
        }

        public XMLString unnormalizedAttributeValue(int n) {
            return SimpleScannerHelper.this.fAttributeValues[n];
        }

        public XMLString attributeValue(int n) {
            if (!SimpleScannerHelper.this.fAttributeValueNormalized[n]) {
                SimpleScannerHelper.this.fStringBuffer.normalizeTextValue(SimpleScannerHelper.this.fAttributeValues[n], null);
                SimpleScannerHelper.this.fAttributeValueNormalized[n] = true;
            }
            return SimpleScannerHelper.this.fAttributeValues[n];
        }

        public boolean attributeValueNormalized(int n) {
            return SimpleScannerHelper.this.fAttributeValueNormalized[n];
        }

        public boolean attributeSpecified(int n) {
            return SimpleScannerHelper.this.fAttributeSpecified[n];
        }

        public void normalizeAttributeValue(int n) {
            SimpleScannerHelper.this.fStringBuffer.normalizeTextValue(SimpleScannerHelper.this.fAttributeValues[n], null);
            SimpleScannerHelper.this.fAttributeValueNormalized[n] = true;
        }

        public void setAttributeValueNormalized(int n, boolean bl) {
            SimpleScannerHelper.this.fAttributeValueNormalized[n] = bl;
        }
    }

    protected final class NSDecls
    implements NSDeclList {
        protected NSDecls() {
        }

        public int nsDeclCount() {
            return SimpleScannerHelper.this.fNamespaceContext.nsDeclCount(SimpleScannerHelper.this.nsContext());
        }

        public int nsDeclPrefix(int n) {
            return SimpleScannerHelper.this.fNamespaceContext.nsDeclPrefix(SimpleScannerHelper.this.nsContext(), n);
        }

        public int nsDeclURI(int n) {
            return SimpleScannerHelper.this.fNamespaceContext.nsDeclURI(SimpleScannerHelper.this.nsContext(), n);
        }

        public int nsDeclQName(int n) {
            return SimpleScannerHelper.this.fNamespaceContext.nsDeclQName(SimpleScannerHelper.this.nsContext(), n);
        }

        public int prefixMapping(int n) {
            return SimpleScannerHelper.this.fNamespaceContext.prefixMapping(SimpleScannerHelper.this.nsContext(), n);
        }
    }
}

