/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.BadRecordFlagException;
import com.ibm.security.cmskeystore.Buffer;
import com.ibm.security.cmskeystore.BufferFactory;
import com.ibm.security.cmskeystore.ByteSequenceInputStream;
import com.ibm.security.cmskeystore.ByteSequenceInputStreamFactory;
import com.ibm.security.cmskeystore.IntableByteSequence;
import com.ibm.security.cmskeystore.IntableByteSequenceFactory;
import com.ibm.security.cmskeystore.Record;
import com.ibm.security.cmskeystore.RecordDataHashGenerator;
import com.ibm.security.cmskeystore.RecordDataHashGeneratorFactory;
import com.ibm.security.cmskeystore.RecordEncoding;
import com.ibm.security.cmskeystore.RecordEncodingFactory;
import com.ibm.security.cmskeystore.RecordFactory$RawRecordImpl;
import com.ibm.security.cmskeystore.RecordFactory$RecordImpl;
import com.ibm.security.cmskeystore.RecordFlag;
import com.ibm.security.sequence.bytes.ByteSequence;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;

final class RecordFactory {
    private RecordFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static Record newRecord(InputStream inputStream) throws NullPointerException, IllegalArgumentException, BadRecordFlagException, IOException {
        return RecordFactory.newRecord(inputStream, 0, 0);
    }

    public static Record newRawRecord(InputStream inputStream, int n) throws IllegalArgumentException, IOException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        return new RecordFactory$RawRecordImpl(ByteSequenceInputStreamFactory.newByteSequenceInputStream().getByteSequence(inputStream, n));
    }

    public static Record newRecord(InputStream inputStream, int n, int n2) throws NullPointerException, IllegalArgumentException, BadRecordFlagException, IOException {
        int n3;
        Buffer buffer;
        Buffer buffer2;
        Buffer buffer3;
        Buffer buffer4;
        Buffer buffer5;
        if (inputStream == null) {
            throw new NullPointerException();
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        ByteSequenceInputStream byteSequenceInputStream = ByteSequenceInputStreamFactory.newByteSequenceInputStream();
        ByteSequence byteSequence = byteSequenceInputStream.getByteSequence(inputStream, 4);
        if (byteSequence == null) {
            return null;
        }
        RecordFlag recordFlag = RecordFlag.recordFlagFromByteSequence(IntableByteSequenceFactory.newIntableByteSequence(byteSequence));
        if (recordFlag == null) {
            throw new BadRecordFlagException();
        }
        byteSequence = byteSequenceInputStream.getByteSequence(inputStream, 4);
        if (byteSequence == null) {
            return null;
        }
        IntableByteSequence intableByteSequence = n2 == 0 ? IntableByteSequenceFactory.newIntableByteSequence(byteSequence) : IntableByteSequenceFactory.newIntableByteSequence(n2);
        RecordEncoding recordEncoding = n2 == 0 ? RecordEncodingFactory.newRecordEncoding(BufferFactory.newBuffer(inputStream)) : RecordEncodingFactory.newRecordEncoding(BufferFactory.newBufferWithLatestRecID(inputStream, n2));
        if (recordEncoding == null) {
            return null;
        }
        Buffer buffer6 = BufferFactory.newBuffer(inputStream);
        if (buffer6 == null) {
            return null;
        }
        byteSequence = byteSequenceInputStream.getByteSequence(inputStream, 4);
        if (byteSequence == null) {
            return null;
        }
        IntableByteSequence intableByteSequence2 = IntableByteSequenceFactory.newIntableByteSequence(byteSequence);
        try {
            RecordDataHashGenerator recordDataHashGenerator = RecordDataHashGeneratorFactory.newRecordDataHashGenerator();
            X509Certificate x509Certificate = (X509Certificate)recordEncoding.getCertificate();
            buffer5 = recordDataHashGenerator.generateCertificateSignatureHash(x509Certificate);
            buffer4 = recordDataHashGenerator.generateTBSCertificateHash(x509Certificate);
            buffer3 = recordDataHashGenerator.generateSubjectNameHash(x509Certificate);
            buffer2 = recordDataHashGenerator.generateSubjectPublicKeyInfoHash(x509Certificate);
            buffer = recordDataHashGenerator.generateIssuerAndSerialNumberHash(x509Certificate);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        int n4 = recordFlag.length() + intableByteSequence.length() + recordEncoding.length() + buffer6.length() + intableByteSequence2.length();
        int n5 = n3 = n == 0 ? 0 : n - n4;
        if (n3 < 0) {
            throw new IllegalArgumentException("Invalid parameter 'length' value: " + n + "for newRecord");
        }
        if (n3 > 0) {
            byteSequenceInputStream.getByteSequence(inputStream, n3);
        }
        int n6 = buffer5.length() + buffer4.length() + buffer3.length() + buffer2.length() + buffer.length();
        return new RecordFactory$RecordImpl(recordFlag, intableByteSequence, recordEncoding, buffer6, intableByteSequence2, buffer5, buffer4, buffer3, buffer2, buffer, n3 - n6);
    }
}

