/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.BadFileTypeException;
import com.ibm.security.cmskeystore.BadMagicNumberException;
import com.ibm.security.cmskeystore.BadRecordFlagException;
import com.ibm.security.cmskeystore.BadVersionNumberException;
import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.FileHeaderFactory;
import com.ibm.security.cmskeystore.KeyDatabase;
import com.ibm.security.cmskeystore.KeyDatabaseFactory$KeyDatabaseImpl;
import com.ibm.security.cmskeystore.Record;
import com.ibm.security.cmskeystore.RecordFactory;
import com.ibm.security.sequence.SequenceFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

final class KeyDatabaseFactory {
    private KeyDatabaseFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static KeyDatabase newKeyDatabase(InputStream inputStream, boolean bl) throws NullPointerException, BadMagicNumberException, BadVersionNumberException, BadFileTypeException, BadRecordFlagException, IOException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        FileHeader fileHeader = FileHeaderFactory.newFileHeader(inputStream);
        if (fileHeader == null) {
            return null;
        }
        LinkedList<Record> linkedList = new LinkedList<Record>();
        int n = fileHeader.getRecordsAllocated().toInt();
        for (int i = 0; i < n; ++i) {
            Record record = bl ? RecordFactory.newRawRecord(inputStream, fileHeader.getFixedRecordLength().toInt()) : RecordFactory.newRecord(inputStream, fileHeader.getFixedRecordLength().toInt(), i + 1);
            if (record == null) {
                return null;
            }
            linkedList.add(record);
        }
        return new KeyDatabaseFactory$KeyDatabaseImpl(fileHeader, SequenceFactory.newSequence(linkedList));
    }

    public static KeyDatabase newKeyDatabase(InputStream inputStream) throws NullPointerException, BadMagicNumberException, BadVersionNumberException, BadFileTypeException, BadRecordFlagException, IOException {
        return KeyDatabaseFactory.newKeyDatabase(inputStream, false);
    }
}

