/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.ByteSequenceXorFactory;
import com.ibm.security.cmskeystore.DatabaseHashGenerator;
import com.ibm.security.cmskeystore.DatabaseHashGeneratorFactory$1;
import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.KeyDatabase;
import com.ibm.security.cmskeystore.Record;
import com.ibm.security.cmskeystore.RecordHashGeneratorFactory;
import com.ibm.security.sequence.Sequence;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class DatabaseHashGeneratorFactory$DatabaseHashGeneratorV3Impl
implements DatabaseHashGenerator {
    private DatabaseHashGeneratorFactory$DatabaseHashGeneratorV3Impl() {
    }

    public ByteSequence generateHash(KeyDatabase keyDatabase, String string) throws NullPointerException, NoSuchAlgorithmException, IOException {
        if (keyDatabase == null || string == null) {
            throw new NullPointerException();
        }
        FileHeader fileHeader = keyDatabase.getHeader();
        Sequence sequence = keyDatabase.getRecords();
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        ByteSequenceIterator byteSequenceIterator = fileHeader.getMagicNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getMajorVersionNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getMinorVersionNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getPasswordExpirationTime().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFileType().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFixedRecordLength().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getRecordsAllocated().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFileLabel().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getPasswordHeaderHash().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        ByteSequence byteSequence = ByteSequenceFactory.newByteSequence(string.getBytes("UTF-8"));
        byteSequenceIterator = byteSequence.getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        ByteSequence byteSequence2 = ByteSequenceFactory.newByteSequence(messageDigest.digest());
        for (Record record : sequence) {
            ByteSequence byteSequence3 = RecordHashGeneratorFactory.newRecordHashGenerator(keyDatabase.getHeader()).generateHash(fileHeader, record, string);
            byteSequence2 = ByteSequenceXorFactory.newByteSequenceXor().xor(byteSequence2, byteSequence3);
        }
        return byteSequence2;
    }

    DatabaseHashGeneratorFactory$DatabaseHashGeneratorV3Impl(DatabaseHashGeneratorFactory$1 databaseHashGeneratorFactory$1) {
        this();
    }
}

